/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.schedule;

import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleForm;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleFormPopulator;
import com.tandbergtv.watchpoint.pmm.web.util.CommonUtils;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.actions.MappingDispatchAction;
import org.apache.struts.config.ForwardConfig;

public class ScheduleAction
extends MappingDispatchAction {
    private static final Logger logger = Logger.getLogger(ScheduleAction.class);
    private ISchedulePersistenceService service = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);

    public ActionForward get(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleForm form = (ScheduleForm)actionform;
        String id = form.getScheduleId();
        logger.debug((Object)("Schedule id " + id));
        Schedule schedule = this.service.get((Serializable)Long.valueOf(Long.parseLong(id)));
        ScheduleFormPopulator.populateScheduleForm(form);
        form.setSchedule(schedule);
        return mapping.findForward("default");
    }

    public ActionForward showCreatePage(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleForm form = (ScheduleForm)actionform;
        ScheduleFormPopulator.populateScheduleForm(form);
        return mapping.findForward("default");
    }

    public ActionForward save(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleForm form = (ScheduleForm)actionform;
        Schedule schedule = this.getSchedule(form);
        this.service.save(schedule);
        form.setScheduleId(schedule.getId().toString());
        ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("default"));
        redirect.addParameter("scheduleId", (Object)schedule.getId().toString());
        return redirect;
    }

    public ActionForward changeStatus(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleForm form = (ScheduleForm)actionform;
        String id = form.getScheduleId();
        logger.debug((Object)("Schedule id " + id));
        Schedule schedule = this.service.get((Serializable)Long.valueOf(Long.parseLong(id)));
        if (schedule instanceof Planner) {
            throw new RuntimeException("Cannot change status of planner " + schedule);
        }
        ScheduleStatus status = schedule.getStatus();
        if (status == ScheduleStatus.NEW || status == ScheduleStatus.READY) {
            schedule.setStatus(ScheduleStatus.APPROVED);
        } else {
            schedule.setStatus(ScheduleStatus.NEW);
        }
        this.service.save(schedule);
        ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("default"));
        redirect.addParameter("scheduleId", (Object)schedule.getId().toString());
        return redirect;
    }

    public ActionForward delete(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleForm form = (ScheduleForm)actionform;
        String id = form.getScheduleId();
        logger.debug((Object)("Schedule id " + id));
        Schedule schedule = this.service.get((Serializable)Long.valueOf(Long.parseLong(id)));
        this.service.delete(schedule);
        ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("default"));
        return redirect;
    }

    private Schedule getSchedule(ScheduleForm form) throws Exception {
        Long sourcePartnerId = null;
        String tmp = form.getSourcePartnerId();
        if (tmp != null && tmp.length() > 0) {
            sourcePartnerId = Long.parseLong(tmp);
        }
        Long contextId = Long.parseLong(form.getContextId());
        String format = CommonUtils.getApplicationUIResourceBundle().getString("dateFormat");
        Date date = new SimpleDateFormat(format).parse(form.getDate());
        DistributionSchedule schedule = null;
        if (form.getScheduleId() != null && form.getScheduleId().trim().length() > 0) {
            schedule = (DistributionSchedule)this.service.get((Serializable)Long.valueOf(Long.parseLong(form.getScheduleId())));
            schedule.setPitchDate(date);
            schedule.setContextID(contextId);
            schedule.setSourcePartnerID(sourcePartnerId);
        } else {
            schedule = new DistributionSchedule(sourcePartnerId, contextId, date);
        }
        return schedule;
    }
}

