/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.schedule;

import com.tandbergtv.watchpoint.pmm.entities.ScheduleProxy;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleRequest;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleTimetableForm;
import com.tandbergtv.watchpoint.pmm.web.search.AbstractSearchCriteriaBuilder;
import com.tandbergtv.watchpoint.pmm.web.util.PMMPageConfig;
import com.tandbergtv.watchpoint.pmm.web.util.PMMPageconfigHelper;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.web.page.Field;
import com.tandbergtv.workflow.web.page.Page;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;

public class ScheduleCriteriaBuilder
extends AbstractSearchCriteriaBuilder {
    private HttpServletRequest request;
    private ActionForm form;
    private static final Logger logger = Logger.getLogger(ScheduleCriteriaBuilder.class);

    private ScheduleCriteriaBuilder(HttpServletRequest request, ActionForm form) {
        this.request = request;
        this.form = form;
    }

    public static ScheduleCriteriaBuilder newInstance(HttpServletRequest request, ActionForm form) {
        return new ScheduleCriteriaBuilder(request, form);
    }

    @Override
    public SearchCriteria getSearchCriteria() {
        SearchCriteria criteria = super.getSearchCriteria();
        ScheduleTimetableForm form = (ScheduleTimetableForm)((Object)ScheduleTimetableForm.class.cast(this.getForm()));
        Date start = form.getCurrent();
        Date end = this.getMonthEnd(start);
        logger.debug((Object)("Start " + start + " end " + end));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, formatter.format(start));
        range.setTo(formatter.format(end));
        Entity e = this.getEntity(criteria);
        e.addParameter((SearchParameterBase)range);
        return criteria;
    }

    @Override
    protected SearchCriteria getDefaultSearchCriteria() {
        SearchCriteria criteria = new SearchCriteria();
        Entity schedule = new Entity("schedule", ScheduleProxy.class, "s");
        schedule.addParameter((SearchParameterBase)new ValueParameter("isActive", SearchType.NUMERIC, (Object)1));
        ListParameter types = new ListParameter(ScheduleSearchKey.TITLE_LIST_TYPE.toString(), SearchType.NUMERIC);
        types.addValues(new Object[]{TitleListType.PLANNER.ordinal(), TitleListType.PITCH.ordinal()});
        schedule.addParameter((SearchParameterBase)types);
        criteria.addParameter((SearchParameterBase)schedule);
        return criteria;
    }

    @Override
    protected Entity getEntity(SearchCriteria criteria) {
        return (Entity)criteria.getParameter("schedule", Entity.class);
    }

    @Override
    protected Page getPage() {
        Page page = null;
        try {
            page = PMMPageConfig.getInstance().getPage("schedulesearch", PMMPageconfigHelper.getPageConfigFile());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build search page", e);
        }
        return page;
    }

    @Override
    protected ActionForm getForm() {
        return this.form;
    }

    @Override
    protected HttpServletRequest getRequest() {
        return this.request;
    }

    private Date getMonthEnd(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int max = ((Calendar)calendar).getActualMaximum(5);
        calendar.set(5, max - 1);
        return calendar.getTime();
    }

    @Override
    protected void addSearchCriteria(SearchCriteria criteria, Field field, String ... values) {
        if (!this.skipField(field.getName())) {
            super.addSearchCriteria(criteria, field, values);
        }
    }

    private boolean skipField(String name) {
        return name.equals(ScheduleRequest.MONTH_PARAMETER.toString()) || name.equals(ScheduleRequest.YEAR_PARAMETER.toString());
    }
}

