/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.schedule;

import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationGeneratorFactory;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.web.schedule.PartnerBean;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleStatistics;
import com.tandbergtv.watchpoint.pmm.web.title.TitleProgressBean;
import com.tandbergtv.watchpoint.pmm.web.util.CommonUtils;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.web.formbeans.PaginationAndSortingForm;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ScheduleForm
extends PaginationAndSortingForm {
    private Schedule schedule;
    private String scheduleId;
    private ScheduleStatistics statistics;
    private String contextId;
    private String date;
    private String sourcePartnerId;
    private Collection<PartnerBean> sources;
    private Collection<PartnerBean> destinations;
    private PartnerBean source;
    private PartnerBean destination;
    private Table table;
    private String[] selectedTitles;
    private String status;
    private String spec;
    private static final long serialVersionUID = -8393735592997672089L;
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
        Long id = schedule.getSourcePartnerID();
        if (id != null) {
            this.setSourcePartnerId(id.toString());
            if (this.sources != null) {
                for (PartnerBean partner : this.sources) {
                    if (!id.equals(partner.getId())) continue;
                    this.source = partner;
                }
            }
        }
        if (schedule instanceof DistributionSchedule) {
            PartnerBean destPartner;
            DistributionSchedule d = (DistributionSchedule)DistributionSchedule.class.cast(schedule);
            this.setContextId(d.getContextID().toString());
            this.setDate(CommonUtils.formatDate(d.getPitchDate()));
            ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
            IContainer container = (IContainer)containerCache.get((Serializable)d.getContextID());
            this.destination = destPartner = new PartnerBean(container.getContainerId(), container.getContainerName(), d.getContextID());
        } else if (schedule instanceof Planner) {
            Planner planner = (Planner)Planner.class.cast(schedule);
            this.setDate(CommonUtils.formatDate(planner.getArrivalDate()));
        }
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String id) {
        this.scheduleId = id;
    }

    public ScheduleStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(ScheduleStatistics statistics) {
        this.statistics = statistics;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String pitchDate) {
        this.date = pitchDate;
    }

    public String getSourcePartnerId() {
        return this.sourcePartnerId;
    }

    public void setSourcePartnerId(String sourcePartnerId) {
        this.sourcePartnerId = sourcePartnerId;
    }

    public Collection<PartnerBean> getSources() {
        return this.sources;
    }

    public void setSources(Collection<PartnerBean> sources) {
        this.sources = sources;
    }

    public Collection<PartnerBean> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<PartnerBean> destinations) {
        this.destinations = destinations;
    }

    public PartnerBean getSource() {
        return this.source;
    }

    public void setSource(PartnerBean source) {
        this.source = source;
    }

    public PartnerBean getDestination() {
        return this.destination;
    }

    public void setDestination(PartnerBean destination) {
        this.destination = destination;
    }

    public boolean getIsPlanner() {
        return this.schedule instanceof Planner;
    }

    public boolean getIsDistributionSchedule() {
        return this.schedule instanceof DistributionSchedule;
    }

    public Collection<TitleProgressBean> getTitles() {
        NotificationGeneratorFactory factory = NotificationGeneratorFactory.newInstance();
        ArrayList<TitleProgressBean> list = new ArrayList<TitleProgressBean>();
        INotificationGenerator generator = factory.newGenerator(this.schedule);
        Notification notification = generator.getNotification(this.schedule);
        for (Title title : this.schedule.getTitles()) {
            Schedule planner = null;
            Collection<ProgressItem> items = null;
            if (this.schedule.getType() == TitleListType.PITCH) {
                planner = this.findPlanner(title);
                items = this.getProgressItemsForPitch(title, planner);
            } else {
                items = this.schedule.getProgressItems(title);
            }
            ITitleService service = (ITitleService)ServiceRegistry.getDefault().lookup(ITitleService.class);
            Collection titleFields = service.getAllDecendantFields(title.getId().longValue());
            TitleProgressBean progress = new TitleProgressBean(title, items);
            progress.setTitleFields(titleFields);
            if (planner != null) {
                Long partnerId = planner.getSourcePartnerID();
                PartnerBean plannerSource = null;
                if (this.sources != null) {
                    for (PartnerBean partner : this.sources) {
                        if (!partnerId.equals(partner.getId())) continue;
                        plannerSource = partner;
                    }
                }
                progress.addPlanner(planner, plannerSource);
            }
            if (notification != null) {
                for (Title t : notification.getTitles()) {
                    if (!t.equals((Object)title)) continue;
                    progress.setHasAlert(true);
                }
            }
            list.add(progress);
        }
        Collections.sort((List)list);
        return list;
    }

    private Schedule findPlanner(Title title) {
        Schedule planner = null;
        for (IAssetList assetlist : title.getTitlelists()) {
            Schedule schedule = (Schedule)Schedule.class.cast(assetlist);
            if (schedule.getType() != TitleListType.PLANNER || schedule.getDate().after(this.schedule.getDate()) || planner != null && !planner.getDate().before(schedule.getDate())) continue;
            planner = schedule;
        }
        return planner;
    }

    private Collection<ProgressItem> getProgressItemsForPitch(Title title, Schedule planner) {
        ArrayList<ProgressItem> progressItems = new ArrayList<ProgressItem>();
        if (planner != null) {
            for (ProgressItem progressItem : title.getProgressItems()) {
                if (!planner.getId().equals(progressItem.getAssetListId())) continue;
                progressItems.add(progressItem);
            }
        }
        for (ProgressItem progressItem : title.getProgressItems()) {
            Long assetListId = progressItem.getAssetListId();
            if (assetListId != null && !this.schedule.getId().equals(assetListId)) continue;
            progressItems.add(progressItem);
        }
        return progressItems;
    }

    public int getNumberOfTitles() {
        return this.schedule.getTitles().size();
    }

    public Table getTable() {
        return this.table;
    }

    protected void setTable(String tableId, File configFile) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("specificationName", this.getSpec());
        this.table = TableConfig.getInstance().getTable(tableId, configFile, properties);
    }

    public void setTableId(String tableId, File configFile) {
        this.setTable(tableId, configFile);
    }

    public String[] getSelectedTitles() {
        return this.selectedTitles;
    }

    public void setSelectedTitles(String[] selectedTitles) {
        this.selectedTitles = selectedTitles;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSpec() {
        return this.spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
}

