/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.schedule;

import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.web.schedule.PartnerBean;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleForm;
import com.tandbergtv.watchpoint.pmm.web.title.search.PitchDestinationDataProvider;
import com.tandbergtv.watchpoint.pmm.web.title.search.PlannerSourceDataProvider;
import com.tandbergtv.watchpoint.pmm.web.util.CommonUtils;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScheduleFormPopulator {
    private static final Logger logger = Logger.getLogger(ScheduleFormPopulator.class);

    public static void populateScheduleForm(ScheduleForm form) {
        form.setSources(ScheduleFormPopulator.getSources());
        form.setDestinations(ScheduleFormPopulator.getDestinations());
    }

    public static void repopulateFormFields(ScheduleForm scheduleForm) {
        ScheduleFormPopulator.populateScheduleForm(scheduleForm);
        String userDate = scheduleForm.getDate();
        String userSourcePartnerId = scheduleForm.getSourcePartnerId();
        if (scheduleForm.getScheduleId() != null && scheduleForm.getScheduleId().trim().length() > 0) {
            ISchedulePersistenceService service = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
            Schedule schedule = service.get((Serializable)Long.valueOf(Long.parseLong(scheduleForm.getScheduleId())));
            scheduleForm.setSchedule(schedule);
            scheduleForm.setSourcePartnerId(userSourcePartnerId);
            scheduleForm.setDate(userDate);
        } else {
            DistributionSchedule s = new DistributionSchedule();
            if (scheduleForm.getSourcePartnerId() != null && scheduleForm.getSourcePartnerId().trim().length() > 0) {
                s.setSourcePartnerID(Long.valueOf(Long.parseLong(scheduleForm.getSourcePartnerId())));
            }
            s.setContextID(Long.valueOf(Long.parseLong(scheduleForm.getContextId())));
            try {
                s.setPitchDate(CommonUtils.getDate(userDate));
            }
            catch (RuntimeException e) {
                logger.warn((Object)("Not setting schedule's pitch date because of error: " + e));
            }
            scheduleForm.setSchedule((Schedule)s);
            scheduleForm.setDate(userDate);
        }
    }

    private static Collection<PartnerBean> getDestinations() {
        ArrayList<PartnerBean> destinations = new ArrayList<PartnerBean>();
        PitchDestinationDataProvider dataprovider = new PitchDestinationDataProvider();
        Map data = dataprovider.getData();
        for (String key : data.keySet()) {
            destinations.add(new PartnerBean(Long.valueOf(key), (String)data.get(key)));
        }
        return destinations;
    }

    private static Collection<PartnerBean> getSources() {
        ArrayList<PartnerBean> sources = new ArrayList<PartnerBean>();
        PlannerSourceDataProvider dataprovider = new PlannerSourceDataProvider();
        Map data = dataprovider.getData();
        for (String key : data.keySet()) {
            sources.add(new PartnerBean(Long.valueOf(key), (String)data.get(key)));
        }
        return sources;
    }
}

