/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.schedule;

import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.IRightsManager;
import com.tandbergtv.watchpoint.pmm.title.conf.specs.RightsManagerFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;

public class ScheduleStatistics {
    private Schedule schedule;
    private Collection<Schedule> previous;

    public ScheduleStatistics(Schedule schedule, Collection<Schedule> previous) {
        this.schedule = schedule;
        this.previous = previous;
    }

    public int getTotalTitles() {
        return this.schedule.getTitles().size();
    }

    public int getDraftTitles() {
        int count = 0;
        Collection titles = this.schedule.getTitles();
        for (Title t : titles) {
            if (t.getStatus() != TitleStatus.DRAFT) continue;
            ++count;
        }
        return count;
    }

    public int getCommittedTitles() {
        int count = 0;
        Collection titles = this.schedule.getTitles();
        for (Title t : titles) {
            if (t.getStatus() != TitleStatus.COMMITTED) continue;
            ++count;
        }
        return count;
    }

    public int getReadyTitles() {
        int count = 0;
        Collection titles = this.schedule.getTitles();
        for (Title t : titles) {
            if (t.getStatus() != TitleStatus.READY) continue;
            ++count;
        }
        return count;
    }

    public int getApprovedTitles() {
        int count = 0;
        Collection titles = this.schedule.getTitles();
        for (Title t : titles) {
            if (t.getStatus() != TitleStatus.APPROVED) continue;
            ++count;
        }
        return count;
    }

    public String getTotalRunTime() {
        long time = this.getTotalRunTime(this.schedule.getTitles());
        Date date = new Date(time);
        return this.getFormattedDate(date);
    }

    public String getTotalNewHours() {
        long time = this.getTotalRunTime(this.getCurrentTitles());
        Date date = new Date(time);
        return this.getFormattedDate(date);
    }

    public int getRefreshRate() {
        if (this.previous == null) {
            return 100;
        }
        Collection<Title> titles = this.getCurrentTitles();
        long tcurrent = this.getTotalRunTime(titles);
        if (tcurrent == 0L) {
            return 0;
        }
        long tprev = 0L;
        IRightsManager rm = RightsManagerFactory.getRightsManager();
        for (Title title : this.getExistingTitles()) {
            if (rm == null || !rm.isLicensed(title, this.schedule.getDate())) continue;
            tprev += this.getRunTime(title);
        }
        return (int)(tcurrent * 100L / (tprev + tcurrent));
    }

    private Collection<Title> getExistingTitles() {
        HashSet<Title> titles = new HashSet<Title>();
        for (Schedule s : this.previous) {
            for (Title title : s.getTitles()) {
                titles.add(title);
            }
        }
        return titles;
    }

    private Collection<Title> getCurrentTitles() {
        ArrayList<Title> titles = new ArrayList<Title>(this.schedule.getTitles());
        for (Schedule s : this.previous) {
            Iterator i = titles.iterator();
            while (i.hasNext()) {
                Title title = (Title)i.next();
                if (!s.getTitles().contains(title)) continue;
                i.remove();
            }
        }
        return titles;
    }

    private long getTotalRunTime(Collection<Title> titles) {
        long time = 0L;
        for (Title title : titles) {
            time += this.getRunTime(title);
        }
        return time;
    }

    private long getRunTime(Title title) {
        DateFormat formatter = this.getFormatter();
        long time = 0L;
        ITitleService service = (ITitleService)ServiceRegistry.getDefault().lookup(ITitleService.class);
        String fieldValue = TitleUtil.getMetadataValue((Collection)service.getAllDecendantFields(title.getId().longValue()), (String)"/tns:Fields/tns:Duration/tns:Duration", (String)"TITLE");
        if (fieldValue != null && fieldValue.trim().length() > 0) {
            try {
                time = formatter.parse(fieldValue.trim()).getTime();
            }
            catch (ParseException e) {
                return time;
            }
            return time;
        }
        return time;
    }

    private DateFormat getFormatter() {
        String format = "HH:mm:ss";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter;
    }

    private String getFormattedDate(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        Integer day = calendar.get(6) - 1;
        if (day == 0) {
            return this.getFormatter().format(date);
        }
        if (day == 1) {
            return day.toString() + " day";
        }
        return day.toString() + " days";
    }
}

