/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.schedule;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.web.schedule.PartnerBean;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleCriteriaBuilder;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleRequest;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleTimetableForm;
import com.tandbergtv.watchpoint.pmm.web.util.CommonUtils;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

public class ScheduleTimetableAction
extends MappingDispatchAction {
    private IScheduleSearchService service = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
    private static final Logger logger = Logger.getLogger(ScheduleTimetableAction.class);

    public ActionForward getSchedules(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleTimetableForm form = (ScheduleTimetableForm)actionform;
        Date date = this.getStartDate(form);
        form.setCurrent(date);
        form.setQuery(this.getQueryString(request));
        logger.debug((Object)("Current month " + form.getCurrent()));
        ScheduleCriteriaBuilder builder = ScheduleCriteriaBuilder.newInstance(request, (ActionForm)form);
        SearchCriteria criteria = builder.getSearchCriteria();
        Collection schedules = this.service.search(criteria);
        for (Schedule schedule : schedules) {
            PartnerBean partner = this.getPartner(schedule);
            form.addSchedule(schedule, partner);
        }
        return mapping.findForward("default");
    }

    private Date getCurrentMonth(ScheduleTimetableForm form) throws ParseException {
        String s = form.getStartDate();
        if (s == null || s.length() == 0) {
            return new Date();
        }
        logger.debug((Object)("Start " + s));
        String format = CommonUtils.getApplicationUIResourceBundle().getString("dateFormat");
        return new SimpleDateFormat(format).parse(s);
    }

    private PartnerBean getPartner(Schedule schedule) {
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Container Cache");
        PartnerBean partner = null;
        if (schedule.getType() == TitleListType.PITCH) {
            IContainer container = (IContainer)cache.get((Serializable)schedule.getContextID());
            partner = new PartnerBean(container.getContainerId(), container.getContainerName(), schedule.getContextID());
        } else if (schedule.getType() == TitleListType.PLANNER) {
            Long partnerId = schedule.getSourcePartnerID();
            for (Serializable key : cache.getKeys()) {
                IContainer c = (IContainer)cache.get(key);
                if (c.getContainerId() != partnerId.longValue() || c.getContainerType() != ContainerType.PARTNER) continue;
                partner = new PartnerBean(c.getContainerId(), c.getContainerName(), (Long)key);
                break;
            }
        } else {
            throw new ScheduleRuntimeException("Unknown schedule type: " + schedule.getType());
        }
        return partner;
    }

    private String getQueryString(HttpServletRequest request) {
        String query = request.getQueryString();
        if (query == null) {
            query = "";
        }
        logger.debug((Object)("Query " + query));
        String startDate = request.getParameter(ScheduleRequest.STARTDATE_PARAMETER.toString());
        if (startDate != null) {
            query = query.replace(ScheduleRequest.STARTDATE.toString() + startDate, "");
        }
        query = query.replace(ScheduleRequest.STARTDATE_PARAMETER.toString() + "=" + startDate, "");
        String month = request.getParameter(ScheduleRequest.MONTH_PARAMETER.toString());
        month = month == null ? "" : month;
        query = query.replace(ScheduleRequest.MONTH.toString() + month, "");
        String year = request.getParameter(ScheduleRequest.YEAR_PARAMETER.toString());
        year = year == null ? "" : year;
        query = query.replace(ScheduleRequest.YEAR.toString() + year, "");
        return request.getRequestURI() + "?" + query;
    }

    private Date getStartDate(ScheduleTimetableForm form) throws ParseException {
        String month = form.getMonth();
        String year = form.getYear();
        if (month != null && month.trim().length() > 0 || year != null && year.trim().length() > 0) {
            if (month == null || month.trim().length() == 0) {
                Calendar cMonth = Calendar.getInstance();
                cMonth.setTime(new Date());
                month = String.valueOf(cMonth.get(2) + 1);
            }
            if (year == null || year.trim().length() == 0) {
                Calendar cYear = Calendar.getInstance();
                cYear.setTime(new Date());
                year = String.valueOf(cYear.get(1));
            }
            Calendar c = Calendar.getInstance();
            c.set(5, 1);
            c.set(2, Integer.parseInt(month) - 1);
            c.set(1, Integer.parseInt(year));
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            c.set(9, 0);
            return c.getTime();
        }
        return this.getCurrentMonth(form);
    }
}

