/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.title;

import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderRegistry;
import com.tandbergtv.watchpoint.pmm.title.search.ITitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchResult;
import com.tandbergtv.watchpoint.pmm.web.title.TitleListForm;
import com.tandbergtv.watchpoint.pmm.web.title.TitleRequest;
import com.tandbergtv.watchpoint.pmm.web.title.TitleSearchType;
import com.tandbergtv.watchpoint.pmm.web.title.search.TitleSearchCriteriaBuilder;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;

public class TitleListAction
extends DispatchAction {
    private static final Logger logger = Logger.getLogger(TitleListAction.class);

    public ActionForward search(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean export;
        logger.debug((Object)("Got search request " + request.getQueryString()));
        TitleListForm form = (TitleListForm)actionform;
        this.setView(form, request);
        form.setTableId();
        SearchCriteria criteria = TitleSearchCriteriaBuilder.newInstance(request, (ActionForm)form).getSearchCriteria();
        boolean bl = export = request.getParameter("exportData") != null && request.getParameter("exportData").toString().equals("export");
        if (export) {
            criteria.setStartingRecordNumber(0);
            criteria.setRecordsCount(Integer.MAX_VALUE);
        } else {
            criteria.setStartingRecordNumber(form.getStart());
            criteria.setRecordsCount(form.getPageSize());
        }
        logger.debug((Object)("Start " + criteria.getStartingRecordNumber() + ", count " + criteria.getRecordsCount()));
        TitleSearchResult result = this.getTitles(criteria);
        Collection titles = result.getTitles();
        if (titles != null) {
            logger.debug((Object)("Found " + titles.size() + ", total " + result.getCount()));
        }
        this.setExternalSource(form, request);
        form.setTitleSearchResult(result);
        form.setQuery(this.getQueryString(request));
        if (export) {
            return null;
        }
        logger.debug((Object)("Pages " + form.getNumberOfPages() + ", current page " + form.getCurrentPageNo()));
        return mapping.findForward("default");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TitleListForm form = (TitleListForm)actionform;
        ITitlePersistenceService service = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
        ArrayList<Long> failedTitles = new ArrayList<Long>();
        ArrayList<Long> successfulTitles = new ArrayList<Long>();
        ActionMessages messages = new ActionMessages();
        for (String id : form.getSelectedTitles()) {
            Title title = service.get((Serializable)Long.valueOf(Long.parseLong(id)));
            if (this.canDeleteTitle(title)) {
                logger.debug((Object)("Title " + title));
                service.delete((Serializable)title.getId());
                successfulTitles.add(title.getId());
                continue;
            }
            String errorMsg = "Could not delete " + title.getId() + " because it is associated with planner(s) or pitch schedule(s).";
            logger.error((Object)errorMsg);
            failedTitles.add(title.getId());
        }
        request.setAttribute("Multiple Titles", (Object)true);
        form.setFailedTitles(failedTitles);
        form.setSuccessfulTitles(successfulTitles);
        if (failedTitles.size() > 0) {
            String title = failedTitles.size() == 1 ? "Title is" : "Titles are";
            String errorMsg = title + " associated with planner(s) or pitch schedule(s).";
            messages.add("errorMessages", new ActionMessage("title.delete.errors", (Object)errorMsg));
            this.saveErrors(request, messages);
        }
        return mapping.findForward("deleted");
    }

    private boolean canDeleteTitle(Title title) {
        for (IAssetList list : title.getTitlelists()) {
            Schedule s = (Schedule)list;
            if (s.getType() != TitleListType.PLANNER && (s.getType() != TitleListType.PITCH || s.getStatus() != ScheduleStatus.APPROVED)) continue;
            return false;
        }
        return true;
    }

    private TitleSearchResult getTitles(SearchCriteria criteria) {
        ITitleSearchService service = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        TitleSearchResult result = service.getSearchResult(criteria);
        return result;
    }

    private String getQueryString(HttpServletRequest request) {
        String column;
        String order;
        String query = request.getQueryString();
        String start = (Object)((Object)TitleRequest.START) + request.getParameter(TitleRequest.START_PARAMETER.toString());
        query = query.replace(start, "");
        String size = request.getParameter(TitleRequest.PAGE_SIZE_PARAMETER.toString());
        if (size != null) {
            query = query.replace((Object)((Object)TitleRequest.PAGE_SIZE) + size, "");
        }
        if ((order = request.getParameter(TitleRequest.SORT_ORDER_PARAMETER.toString())) != null) {
            query = query.replace((Object)((Object)TitleRequest.SORT_ORDER) + order, "");
        }
        if ((column = request.getParameter(TitleRequest.SORT_COLUMN_PARAMETER.toString())) != null) {
            query = query.replace((Object)((Object)TitleRequest.SORT_COLUMN) + column, "");
        }
        return request.getRequestURI() + "?" + query;
    }

    private void setView(TitleListForm form, HttpServletRequest request) {
        boolean isExternal;
        String view = form.getView();
        boolean bl = isExternal = TitleSearchType.EXTERNAL == form.getSearchType();
        if (view == null || view.trim().length() == 0) {
            view = isExternal ? "external" : "basic";
            form.setView(view);
        }
    }

    private void setExternalSource(TitleListForm form, HttpServletRequest request) {
        boolean isExternal;
        boolean bl = isExternal = TitleSearchType.EXTERNAL == form.getSearchType();
        if (isExternal) {
            ServiceRegistry serviceRegistry = ServiceRegistry.getDefault();
            ITitleProviderRegistry registry = (ITitleProviderRegistry)serviceRegistry.lookup(ITitleProviderRegistry.class);
            String key = request.getParameter(TitleSearchKey.TITLE_EXTERNAL_LOCATION.toString());
            ITitleProvider externalProvider = registry.getProviderForTitle(key);
            String externalSourceName = externalProvider.getProviderInstance(key).getName();
            form.setExternalLocation(key);
            form.setExternalSourceName(externalSourceName);
        } else {
            form.setExternalLocation("");
            form.setExternalSourceName("");
        }
    }
}

