/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.title;

import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderInstance;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderRegistry;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchResult;
import com.tandbergtv.watchpoint.pmm.web.schedule.PartnerBean;
import com.tandbergtv.watchpoint.pmm.web.title.PagingForm;
import com.tandbergtv.watchpoint.pmm.web.title.TitleProgressBean;
import com.tandbergtv.watchpoint.pmm.web.title.TitleRequest;
import com.tandbergtv.watchpoint.pmm.web.title.TitleSearchType;
import com.tandbergtv.watchpoint.pmm.web.title.search.PitchDestinationDataProvider;
import com.tandbergtv.watchpoint.pmm.web.title.search.PlannerSourceDataProvider;
import com.tandbergtv.watchpoint.pmm.web.util.PMMTableConfigHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TitleListForm
extends PagingForm {
    private static final String CHAR_SET = "UTF-8";
    private Collection<TitleProgressBean> titles;
    private Table table;
    private static final String BASIC_TABLE_ID = "titlelist";
    private static final String EXTERNAL_TABLE_ID = "titlelist.external";
    public static final String BASIC_VIEW = "basic";
    public static final String EXTERNAL_VIEW = "external";
    private String[] selectedTitles = new String[0];
    private List<Long> successfulTitles;
    private List<Long> failedTitles;
    private String scheduleId;
    private String view;
    private String specification;
    private String externalLocation;
    private String externalSourceName;
    private TitleSearchType searchType = TitleSearchType.INTERNAL;
    private String method;
    private static final long serialVersionUID = 4724908612915737818L;

    public TitleListForm() {
        this.titles = new ArrayList<TitleProgressBean>();
    }

    public Collection<TitleProgressBean> getTitles() {
        return this.titles;
    }

    public Table getTable() {
        return this.table;
    }

    protected void setTable(String tableId, File configFile) {
        HashMap<String, String> runtimeProperties = new HashMap<String, String>();
        runtimeProperties.put("specificationName", this.specification);
        runtimeProperties.put("externalTitles", Boolean.toString(EXTERNAL_TABLE_ID.equals(tableId)));
        this.table = TableConfig.getInstance().getTable(tableId, configFile, runtimeProperties);
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String[] getSelectedTitles() {
        return this.selectedTitles;
    }

    public void setSelectedTitles(String[] selected) {
        this.selectedTitles = selected;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getExternalSourceName() {
        return this.externalSourceName;
    }

    public void setExternalSourceName(String externalSourceName) {
        this.externalSourceName = externalSourceName;
    }

    public String getExternalLocation() {
        return this.externalLocation;
    }

    public void setExternalLocation(String externalSourceId) {
        this.externalLocation = externalSourceId;
    }

    public String getTitleSearchType() {
        return this.searchType.name();
    }

    public void setTitleSearchType(String searchTypeValue) {
        TitleSearchType searchType = TitleSearchType.INTERNAL;
        if (searchTypeValue != null && searchTypeValue.trim().length() > 0) {
            searchType = TitleSearchType.valueOf(searchTypeValue);
        }
        this.setSearchType(searchType);
    }

    public TitleSearchType getSearchType() {
        return this.searchType;
    }

    protected void setSearchType(TitleSearchType searchType) {
        if (searchType == null) {
            searchType = TitleSearchType.INTERNAL;
        }
        this.searchType = searchType;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getBasicViewUrl() {
        String basic = (Object)((Object)TitleRequest.VIEW) + BASIC_VIEW;
        String parameter = TitleRequest.VIEW_PARAMETER.toString();
        return this.removeQueryStringParameter(this.getCurrentUrl(), parameter) + basic;
    }

    private String removeQueryStringParameter(String url, String parameter) {
        int queryStringIndex = url.indexOf("?");
        if (queryStringIndex == -1) {
            return url;
        }
        StringBuilder updatedURL = new StringBuilder();
        updatedURL.append(url.substring(0, queryStringIndex + 1));
        String queryString = url.substring(queryStringIndex + 1);
        String[] params = queryString.split("&");
        boolean firstParam = true;
        if (params != null) {
            for (String param : params) {
                String name;
                String[] paramDetails = param.split("=");
                if (paramDetails == null || parameter.equals((name = paramDetails[0]).trim())) continue;
                updatedURL.append((firstParam ? "" : "&") + param);
                firstParam = false;
            }
        }
        return updatedURL.toString();
    }

    public void setTableId() {
        String tableId = BASIC_TABLE_ID;
        if (EXTERNAL_VIEW.equals(this.getView())) {
            tableId = EXTERNAL_TABLE_ID;
        }
        this.setTable(tableId, PMMTableConfigHelper.getTableConfigFile());
    }

    public void setTitleSearchResult(TitleSearchResult result) {
        for (Title title : result.getTitles()) {
            this.addTitle(title);
        }
        this.setTotalRecords(result.getCount());
        int page = this.start / this.getPageSize() + 1;
        this.setCurrentPageNo(page);
    }

    private void addTitle(Title title) {
        TitleProgressBean bean = null;
        bean = this.getSearchType() == TitleSearchType.EXTERNAL ? this.buildExternalTitleBean(title) : this.buildInternalTitleBean(title);
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitleProviderRegistry providerRegistry = (ITitleProviderRegistry)registry.lookup(ITitleProviderRegistry.class);
        String externalLocation = title.getExternalLocation();
        ITitleProvider provider = providerRegistry.getProviderForTitle(externalLocation);
        String externalLocationName = "";
        if (provider != null) {
            ITitleProviderInstance instance = provider.getProviderInstance(externalLocation);
            String string = externalLocationName = instance != null ? instance.getName() : "";
            if (externalLocationName == null) {
                externalLocationName = "";
            }
        }
        bean.setExternalLocationName(externalLocationName);
        this.titles.add(bean);
    }

    @Deprecated
    private TitleProgressBean buildExternalTitleBean(Title title) {
        return null;
    }

    private String encodeURLValue(String value) {
        try {
            return URLEncoder.encode(value, CHAR_SET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to URL Encode value: " + value, e);
        }
    }

    private TitleProgressBean buildInternalTitleBean(Title title) {
        TitleProgressBean bean = new TitleProgressBean(title, title.getProgressItems());
        Schedule planner = this.getPlanner(title);
        if (planner != null) {
            PlannerSourceDataProvider dataprovider = new PlannerSourceDataProvider();
            Map sources = dataprovider.getData();
            String id = planner.getSourcePartnerID().toString();
            bean.addPlanner(planner, new PartnerBean(planner.getSourcePartnerID(), (String)sources.get(id)));
        }
        Collection<Schedule> pitches = this.getPitches(title);
        for (Schedule pitch : pitches) {
            PitchDestinationDataProvider provider = new PitchDestinationDataProvider();
            Map destinations = provider.getData();
            String id = pitch.getContextID().toString();
            bean.addPitch(pitch, new PartnerBean(pitch.getContextID(), (String)destinations.get(id), pitch.getContextID()));
        }
        return bean;
    }

    private Schedule getPlanner(Title title) {
        for (IAssetList list : title.getTitlelists()) {
            if (list.getType() != TitleListType.PLANNER) continue;
            Schedule planner = (Schedule)Schedule.class.cast(list);
            return planner;
        }
        return null;
    }

    private Collection<Schedule> getPitches(Title title) {
        ArrayList<Schedule> pitches = new ArrayList<Schedule>();
        for (IAssetList list : title.getTitlelists()) {
            if (list.getType() != TitleListType.PITCH) continue;
            Schedule pitch = (Schedule)Schedule.class.cast(list);
            pitches.add(pitch);
        }
        return pitches;
    }

    public List<Long> getSuccessfulTitles() {
        return this.successfulTitles;
    }

    public void setSuccessfulTitles(List<Long> successfulTitles) {
        this.successfulTitles = successfulTitles;
    }

    public List<Long> getFailedTitles() {
        return this.failedTitles;
    }

    public void setFailedTitles(List<Long> failedTitles) {
        this.failedTitles = failedTitles;
    }
}

