/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.title.search;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.title.search.EntityName;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.pmm.web.search.AbstractSearchCriteriaBuilder;
import com.tandbergtv.watchpoint.pmm.web.title.PagingForm;
import com.tandbergtv.watchpoint.pmm.web.title.TitleSearchType;
import com.tandbergtv.watchpoint.pmm.web.title.search.TitleSearchPageBuilder;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.Join;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import com.tandbergtv.workflow.web.page.Field;
import com.tandbergtv.workflow.web.page.Page;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;

public class TitleSearchCriteriaBuilder
extends AbstractSearchCriteriaBuilder {
    private HttpServletRequest request;
    private ActionForm form;
    private static final Logger logger = Logger.getLogger(TitleSearchCriteriaBuilder.class);

    private TitleSearchCriteriaBuilder(HttpServletRequest request, ActionForm form) {
        this.request = request;
        this.form = form;
    }

    public static TitleSearchCriteriaBuilder newInstance(HttpServletRequest request, ActionForm form) {
        return new TitleSearchCriteriaBuilder(request, form);
    }

    @Override
    protected HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    protected ActionForm getForm() {
        return this.form;
    }

    @Override
    protected Page getPage() {
        Page page = null;
        try {
            page = this.buildSearchPage(this.getRequest());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build search page", e);
        }
        return page;
    }

    @Override
    protected Entity getEntity(SearchCriteria criteria) {
        return (Entity)criteria.getParameter(EntityName.TITLE.toString(), Entity.class);
    }

    @Override
    public SearchCriteria getSearchCriteria() {
        SearchCriteria criteria = this.getDefaultSearchCriteria();
        String providerId = this.getTitleProviderId(this.request);
        criteria.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_PROVIDER_ID.toString(), SearchType.STRING, (Object)providerId));
        super.addSearchCriteria(criteria);
        this.addSortParameter(criteria);
        return criteria;
    }

    protected void addSortParameter(SearchCriteria criteria) {
        PagingForm pagingForm = (PagingForm)((Object)PagingForm.class.cast(this.form));
        String columnName = pagingForm.getSortingColumnName();
        if (columnName == null || columnName.length() == 0) {
            return;
        }
        String order = pagingForm.getSortingOrder();
        Table table = pagingForm.getTable();
        Column column = table.getColumnBySortName(columnName);
        logger.debug((Object)("Sort by " + columnName + " order " + order));
        if (column.getParameter() != null && this.getSearchType() == TitleSearchType.INTERNAL) {
            Entity title = this.getEntity(criteria);
            String sortProperty = TitleSearchKey.COMPLETE_METADATA.toString();
            if (column.getSortingProperty() != null) {
                sortProperty = column.getSortingProperty();
            }
            Entity e = new Entity(column.getParameter(), sortProperty, "m");
            e.setJoin(Join.LEFT_OUTER);
            e.setFetch(true);
            e.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.METADATA_NAME.toString(), SearchType.STRING, (Object)column.getParameter()));
            e.addParameter((SearchParameterBase)new SortParameter(TitleSearchKey.METADATA_VALUE.toString(), SortingOrder.valueOf((String)order)));
            title.addParameter((SearchParameterBase)e);
            logger.debug((Object)("Adding sort parameter " + column.getParameter()));
        } else {
            Entity title = this.getEntity(criteria);
            title.addParameter((SearchParameterBase)new SortParameter(columnName, SortingOrder.valueOf((String)order)));
        }
    }

    @Override
    protected void addSearchCriteria(SearchCriteria criteria, Field field, String ... values) {
        Entity title = this.getEntity(criteria);
        if (EntityName.METADATA.toString().equals(field.getEntity())) {
            Entity metadata = new Entity(field.getName(), TitleSearchKey.COMPLETE_METADATA.toString(), "m");
            SearchParameterBase parameter = this.getCriterion(field, TitleSearchKey.METADATA_VALUE.toString(), values);
            metadata.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.METADATA_NAME.toString(), SearchType.STRING, (Object)field.getName()));
            metadata.addParameter(parameter);
            title.addParameter((SearchParameterBase)metadata);
        } else if (EntityName.PLANNER.toString().equals(field.getEntity())) {
            Entity planner = new Entity(field.getName(), TitleSearchKey.TITLE_LISTS.toString(), "planner");
            SearchParameterBase parameter = this.getCriterion(field, field.getProperty(), values);
            planner.addParameter(parameter);
            planner.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.LIST_TYPE.toString(), SearchType.NUMERIC, (Object)TitleListType.PLANNER.ordinal()));
            title.addParameter((SearchParameterBase)planner);
        } else if (EntityName.PITCH.toString().equals(field.getEntity())) {
            Entity pitch = new Entity(field.getName(), TitleSearchKey.TITLE_LISTS.toString(), "pitch");
            SearchParameterBase parameter = this.getCriterion(field, field.getProperty(), values);
            pitch.addParameter(parameter);
            pitch.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.LIST_TYPE.toString(), SearchType.NUMERIC, (Object)TitleListType.PITCH.ordinal()));
            title.addParameter((SearchParameterBase)pitch);
        } else if (EntityName.PROGRESS.toString().equals(field.getEntity())) {
            Entity progress = new Entity(field.getName(), TitleSearchKey.PROGRESS_ITEMS.toString(), "progress");
            SearchParameterBase parameter = this.getCriterion(field, field.getProperty(), values);
            progress.addParameter(parameter);
            title.addParameter((SearchParameterBase)progress);
        } else {
            super.addSearchCriteria(criteria, field, values);
        }
    }

    @Override
    protected SearchCriteria getDefaultSearchCriteria() {
        SearchCriteria criteria = new SearchCriteria();
        Entity title = new Entity(EntityName.TITLE.toString(), Title.class, "t");
        title.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_PARENT.toString(), SearchType.STRING, (Object)null));
        title.addParameter((SearchParameterBase)new ValueParameter("isActive", SearchType.NUMERIC, (Object)1));
        criteria.addParameter((SearchParameterBase)title);
        return criteria;
    }

    private TitleSearchType getSearchType() {
        String searchTypeValue = this.getRequest().getParameter(TitleSearchKey.TITLE_SEARCH_TYPE.toString());
        TitleSearchType searchType = TitleSearchType.valueOf(searchTypeValue);
        return searchType;
    }

    private Page buildSearchPage(HttpServletRequest request) throws Exception {
        String specification = request.getParameter(TitleSearchKey.TITLE_SPEC.toString());
        TitleSearchType searchType = this.getSearchType();
        TitleSearchPageBuilder pageBuilder = TitleSearchPageBuilder.newInstance();
        return pageBuilder.buildSearchPage(searchType, specification);
    }

    private String getTitleProviderId(HttpServletRequest request) {
        String searchTypeValue = request.getParameter(TitleSearchKey.TITLE_SEARCH_TYPE.toString());
        TitleSearchType searchType = TitleSearchType.valueOf(searchTypeValue);
        String providerId = TitleSearchKey.DEFAULT_SYSTEM_ID.toString();
        if (searchType == TitleSearchType.EXTERNAL) {
            String instanceId = request.getParameter(TitleSearchKey.TITLE_EXTERNAL_LOCATION.toString());
            providerId = this.getTitleProviderId(instanceId);
        }
        return providerId;
    }

    private String getTitleProviderId(String externalSourceId) {
        String providerId = null;
        if (externalSourceId != null) {
            String[] values = externalSourceId.split("-");
            providerId = values.length > 0 ? values[0] : "";
        }
        return providerId;
    }
}

