/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.util;

import com.tandbergtv.watchpoint.pmm.entities.EntityType;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.job.conf.ParameterReferenceFileParser;
import com.tandbergtv.watchpoint.pmm.job.conf.ParameterReferenceGroup;
import com.tandbergtv.watchpoint.pmm.job.conf.ParameterReferenceItem;
import com.tandbergtv.watchpoint.pmm.job.util.ParameterReferenceHelper;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobParameterForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.OptionItemForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.OptionsGroupForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.RuleParameterForm;
import com.tandbergtv.watchpoint.pmm.web.util.JobParameterComparator;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class JobFormPopulator {
    private static Logger logger = Logger.getLogger(JobFormPopulator.class);
    private static String PARAMETER_COUNT_DELIMETER = ",";
    private static String PARAMETER_NAME_COUNT_DELIMETER = ";";
    private static int PARAMETER_NAME_INDEX = 0;
    private static int PARAMETER_COUNT_INDEX = 1;

    public static void setRequiredInfoInForm(JobForm jobform) {
        IJobManager jobMgr = JobManager.getInstance();
        List rules = jobMgr.getRuleTypes(Boolean.valueOf(jobform.getIsAssociatedWithTitles()).booleanValue());
        jobform.setScheduleRules(rules);
        logger.debug((Object)("Schedule rule list count: " + jobform.getScheduleRules().size()));
        StringBuilder parameterCount = new StringBuilder();
        for (int i = 0; i < rules.size(); ++i) {
            if (parameterCount.length() > 0) {
                parameterCount.append(PARAMETER_COUNT_DELIMETER);
            }
            parameterCount.append(((RuleType)rules.get(i)).getName() + PARAMETER_NAME_COUNT_DELIMETER + ((RuleType)rules.get(i)).getParams().size());
        }
        jobform.setRuleTypeParameterCount(parameterCount.toString());
        jobform.setTemplateNames(JobFormPopulator.getTemplateNames());
        logger.debug((Object)("Template list count: " + jobform.getTemplateNames().size()));
        ParameterReferenceFileParser parser = ParameterReferenceFileParser.getInstance();
        EntityType type = EntityType.toType((String)jobform.getEntityType());
        List parameterGroups = parser.getParameters(type, Boolean.valueOf(jobform.getIsAssociatedWithTitles()).booleanValue());
        List ruleGroups = parser.getRules(type);
        List<OptionsGroupForm> parameterForms = JobFormPopulator.prepareOptionForms(parameterGroups);
        List<OptionsGroupForm> ruleForms = JobFormPopulator.prepareOptionForms(ruleGroups);
        jobform.setRuleOptions(ruleForms);
        jobform.setParameterOptions(parameterForms);
        if (jobform.getSelectedTemplate() != null && jobform.getSelectedTemplate().length() > 0) {
            Collection<TaskVariable> variables = JobFormPopulator.getTemplateParameters(jobform.getSelectedTemplate());
            List<JobParameterForm> jobParameters = JobFormPopulator.prepareJobParameterForm(variables, jobform.getValue());
            jobform.setParams(jobParameters);
        }
        for (RuleType ruleType : rules) {
            if (ruleType.getName().equalsIgnoreCase(jobform.getSelectedRuleType())) {
                ArrayList<RuleParameterForm> ruleFormList = new ArrayList<RuleParameterForm>();
                String[] selectedRuleParams = JobFormPopulator.getRuleParamsForSelectedRule(jobform);
                for (int i = 0; i < selectedRuleParams.length; ++i) {
                    RuleParameterForm ruleParameterForm = new RuleParameterForm();
                    ruleParameterForm.setRuleParamValue(selectedRuleParams[i]);
                    ruleParameterForm.setOrder(i + 1);
                    ruleFormList.add(ruleParameterForm);
                }
                jobform.addRuleParam(jobform.getSelectedRuleType(), ruleFormList);
                continue;
            }
            jobform.addRuleParam(ruleType.getName(), JobFormPopulator.createDummyRuleParameters(ruleType));
        }
    }

    public static String[] getRuleParamsForSelectedRule(JobForm jobform) {
        String selectedRuleType = jobform.getSelectedRuleType();
        String[] rules = jobform.getRuleTypeParameterCount().split(PARAMETER_COUNT_DELIMETER);
        int offset = 0;
        int numberOfParams = 0;
        for (int i = 0; i < rules.length; ++i) {
            String[] nameCounts = rules[i].split(PARAMETER_NAME_COUNT_DELIMETER);
            if (!nameCounts[PARAMETER_NAME_INDEX].equalsIgnoreCase(selectedRuleType)) {
                offset += Integer.parseInt(nameCounts[PARAMETER_COUNT_INDEX]);
                continue;
            }
            numberOfParams = Integer.parseInt(nameCounts[PARAMETER_COUNT_INDEX]);
            break;
        }
        String[] selectedRuleParams = new String[numberOfParams];
        int i = offset;
        int j = 0;
        while (i < offset + numberOfParams) {
            selectedRuleParams[j] = jobform.getRuleParamValue()[i];
            ++i;
            ++j;
        }
        return selectedRuleParams;
    }

    private static List<String> getTemplateNames() {
        ArrayList<String> templateNames = new ArrayList<String>();
        try {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            ITemplateLoaderService templateLoader = (ITemplateLoaderService)registry.lookup(ITemplateLoaderService.class);
            List templates = templateLoader.getLatestTemplates();
            for (WorkflowTemplate t : templates) {
                templateNames.add(t.getName());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting template names: " + e.getMessage()));
        }
        return templateNames;
    }

    public static List<OptionsGroupForm> prepareOptionForms(List<ParameterReferenceGroup> options) {
        ArrayList<OptionsGroupForm> groups = new ArrayList<OptionsGroupForm>();
        for (ParameterReferenceGroup option : options) {
            List<OptionsGroupForm> groupForm = JobFormPopulator.createGroupForm(option, null);
            groups.addAll(groupForm);
        }
        return groups;
    }

    public static Collection<TaskVariable> getTemplateParameters(String templateName) {
        Collection<Object> params = new ArrayList<TaskVariable>();
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITemplateLoaderService templateLoader = (ITemplateLoaderService)registry.lookup(ITemplateLoaderService.class);
        List templates = templateLoader.getLatestTemplates();
        for (WorkflowTemplate t : templates) {
            if (!t.getName().equals(templateName)) continue;
            params = t.getStartTaskVariables();
            params = JobFormPopulator.sort(params);
            break;
        }
        return params;
    }

    private static Collection<TaskVariable> sort(Collection<TaskVariable> params) {
        ArrayList<TaskVariable> sortedParams = new ArrayList<TaskVariable>();
        ArrayList<TaskVariable> optionalParams = new ArrayList<TaskVariable>();
        for (TaskVariable tv : params) {
            if (tv.getAccess().isRequired()) {
                sortedParams.add(tv);
                continue;
            }
            optionalParams.add(tv);
        }
        sortedParams.addAll(optionalParams);
        return sortedParams;
    }

    public static List<JobParameterForm> prepareJobParameterForm(Collection<TaskVariable> variables, String[] values) {
        ArrayList<JobParameterForm> formList = new ArrayList<JobParameterForm>();
        TaskVariable[] taskVariables = new TaskVariable[variables.size()];
        taskVariables = variables.toArray(taskVariables);
        for (int i = 0; i < taskVariables.length; ++i) {
            TaskVariable tv = taskVariables[i];
            JobParameterForm jobParameterForm = new JobParameterForm();
            jobParameterForm.setName(tv.getMappedName());
            jobParameterForm.setRequired(tv.getAccess().isRequired());
            jobParameterForm.setType(tv.getDatatype().toString());
            if (values != null) {
                jobParameterForm.setValue(values[i]);
            }
            formList.add(jobParameterForm);
        }
        return formList;
    }

    private static ArrayList<RuleParameterForm> createDummyRuleParameters(RuleType ruleType) {
        ArrayList<RuleParameterForm> ruleParams = new ArrayList<RuleParameterForm>();
        for (int i = 0; i < ruleType.getParams().size(); ++i) {
            RuleParameterForm form = new RuleParameterForm();
            if (((RuleTypeParameter)ruleType.getParams().get(i)).getType() == RuleParameterDataType.TIME) {
                form.setRuleParamValue("12:00 am");
            }
            ruleParams.add(form);
        }
        return ruleParams;
    }

    private static List<OptionsGroupForm> createGroupForm(ParameterReferenceGroup group, OptionsGroupForm parent) {
        ArrayList<OptionsGroupForm> groupFormList = new ArrayList<OptionsGroupForm>();
        OptionsGroupForm groupForm = new OptionsGroupForm();
        String groupName = "";
        groupName = parent != null ? ParameterReferenceHelper.combineGroupNames((String)parent.getName(), (String)group.getName()) : group.getName();
        groupForm.setName(groupName);
        groupForm.setParent(parent);
        groupForm.setIsItemGroup(true);
        List items = group.getItems();
        JobParameterComparator comparator = new JobParameterComparator();
        Collections.sort(items, comparator);
        for (ParameterReferenceItem item : items) {
            if (item.getClass().equals(ParameterReferenceGroup.class)) {
                groupFormList.addAll(JobFormPopulator.createGroupForm((ParameterReferenceGroup)item, groupForm));
                continue;
            }
            groupForm.addItem(JobFormPopulator.createItemForm(item, groupForm));
        }
        if (groupForm.getItems() != null && groupForm.getItems().size() > 0) {
            groupFormList.add(groupForm);
        }
        return groupFormList;
    }

    private static OptionItemForm createItemForm(ParameterReferenceItem item, OptionsGroupForm parentForm) {
        OptionItemForm itemForm = new OptionItemForm();
        itemForm.setName(item.getName());
        String refString = ParameterReferenceHelper.buildParameterReferenceProperty((String)parentForm.getName(), (String)item.getName());
        itemForm.setValue(refString);
        itemForm.setParent(parentForm);
        itemForm.setIsItemGroup(false);
        return itemForm;
    }
}

