/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.util;

import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.IMetadataConverter;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderInstance;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderRegistry;
import com.tandbergtv.watchpoint.pmm.web.util.HTMLOption;
import com.tandbergtv.watchpoint.pmm.web.util.TitleHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.sanmanager.SANManagementException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TitleFacade {
    public static List<HTMLOption> getSpecifications() {
        ArrayList<HTMLOption> specs = new ArrayList<HTMLOption>();
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        for (Specification s : sm.getAllSpecifications()) {
            specs.add(new HTMLOption(s.getName(), s.getName()));
        }
        TitleFacade.sort(specs);
        return specs;
    }

    public static List<HTMLOption> getTitleProviderInstances(String type) {
        ArrayList<HTMLOption> providers = new ArrayList<HTMLOption>();
        ITitleProviderRegistry tpr = TitleFacade.getService(ITitleProviderRegistry.class);
        Collection titleProviders = tpr.getProviders(type);
        if (titleProviders != null) {
            for (ITitleProvider tp : titleProviders) {
                Collection instances;
                if (tp == tpr.getDefaultProvider() || (instances = tp.getProviderInstances()) == null) continue;
                for (ITitleProviderInstance tpi : instances) {
                    providers.add(new HTMLOption(tpi.getName(), tpi.getKey()));
                }
            }
        }
        TitleFacade.sort(providers);
        providers.add(0, new HTMLOption(""));
        return providers;
    }

    public static String getDefaultTitleProvider() {
        ITitleProvider defaultTitleProvider;
        String defaultTitleProviderName = null;
        ITitleProviderRegistry tpr = TitleFacade.getService(ITitleProviderRegistry.class);
        if (tpr != null && (defaultTitleProvider = tpr.getDefaultProvider()) != null) {
            defaultTitleProviderName = defaultTitleProvider.getName();
        }
        return defaultTitleProviderName;
    }

    @Deprecated
    public static Title createTitlesForSpecification(String specName) {
        return null;
    }

    @Deprecated
    public static void save(Title rootTitle) {
    }

    public static Title findTitle(long id) {
        return TitleFacade.getService(ITitlePersistenceService.class).get((Serializable)Long.valueOf(id));
    }

    public static Specification getSpecificationByName(String name) {
        return TitleFacade.getService(ISpecificationManager.class).getSpecificationByName(name);
    }

    public static void sendAssetReceivedStatus(Title rootTitle, String titleName) {
        TitleFacade.getService(IPMMService.class).sendAssetReceivedStatus(rootTitle, titleName, null, null, null);
    }

    public static void sendMetadataReceivedStatus(Title rootTitle) {
        TitleFacade.getService(IPMMService.class).sendMetadataReceivedStatus(rootTitle, null, null, null);
    }

    public static List<HTMLOption> getUnmappedFiles() throws SANManagementException, IOException {
        ArrayList<HTMLOption> unmappedFilesHTMLOptions = new ArrayList<HTMLOption>();
        for (File unmappedFile : AssetsManager.getThreadLocalInstance().getUnmappedFiles()) {
            unmappedFilesHTMLOptions.add(new HTMLOption(unmappedFile.getAbsolutePath()));
        }
        TitleFacade.sort(unmappedFilesHTMLOptions);
        return unmappedFilesHTMLOptions;
    }

    @Deprecated
    public static List<Title> mapAssets(Title rootTitle) {
        return null;
    }

    public static boolean isInUnmappedFilesDirectory(String filePath) throws SANManagementException {
        if (!TitleHelper.containsValue(filePath)) {
            return false;
        }
        File unmappedFilesDir = AssetsManager.getThreadLocalInstance().getUnmappedFilesDirectory();
        return filePath.startsWith(unmappedFilesDir.getAbsolutePath());
    }

    public static boolean isInMappedFilesDirectory(String filePath) throws SANManagementException {
        if (!TitleHelper.containsValue(filePath)) {
            return false;
        }
        File mappedFilesDir = AssetsManager.getThreadLocalInstance().getMappedFilesDirectory();
        return filePath.startsWith(mappedFilesDir.getAbsolutePath());
    }

    public static String moveToMappedFilesDirectory(String filePath) throws IOException, SANManagementException {
        File file = new File(filePath);
        File movedFile = AssetsManager.getThreadLocalInstance().moveToMappedFilesDirectory(file);
        return movedFile.getAbsolutePath();
    }

    public static String moveToUnmappedFilesDirectory(String filePath) throws IOException, SANManagementException {
        File file = new File(filePath);
        File movedFile = AssetsManager.getThreadLocalInstance().moveToUnmappedFilesDirectory(file);
        return movedFile.getAbsolutePath();
    }

    public static void beginAssetsManagerTx() {
        AssetsManager.getThreadLocalInstance().beginTransaction();
    }

    public static void commitAssetsManagerTx() {
        AssetsManager.getThreadLocalInstance().commitTransaction();
    }

    public static void rollbackAssetsManagerTx() {
        AssetsManager.getThreadLocalInstance().rollbackTransaction();
    }

    public static void replaceMetadata(Title parsedMetadata, Title rootTitle) throws PMMException {
        TitleUtil.replaceMetadata((Title)parsedMetadata, (Title)rootTitle);
    }

    public static Title parseMetadata(String type, String metadataFilePath) throws Exception {
        Specification spec = TitleFacade.getSpecificationByName(type);
        IMetadataConverter metadataConverter = spec.getMetadataConverter();
        return metadataConverter.unmarshal(new File(metadataFilePath));
    }

    public static Title approve(long titleID) throws PMMException {
        return TitleFacade.getService(ITitleService.class).approve(titleID);
    }

    public static Title disapprove(long titleID) throws PMMException {
        return TitleFacade.getService(ITitleService.class).disapprove(titleID);
    }

    private static void sort(List<HTMLOption> options) {
        Collections.sort(options, new Comparator<HTMLOption>(){

            @Override
            public int compare(HTMLOption o1, HTMLOption o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
    }

    private static <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }
}

