/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.util;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.web.formbeans.title.TitleData;
import com.tandbergtv.watchpoint.pmm.web.formbeans.title.Variable;
import com.tandbergtv.watchpoint.pmm.web.util.CustomArrayList;
import com.tandbergtv.watchpoint.pmm.web.util.TitleFacade;
import com.tandbergtv.workflow.core.Datatype;
import java.util.Collection;
import java.util.List;

public class TitleHelper {
    public static final String ASSET_LOCATION_NAME = "_assetLocation";
    private static final String ASSET_LOCATION_DISPLAYNAME = "Asset Location";

    @Deprecated
    public static void copyAllTitleToTitleData(Title rootTitle, Collection<TitleData> titlesData) {
    }

    @Deprecated
    public static void copyMetadata(List<TitleData> titlesData, Title rootTitle) {
    }

    public static CustomArrayList<TitleData> getTitlesDataForSpec(String specName) {
        List titleConfs;
        CustomArrayList<TitleData> titlesData = new CustomArrayList<TitleData>(TitleData.class);
        Specification spec = TitleFacade.getSpecificationByName(specName);
        if (spec != null && (titleConfs = spec.getAllTitleConf()) != null) {
            TitleHelper.copyAllTitleConfToTitleData(titleConfs, titlesData);
        }
        return titlesData;
    }

    @Deprecated
    private static void copyTitleToTitleData(Title title, TitleData td) {
    }

    public static boolean newFileMapped(String oldFilePath, String newFilePath) {
        if (!TitleHelper.containsValue(newFilePath)) {
            return false;
        }
        if (!TitleHelper.containsValue(oldFilePath)) {
            return true;
        }
        return !oldFilePath.equals(newFilePath);
    }

    @Deprecated
    private static void copyMetadata(TitleData td, Title correspondingTitle) {
    }

    private static void copyAllTitleConfToTitleData(Collection<TitleConf> titleConfs, List<TitleData> titlesData) {
        int i = 0;
        for (TitleConf tc : titleConfs) {
            TitleHelper.convertTitleConfToTitleData(tc, titlesData.get(i++));
        }
    }

    private static TitleData convertTitleConfToTitleData(TitleConf tc, TitleData td) {
        List tcVariables;
        td.setName(tc.getName());
        int i = 0;
        if (tc.isHasAsset()) {
            TitleHelper.fillAssetLocationVariableInfo(td.getVariables().get(i++));
        }
        if ((tcVariables = tc.getMetadata()) != null) {
            for (com.tandbergtv.watchpoint.pmm.title.conf.Variable tcVariable : tcVariables) {
                TitleHelper.convertSpecVariableToVariable(tcVariable, td.getVariables().get(i++));
            }
        }
        return td;
    }

    private static void convertSpecVariableToVariable(com.tandbergtv.watchpoint.pmm.title.conf.Variable specVariable, Variable v) {
        v.setName(specVariable.getName());
        v.setDisplayName(specVariable.getDisplayName());
        v.setDataType("STRING");
        v.setRequired(false);
        v.setFilePath(false);
    }

    private static void fillAssetLocationVariableInfo(Variable v) {
        v.setName(ASSET_LOCATION_NAME);
        v.setDisplayName(ASSET_LOCATION_DISPLAYNAME);
        v.setDataType(Datatype.FILE.name());
        v.setFilePath(true);
    }

    public static boolean containsValue(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    public static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }
}

