/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.validators;

import com.tandbergtv.watchpoint.pmm.entities.JobRuleTypeConstants;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.job.ui.JobUIConstants;
import com.tandbergtv.watchpoint.pmm.job.util.Day;
import com.tandbergtv.watchpoint.pmm.job.util.ParameterReferenceHelper;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobParameterForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.RuleParameterForm;
import com.tandbergtv.watchpoint.pmm.web.util.JobFormPopulator;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class JobValidator {
    private static String PARAMETER_NAME_DELIMETER = ",";
    private static int INVALID_INDEX = -1;
    private static int MAX_JOB_NAME_LENGTH = 25;
    private static final String JOB_NAME = "name";
    private static final String JOB_START_DATE = "jobStartDate";
    private static final String JOB_END_DATE = "jobEndDate";
    private static final String JOB_SELECTED_RULETYPE = "selectedRuleType";
    private static final String JOB_SELECTED_TEMPLATE = "selectedTemplate";
    private static final String durationFormat = JobValidator.getDurationFormat();
    private static final Logger logger = Logger.getLogger(JobValidator.class);

    public static boolean validateJobTemplateParams(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (!request.getQueryString().equals("method=createJob") && !request.getQueryString().equals("method=updateJob")) {
            return true;
        }
        JobForm jobForm = (JobForm)((Object)obj);
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<String> paramValues = new ArrayList<String>();
        String selectedTemplateName = jobForm.getSelectedTemplate();
        ArrayList<TaskVariable> params = new ArrayList();
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITemplateLoaderService templateLoader = (ITemplateLoaderService)registry.lookup(ITemplateLoaderService.class);
        List templates = templateLoader.getLatestTemplates();
        for (WorkflowTemplate t : templates) {
            if (!t.getName().equals(selectedTemplateName)) continue;
            params = t.getStartTaskVariables();
            break;
        }
        String jobParamNames = jobForm.getJobParamNames();
        String[] jobParamNameList = jobParamNames.split(PARAMETER_NAME_DELIMETER);
        String[] values = jobForm.getValue();
        for (TaskVariable currVariable : params) {
            if (!currVariable.isRequired()) continue;
            paramNames.add(currVariable.getMappedName());
            int varIndex = JobValidator.getVariableIndex(currVariable.getMappedName(), jobParamNameList);
            if (varIndex != INVALID_INDEX) {
                if (values[varIndex].length() == 0) {
                    paramValues.add(null);
                    continue;
                }
                paramValues.add(values[varIndex].trim());
                continue;
            }
            paramValues.add(null);
        }
        boolean isValid = JobValidator.validateRequiredSet(paramValues, paramNames, field, msgs, obj);
        List<JobParameterForm> paramForms = JobValidator.prepareJobParameterForm(params, values, jobParamNameList);
        isValid = JobValidator.validateDataTypeSet(paramForms, field, msgs) && isValid;
        JobFormPopulator.setRequiredInfoInForm(jobForm);
        return isValid;
    }

    public static boolean validateJobDates(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (!request.getQueryString().equals("method=createJob") && !request.getQueryString().equals("method=updateJob")) {
            return true;
        }
        JobForm jobForm = (JobForm)((Object)obj);
        boolean isValid = true;
        if (field.getKey().equalsIgnoreCase(JOB_START_DATE)) {
            String time;
            if (jobForm.getJobStartDate().trim().length() > 0) {
                boolean startDateAllowed = JobValidator.startDateAllowed(jobForm.getSelectedRuleType());
                if (!startDateAllowed) {
                    String errorMsg = "Job start date cannot be used for rule type: " + jobForm.getSelectedRuleType();
                    msgs.add(field.getKey(), new ActionMessage(errorMsg, false));
                    logger.debug((Object)("Adding error message: " + errorMsg));
                    isValid = false;
                }
                if (startDateAllowed) {
                    if (!JobValidator.isValidDate(jobForm.getJobStartDate(), JobUIConstants.JOB_START_DATE_FORMAT)) {
                        msgs.add(field.getKey(), new ActionMessage("Job start date should be a valid date in the correct format(" + JobUIConstants.JOB_START_DATE_FORMAT + ").", false));
                        logger.debug((Object)("Adding error message:Job start date should be a valid date in the correct format(" + JobUIConstants.JOB_START_DATE_FORMAT + ")."));
                        isValid = false;
                    }
                    if (!jobForm.getSelectedRuleType().equalsIgnoreCase(JobRuleTypeConstants.ONDATE_RULE) && JobValidator.isDateInPast(jobForm.getJobStartDate(), JobUIConstants.JOB_START_DATE_FORMAT)) {
                        msgs.add(field.getKey(), new ActionMessage("Job start date should be current or in the future.", false));
                        logger.debug((Object)"Adding error message: Job start date should be current or in the future.");
                        isValid = false;
                    }
                }
            }
            if (!jobForm.getSelectedRuleType().equalsIgnoreCase(JobRuleTypeConstants.ONDATE_RULE) && ((time = JobValidator.getJobTime(jobForm)) == null || JobValidator.isDateTimeInPast(jobForm.getJobStartDate(), JobUIConstants.JOB_START_DATE_FORMAT, time, JobUIConstants.JOB_RULE_TIME_FORMAT))) {
                msgs.add(field.getKey(), new ActionMessage("Job start date time should be in the future.", false));
                logger.debug((Object)"Adding error message: Job start date time should be in the future.");
                isValid = false;
            }
        } else if (field.getKey().equalsIgnoreCase(JOB_END_DATE) && jobForm.getJobEndDate().trim().length() > 0) {
            boolean endDateAllowed = JobValidator.endDateAllowed(jobForm.getSelectedRuleType());
            if (!endDateAllowed) {
                String errorMsg = "Job end date cannot be used for rule type: " + jobForm.getSelectedRuleType();
                msgs.add(field.getKey(), new ActionMessage(errorMsg, false));
                logger.debug((Object)("Adding error message: " + errorMsg));
                isValid = false;
            }
            if (endDateAllowed) {
                String jobEndDate = jobForm.getJobEndDate();
                if (!JobValidator.isValidDate(jobEndDate, JobUIConstants.JOB_END_DATE_FORMAT)) {
                    msgs.add(field.getKey(), new ActionMessage("Job end date should be a valid date in the correct format(" + JobUIConstants.JOB_END_DATE_FORMAT + ").", false));
                    logger.debug((Object)("Adding error message:Job end date should be a valid date in the correct format(" + JobUIConstants.JOB_END_DATE_FORMAT + ")."));
                    isValid = false;
                }
                if (JobValidator.isDateInPast(jobEndDate, JobUIConstants.JOB_END_DATE_FORMAT)) {
                    msgs.add(field.getKey(), new ActionMessage("Job end date should be current or in the future.", false));
                    logger.debug((Object)"Adding error message: Job end date should be current or in the future.");
                    isValid = false;
                }
            }
        }
        JobFormPopulator.setRequiredInfoInForm(jobForm);
        return isValid;
    }

    public static boolean startDateAllowed(String selectedRuleType) {
        return !selectedRuleType.equals(JobRuleTypeConstants.ONDATE_RULE);
    }

    public static boolean endDateAllowed(String selectedRuleType) {
        return !selectedRuleType.equals(JobRuleTypeConstants.ONDATE_RULE);
    }

    private static String getJobTime(JobForm jobForm) {
        String selectedRuleType = jobForm.getSelectedRuleType();
        List<RuleParameterForm> ruleParams = jobForm.getRuleParameters().get(selectedRuleType);
        IJobManager mgr = JobManager.getInstance();
        RuleType type = mgr.getRuleType(selectedRuleType);
        if (type != null) {
            List ruleTypeParams = type.getParams();
            for (RuleTypeParameter p : ruleTypeParams) {
                if (p.getType() != RuleParameterDataType.TIME) continue;
                RuleParameterForm ruleParam = JobValidator.getRuleParam(ruleParams, p.getOrder());
                return ruleParam.getRuleParamValue();
            }
        }
        return null;
    }

    private static RuleParameterForm getRuleParam(List<RuleParameterForm> params, int order) {
        for (RuleParameterForm p : params) {
            if (p.getOrder() != order) continue;
            return p;
        }
        return null;
    }

    public static boolean isDateInPast(String date, String format) {
        try {
            SimpleDateFormat timefomat = new SimpleDateFormat(format);
            timefomat.setLenient(false);
            Date d = timefomat.parse(date);
            Calendar jobCalendar = Calendar.getInstance();
            jobCalendar.setTime(d);
            jobCalendar = JobValidator.resetTime(jobCalendar);
            Calendar currCalendar = Calendar.getInstance();
            currCalendar.setTime(new Date());
            currCalendar = JobValidator.resetTime(currCalendar);
            return jobCalendar.before(currCalendar);
        }
        catch (ParseException e) {
            logger.error((Object)("Error while parsing date while determining if its in the future: " + e.toString()));
            return true;
        }
    }

    private static Calendar resetTime(Calendar c) {
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.set(9, 0);
        return c;
    }

    public static boolean validateJobRuleParams(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (!request.getQueryString().equals("method=createJob") && !request.getQueryString().equals("method=updateJob")) {
            return true;
        }
        boolean isValid = true;
        JobForm jobForm = (JobForm)((Object)obj);
        String selectedRuleType = jobForm.getSelectedRuleType();
        String[] ruleParams = JobFormPopulator.getRuleParamsForSelectedRule(jobForm);
        IJobManager jobMgr = JobManager.getInstance();
        RuleType ruleType = jobMgr.getRuleType(selectedRuleType);
        List ruleTypeParams = ruleType.getParams();
        isValid = JobValidator.validateRequiredRuleTypeParameters(ruleTypeParams, ruleParams, field, msgs);
        isValid = JobValidator.validateRuleParamsDataTye(ruleTypeParams, ruleParams, field, msgs) && isValid;
        isValid = JobValidator.validateRuleParams(ruleType, ruleParams, field, msgs);
        JobFormPopulator.setRequiredInfoInForm(jobForm);
        return isValid;
    }

    private static boolean validateRuleParams(RuleType ruleType, String[] ruleParams, Field field, ActionMessages msgs) {
        int numberOfWeeks;
        String ruleTypeName = ruleType.getName();
        List ruleTypeParams = ruleType.getParams();
        if (ruleTypeName.equalsIgnoreCase(JobRuleTypeConstants.ONDATE_RULE)) {
            if (JobValidator.isDateInPast(ruleParams[JobRuleTypeConstants.DATE_INDEX], JobUIConstants.JOB_RULE_PARAM_DATE_FORMAT)) {
                String parameterName = ((RuleTypeParameter)ruleTypeParams.get(JobRuleTypeConstants.DATE_INDEX)).getName();
                msgs.add(field.getKey(), new ActionMessage(parameterName + " should be current or in the future.", false));
                logger.debug((Object)("Adding error message: " + parameterName + "  should be current or in the future."));
                return false;
            }
            if (JobValidator.isDateTimeInPast(ruleParams[JobRuleTypeConstants.DATE_INDEX], JobUIConstants.JOB_RULE_PARAM_DATE_FORMAT, ruleParams[JobRuleTypeConstants.ONDATE_TIME_INDEX], JobUIConstants.JOB_RULE_TIME_FORMAT)) {
                msgs.add(field.getKey(), new ActionMessage("Job rule date time should be in the future.", false));
                logger.debug((Object)"Adding error message: Job rule date time should be in the future.");
                return false;
            }
        } else if (ruleTypeName.equalsIgnoreCase(JobRuleTypeConstants.EVERY_N_DAYS_RULE)) {
            int numberOfDays = Integer.parseInt(ruleParams[JobRuleTypeConstants.DAYS_INDEX]);
            if (numberOfDays == 0) {
                String parameterName = ((RuleTypeParameter)ruleTypeParams.get(JobRuleTypeConstants.DAYS_INDEX)).getName();
                msgs.add(field.getKey(), new ActionMessage(parameterName + " for rule cannot be 0.", false));
                logger.debug((Object)("Adding error message:" + parameterName + " for rule cannot be 0."));
                return false;
            }
        } else if (ruleTypeName.equalsIgnoreCase(JobRuleTypeConstants.ON_DAY_EVERY_N_WEEKS_RULE) && (numberOfWeeks = Integer.parseInt(ruleParams[JobRuleTypeConstants.WEEK_INDEX])) == 0) {
            String parameterName = ((RuleTypeParameter)ruleTypeParams.get(JobRuleTypeConstants.WEEK_INDEX)).getName();
            msgs.add(field.getKey(), new ActionMessage(parameterName + " for rule cannot be 0.", false));
            logger.debug((Object)("Adding error message:" + parameterName + " for rule cannot be 0."));
            return false;
        }
        return true;
    }

    public static boolean validateRequiredItem(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (!request.getQueryString().equals("method=createJob") && !request.getQueryString().equals("method=updateJob")) {
            return true;
        }
        boolean isValid = true;
        JobForm jobForm = (JobForm)((Object)obj);
        if (field.getKey().equalsIgnoreCase(JOB_NAME)) {
            if (jobForm.getName() == null || jobForm.getName().trim().length() == 0) {
                msgs.add(field.getKey(), new ActionMessage("Job name is required.", false));
                logger.debug((Object)"Adding error message: Job name is required.");
                isValid = false;
            }
            if (jobForm.getName().trim().length() > MAX_JOB_NAME_LENGTH) {
                msgs.add(field.getKey(), new ActionMessage("Job name length should be <= " + MAX_JOB_NAME_LENGTH + ".", false));
                logger.debug((Object)("Adding error message:Job name length should be <= " + MAX_JOB_NAME_LENGTH + "."));
                isValid = false;
            }
        }
        if (field.getKey().equalsIgnoreCase(JOB_SELECTED_RULETYPE) && (jobForm.getSelectedRuleType() == null || jobForm.getSelectedRuleType().trim().length() == 0)) {
            msgs.add(field.getKey(), new ActionMessage("Schedule rule must be selected for job.", false));
            logger.debug((Object)"Adding error message:Schedule rule must be selected for job.");
            isValid = false;
        }
        if (field.getKey().equalsIgnoreCase(JOB_SELECTED_TEMPLATE) && (jobForm.getSelectedTemplate() == null || jobForm.getSelectedTemplate().trim().length() == 0)) {
            msgs.add(field.getKey(), new ActionMessage("A template must be selected for the job.", false));
            logger.debug((Object)"Adding error message:A template must be selected for the job.");
            isValid = false;
        }
        JobFormPopulator.setRequiredInfoInForm(jobForm);
        return isValid;
    }

    private static boolean validateRequiredRuleTypeParameters(List<RuleTypeParameter> ruleTypeParams, String[] ruleParams, Field field, ActionMessages msgs) {
        boolean isValid = true;
        for (int i = 0; i < ruleTypeParams.size(); ++i) {
            if (!ruleTypeParams.get(i).getIsRequired() || ruleParams[i] != null && ruleParams[i].trim().length() != 0) continue;
            msgs.add(field.getKey(), new ActionMessage(ruleTypeParams.get(i).getName() + " for rule is required.", false));
            logger.debug((Object)("Adding error message:" + ruleTypeParams.get(i).getName() + " for rule  is required."));
            isValid = false;
        }
        return isValid;
    }

    private static boolean validateRuleParamsDataTye(List<RuleTypeParameter> ruleTypeParams, String[] ruleParams, Field field, ActionMessages msgs) {
        boolean isValid = true;
        for (int i = 0; i < ruleTypeParams.size(); ++i) {
            if (ruleParams[i] == null || ruleParams[i].trim().length() == 0) continue;
            RuleParameterDataType type = ruleTypeParams.get(i).getType();
            if (type == RuleParameterDataType.DATE) {
                if (JobValidator.isValidDate(ruleParams[i], JobUIConstants.JOB_RULE_PARAM_DATE_FORMAT)) continue;
                msgs.add(field.getKey(), new ActionMessage(ruleTypeParams.get(i).getName() + " should be a valid date in the correct format(" + JobUIConstants.JOB_RULE_PARAM_DATE_FORMAT + ").", false));
                logger.debug((Object)("Adding error message:" + ruleTypeParams.get(i).getName() + " should be a valid date in the correct format(" + JobUIConstants.JOB_RULE_PARAM_DATE_FORMAT + ")."));
                isValid = false;
                continue;
            }
            if (type == RuleParameterDataType.DAY) {
                if (JobValidator.isValidDay(ruleParams[i])) continue;
                msgs.add(field.getKey(), new ActionMessage(ruleTypeParams.get(i).getName() + " should be a valid week day.", false));
                logger.debug((Object)("Adding error message:" + ruleTypeParams.get(i).getName() + " should be a valid week day."));
                isValid = false;
                continue;
            }
            if (type == RuleParameterDataType.INTEGER) {
                try {
                    int number = Integer.parseInt(ruleParams[i]);
                    if (number >= 0) continue;
                    msgs.add(field.getKey(), new ActionMessage(ruleTypeParams.get(i).getName() + " must be a valid positive integer.", false));
                    logger.debug((Object)("Adding error message:" + ruleTypeParams.get(i).getName() + " must be a valid positive integer."));
                    isValid = false;
                }
                catch (NumberFormatException ex) {
                    msgs.add(field.getKey(), new ActionMessage(ruleTypeParams.get(i).getName() + " must be a valid integer.", false));
                    logger.debug((Object)("Adding error message:" + ruleTypeParams.get(i).getName() + " must be a valid integer."));
                    isValid = false;
                }
                continue;
            }
            if (type == RuleParameterDataType.OPTIONS) {
                if (ruleParams[i] != null && ruleParams[i].trim().length() != 0) continue;
                msgs.add(field.getKey(), new ActionMessage(ruleTypeParams.get(i).getName() + " must be a valid available option.", false));
                logger.debug((Object)("Adding error message:" + ruleTypeParams.get(i).getName() + " must be a valid available option."));
                isValid = false;
                continue;
            }
            if (type == RuleParameterDataType.PARAMETERREF) {
                if (ruleParams[i] != null && ruleParams[i].trim().length() != 0 && ruleParams[i].startsWith(ParameterReferenceHelper.PROPERTY_REFERENCE_PREFIX)) continue;
                msgs.add(field.getKey(), new ActionMessage(ruleTypeParams.get(i).getName() + " must be a valid parameter reference. Use available drop down.", false));
                logger.debug((Object)("Adding error message:" + ruleTypeParams.get(i).getName() + " must be a valid parameter reference.Use available drop down."));
                isValid = false;
                continue;
            }
            if (type != RuleParameterDataType.TIME) continue;
            try {
                SimpleDateFormat timefomat = new SimpleDateFormat(JobUIConstants.JOB_RULE_TIME_FORMAT);
                timefomat.setLenient(false);
                timefomat.parse(ruleParams[i]);
                continue;
            }
            catch (ParseException e) {
                msgs.add(field.getKey(), new ActionMessage(ruleTypeParams.get(i).getName() + " should be a valid time in the correct format(" + JobUIConstants.JOB_RULE_TIME_FORMAT + ").", false));
                logger.debug((Object)("Adding error message:" + ruleTypeParams.get(i).getName() + " should be a valid time in the correct format(" + JobUIConstants.JOB_RULE_TIME_FORMAT + ")."));
                isValid = false;
                continue;
            }
            catch (IllegalArgumentException e) {
                msgs.add(field.getKey(), new ActionMessage(ruleTypeParams.get(i).getName() + " should be a valid time in the correct format(" + JobUIConstants.JOB_RULE_TIME_FORMAT + ").", false));
                logger.debug((Object)("Adding error message:" + ruleTypeParams.get(i).getName() + " should be a valid time in the correct format(" + JobUIConstants.JOB_RULE_TIME_FORMAT + ")."));
                isValid = false;
            }
        }
        return isValid;
    }

    private static boolean isValidDay(String ruleDay) {
        Day day = Day.valueOf((String)ruleDay);
        return day != null;
    }

    private static List<JobParameterForm> prepareJobParameterForm(Collection<TaskVariable> params, String[] paramValues, String[] paramNames) {
        ArrayList<JobParameterForm> jobParameters = new ArrayList<JobParameterForm>();
        for (TaskVariable currVariable : params) {
            JobParameterForm jobParameter = new JobParameterForm();
            jobParameter.setName(currVariable.getMappedName());
            jobParameter.setRequired(currVariable.isRequired());
            jobParameter.setType(currVariable.getDatatype().toString());
            int index = JobValidator.getVariableIndex(currVariable.getMappedName(), paramNames);
            if (index != INVALID_INDEX) {
                jobParameter.setValue(paramValues[index]);
            } else {
                jobParameter.setValue(null);
            }
            jobParameters.add(jobParameter);
        }
        return jobParameters;
    }

    private static int getVariableIndex(String variableName, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equalsIgnoreCase(variableName)) continue;
            return i;
        }
        return INVALID_INDEX;
    }

    private static boolean validateRequiredSet(List<String> params, List<String> paramNames, Field field, ActionMessages msgs, Object obj) {
        logger.debug((Object)("list of paramNmes: " + paramNames));
        logger.debug((Object)("list of params: " + params));
        boolean noErrors = true;
        for (int i = 0; i < paramNames.size(); ++i) {
            if (params.get(i) != null && !params.get(i).trim().equals("")) continue;
            msgs.add(field.getKey(), new ActionMessage(paramNames.get(i) + " is required.", false));
            logger.debug((Object)("Adding error message:" + paramNames.get(i) + " is required."));
            noErrors = false;
        }
        return noErrors;
    }

    private static boolean validateDataTypeSet(List<JobParameterForm> paramList, Field field, ActionMessages msgs) {
        boolean noErrors = true;
        for (JobParameterForm parameter : paramList) {
            noErrors = JobValidator.validateField(parameter, field, msgs) && noErrors;
        }
        return noErrors;
    }

    private static boolean validateField(JobParameterForm param, Field field, ActionMessages msgs) {
        boolean isValid = true;
        if (param.getType() == null || param.getType().equals("")) {
            msgs.add(field.getKey(), new ActionMessage(param.getName() + " does not have a datatype associated with it.", false));
            logger.debug((Object)("Adding error message:" + param.getName() + " does not have a datatype associated with it."));
            isValid = false;
        } else {
            if (param.getValue() == null || param.getValue().toString().equals("") || param.getValue().startsWith(ParameterReferenceHelper.PROPERTY_REFERENCE_PREFIX)) {
                return isValid;
            }
            if (param.getType().equalsIgnoreCase(Datatype.INT.toString())) {
                try {
                    Integer.parseInt(param.getValue().toString());
                }
                catch (NumberFormatException ex) {
                    msgs.add(field.getKey(), new ActionMessage(param.getName() + " must be a valid integer.", false));
                    logger.debug((Object)("Adding error message:" + param.getName() + " must be a valid integer."));
                    isValid = false;
                }
            } else if (param.getType().equalsIgnoreCase(Datatype.BOOLEAN.toString())) {
                if (!param.getValue().toString().equals("true") && !param.getValue().toString().equals("false")) {
                    msgs.add(field.getKey(), new ActionMessage(param.getName() + " must be true or false.", false));
                    logger.debug((Object)("Adding error message:" + param.getName() + " must be true or false."));
                    isValid = false;
                }
            } else if (param.getType().equalsIgnoreCase(Datatype.DESTINATION.toString())) {
                if (!JobValidator.folderExists(param.getValue().toString())) {
                    msgs.add(field.getKey(), new ActionMessage(param.getName() + " is incorrect. " + param.getValue() + " is an invalid file or path.", false));
                    logger.debug((Object)("Adding error message:" + param.getName() + " is incorrect. " + param.getValue() + " is an invalid file or path."));
                    isValid = false;
                }
            } else if (param.getType().equalsIgnoreCase(Datatype.DATE.toString())) {
                if (!JobValidator.isValidDate(param.getValue().toString(), JobUIConstants.JOB_PARAM_DATE_FORMAT)) {
                    msgs.add(field.getKey(), new ActionMessage(param.getName() + " should be a valid date in the correct format(" + JobUIConstants.JOB_PARAM_DATE_FORMAT + ").", false));
                    logger.debug((Object)("Adding error message:" + param.getName() + " should be a valid date in the correct format(" + JobUIConstants.JOB_PARAM_DATE_FORMAT + ")."));
                    isValid = false;
                }
            } else if (param.getType().equalsIgnoreCase(Datatype.DURATION.toString()) && !JobValidator.isValidDuration(param.getValue().toString())) {
                msgs.add(field.getKey(), new ActionMessage(param.getName() + " is not in the correct format(" + durationFormat + ").", false));
                logger.debug((Object)("Adding error message:" + param.getName() + " is not in the correct format(" + durationFormat + ")."));
                isValid = false;
            }
        }
        return isValid;
    }

    private static String getDurationFormat() {
        return "HH:mm:ss";
    }

    private static boolean isValidDuration(String duration) {
        SimpleDateFormat format = new SimpleDateFormat(durationFormat);
        format.setLenient(false);
        try {
            format.parse(duration);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    private static boolean isValidDate(String value, String format) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            df.setLenient(false);
            df.parse(value);
            if (value.trim().length() != format.length()) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private static boolean folderExists(String filePath) {
        File file = new File(filePath);
        if (filePath.length() > 2 && (filePath.substring(2).lastIndexOf("//") != -1 || filePath.substring(2).lastIndexOf("\\\\") != -1)) {
            return false;
        }
        if (file.getParent() == null) {
            return false;
        }
        File dir = new File(file.getParent());
        return !file.isDirectory() && dir.isDirectory() && dir.exists() && dir.canRead();
    }

    private static boolean isDateTimeInPast(String date, String dateFormat, String time, String timeFormat) {
        try {
            Calendar cDate = Calendar.getInstance();
            SimpleDateFormat dateformat = new SimpleDateFormat(dateFormat);
            dateformat.setLenient(false);
            if (date.length() > 0) {
                Date jobDate = dateformat.parse(date);
                cDate.setTime(jobDate);
            } else {
                cDate.setTime(new Date());
            }
            SimpleDateFormat timefomat = new SimpleDateFormat(timeFormat);
            timefomat.setLenient(false);
            Date jobTime = timefomat.parse(time);
            Calendar cTime = Calendar.getInstance();
            cTime.setTime(jobTime);
            cDate.set(9, cTime.get(9));
            cDate.set(11, cTime.get(11));
            cDate.set(12, cTime.get(12));
            cDate.set(13, 0);
            Calendar cNow = Calendar.getInstance();
            cNow.setTime(new Date());
            return cDate.before(cNow);
        }
        catch (ParseException e) {
            String errorMsg = "Error while checking if dateTime is in future: " + e.getMessage() + e.getStackTrace();
            logger.error((Object)errorMsg);
            return true;
        }
    }
}

