/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.validators;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.web.formbeans.service.ServiceForm;
import com.tandbergtv.watchpoint.pmm.web.validators.ValidatorProperties;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class ServiceValidator {
    private static final Logger logger = Logger.getLogger(ServiceValidator.class);
    private static final int MAX_LENGTH_50 = 50;
    private static final int MAX_LENGTH_255 = 255;
    private static final int MAX_LENGTH_25 = 25;
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    public static boolean validateServiceField(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        IContainer container;
        ICacheService containerCache;
        if (!request.getQueryString().equals("method=createService") && !request.getQueryString().equals("method=updateService")) {
            return true;
        }
        boolean isValid = true;
        ServiceForm serviceForm = (ServiceForm)((Object)obj);
        String specialCharacterList = ValidatorProperties.getProperty("forbiddenSpecialCharacters");
        if (field.getKey().equalsIgnoreCase("serviceName")) {
            if (serviceForm.getName() == null || serviceForm.getName().trim().length() == 0) {
                msgs.add(field.getKey(), new ActionMessage("Service name is required.", false));
                logger.warn((Object)"Service name is required.");
                isValid = false;
            } else {
                if (serviceForm.getName().trim().length() > 50) {
                    msgs.add(field.getKey(), new ActionMessage("Service name cannot exceed 50 characters.", false));
                    logger.warn((Object)"Service name cannot exceed 50 characters.");
                    isValid = false;
                }
                if (serviceForm.getName().trim().length() > 0 && specialCharacterList != null && !specialCharacterList.equals("")) {
                    String specialCharacterPattern = ".*[" + specialCharacterList + "].*";
                    logger.debug((Object)("specialCharacterPattern=" + specialCharacterPattern));
                    if (Pattern.matches(specialCharacterPattern, serviceForm.getName().trim())) {
                        String errorMessage = "Service name cannot contain any of the following characters:" + specialCharacterList;
                        msgs.add(field.getKey(), new ActionMessage(errorMessage, false));
                        logger.warn((Object)errorMessage);
                        isValid = false;
                    }
                }
                if (isValid) {
                    containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
                    for (Serializable key : containerCache.getKeys()) {
                        container = (IContainer)containerCache.get(key);
                        logger.debug((Object)("container.getContainerName()=" + container.getContainerName()));
                        if (container.getContainerType() != ContainerType.SERVICE || !container.getContainerName().trim().equals(serviceForm.getName().trim()) || !serviceForm.getId().equals("") && container.getContainerId() == Long.parseLong(serviceForm.getId())) continue;
                        msgs.add(field.getKey(), new ActionMessage("Service with the same name already exists.", false));
                        logger.warn((Object)"Service with the same name already exists.");
                        isValid = false;
                        break;
                    }
                }
            }
        }
        if (field.getKey().equalsIgnoreCase("description") && serviceForm.getDescription() != null && serviceForm.getDescription().length() > 255) {
            msgs.add(field.getKey(), new ActionMessage("The description field cannot exceed 255 characters.", false));
            logger.warn((Object)"The description field cannot exceed 255 characters.");
            isValid = false;
        }
        if (field.getKey().equalsIgnoreCase("lookupKey")) {
            logger.debug((Object)("serviceForm.getId()=" + serviceForm.getId() + "."));
            logger.debug((Object)("serviceForm.getLookupKey()=" + serviceForm.getLookupKey() + "."));
            if (serviceForm.getLookupKey() != null && !serviceForm.getLookupKey().equals("")) {
                if (serviceForm.getLookupKey().length() > 25) {
                    msgs.add(field.getKey(), new ActionMessage("The Lookup Key field cannot exceed 25 characters.", false));
                    logger.warn((Object)"The Lookup Key field cannot exceed 25 characters.");
                    isValid = false;
                } else {
                    containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
                    for (Serializable key : containerCache.getKeys()) {
                        container = (IContainer)containerCache.get(key);
                        logger.debug((Object)("container.getContainerLookupKey()=" + container.getContainerLookupKey() + "."));
                        if (container.getContainerLookupKey() == null || !container.getContainerLookupKey().trim().equals(serviceForm.getLookupKey().trim()) || !serviceForm.getId().equals("") && container.getContainerId() == Long.parseLong(serviceForm.getId())) continue;
                        String errorMessage = container.getContainerType() + " with the same lookup key already exists.";
                        msgs.add(field.getKey(), new ActionMessage(errorMessage, false));
                        logger.warn((Object)errorMessage);
                        isValid = false;
                        break;
                    }
                }
            }
        }
        return isValid;
    }
}

