/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.validators;

import com.tandbergtv.watchpoint.pmm.web.title.TitleListForm;
import com.tandbergtv.watchpoint.pmm.web.title.TitleSearchType;
import com.tandbergtv.watchpoint.pmm.web.title.search.TitleSearchPageBuilder;
import com.tandbergtv.watchpoint.pmm.web.validators.ValidatorUtil;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.web.page.Page;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class TitleValidator {
    private static Logger logger = Logger.getLogger(TitleValidator.class);
    private static final String KEY_INVALID_INTEGER_VALUE = "error.title.search.invalidIntegerValue";
    private static final String KEY_INVALID_DATE_VALUE = "error.title.search.invalidDateValue";
    private static final String KEY_INVALID_DATE_RANGE_VALUES = "error.title.search.invalidDateRangeValues";

    public boolean validateSearch(Object form, ValidatorAction action, Field field, ActionMessages messages, Validator validator, HttpServletRequest request) {
        boolean result = true;
        String method = request.getParameter("method");
        if (!"search".equals(method)) {
            return result;
        }
        TitleListForm titleForm = (TitleListForm)((Object)form);
        String specification = titleForm.getSpecification();
        TitleSearchType searchType = titleForm.getSearchType();
        Page searchPage = null;
        try {
            TitleSearchPageBuilder builder = TitleSearchPageBuilder.newInstance();
            searchPage = builder.buildSearchPage(searchType, specification);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to build the Title Search Page for specification: " + specification + " for search type: " + (Object)((Object)searchType)), (Throwable)e);
            ActionMessage msg = new ActionMessage("The Title Search Page is invalid.", false);
            messages.add("TitleSearch", msg);
            return false;
        }
        Collection fields = searchPage.getFields();
        String fieldKey = field.getKey();
        for (com.tandbergtv.workflow.web.page.Field searchField : fields) {
            result &= TitleValidator.validateSearchField(searchField, fieldKey, titleForm, messages, request);
        }
        return result;
    }

    private static boolean validateSearchField(com.tandbergtv.workflow.web.page.Field searchField, String key, TitleListForm titleForm, ActionMessages messages, HttpServletRequest request) {
        boolean result = true;
        String[] values = request.getParameterValues(searchField.getName());
        if (values == null || values.length == 0) {
            return true;
        }
        String label = searchField.getLabel();
        SearchType searchType = searchField.getSearchType();
        for (String value : values) {
            if (searchType == SearchType.DATE || searchField.getIsDateRange()) {
                result &= TitleValidator.validateDateField(key, label, value, messages);
            } else if (searchType == SearchType.NUMERIC) {
                result &= TitleValidator.validateNumberField(key, label, value, messages);
            }
            if (!result) break;
        }
        if (result) {
            result &= TitleValidator.validateDateRangeField(key, label, values, messages);
        }
        return result;
    }

    private static boolean validateDateField(String key, String label, String value, ActionMessages messages) {
        boolean result = true;
        if (value != null && value.trim().length() > 0) {
            try {
                result = ValidatorUtil.isValidDate(value.trim());
            }
            catch (Exception e) {
                result = false;
            }
        }
        if (!result) {
            ActionMessage message = new ActionMessage(KEY_INVALID_DATE_VALUE, (Object)label);
            messages.add(key, message);
        }
        return result;
    }

    private static boolean validateDateRangeField(String key, String label, String[] values, ActionMessages messages) {
        boolean result = true;
        if (values == null || values.length < 2) {
            return result;
        }
        String start = values[0];
        String end = values[1];
        try {
            SimpleDateFormat format = new SimpleDateFormat(ValidatorUtil.getDatePattern());
            if (!TitleValidator.isBlank(start) && !TitleValidator.isBlank(end)) {
                Date startDate = format.parse(start);
                Date endDate = format.parse(end);
                result = startDate.getTime() <= endDate.getTime();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!result) {
            ActionMessage message = new ActionMessage(KEY_INVALID_DATE_RANGE_VALUES, (Object)label);
            messages.add(key, message);
        }
        return result;
    }

    private static boolean validateNumberField(String key, String label, String value, ActionMessages messages) {
        boolean result = true;
        if (value != null && value.trim().length() > 0) {
            try {
                Long.parseLong(value.trim());
            }
            catch (Exception e) {
                String msgKey = KEY_INVALID_INTEGER_VALUE;
                ActionMessage message = new ActionMessage(msgKey, (Object)label);
                messages.add(key, message);
                result = false;
            }
        }
        return result;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }
}

