/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.contentmgmt.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class GetOriginalFileInfoMessageHandler
implements MessageHandler {
    private static final String DURATION = "duration";
    private static final String RESOLUTION = "resolution";
    private static final String MIME_TYPE = "mimeType";
    private static final String FILE_SIZE = "fileSize";
    private static final String FILE_NAME = "fileName";
    private static final String FILE_URI = "fileUri";
    private static final String TITLE_ID = "titleId";
    private static final String ASSET_ID = "assetId";

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)GetOriginalFileInfoMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), GetOriginalFileInfoMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private Asset findAsset(Asset groupAsset, Long assetId) {
        if (groupAsset.getId() == assetId.longValue()) {
            return groupAsset;
        }
        List relations = groupAsset.getRelations();
        if (relations != null) {
            for (Relation relation : relations) {
                Asset a = relation.getTargetAsset();
                boolean found = this.search(a, assetId);
                if (!found) continue;
                return a;
            }
        }
        return null;
    }

    private boolean search(Asset asset, Long assetId) {
        if (asset.getId() == assetId.longValue()) {
            return true;
        }
        List relations = asset.getRelations();
        if (relations != null) {
            for (Relation relation : relations) {
                Asset a = relation.getTargetAsset();
                boolean found = this.search(a, assetId);
                if (!found) continue;
                return true;
            }
        }
        return false;
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(GetOriginalFileInfoMessageHandler this_, WorkflowMessage message) {
        Util.validateRequired(message, TITLE_ID, ASSET_ID);
        Long titleId = Util.getLongValue(message, TITLE_ID);
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitlePersistenceService service = (ITitlePersistenceService)registry.lookup(ITitlePersistenceService.class);
        Title title = null;
        try {
            title = service.get((Serializable)titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, e);
        }
        if (title == null) {
            String msg = "Did not get a Title from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Long assetId = Util.getLongValue(message, ASSET_ID);
        Asset groupAsset = title.getAsset();
        if (groupAsset == null) {
            String msg = "Did not get a group object for a given title.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Asset targetAsset = this_.findAsset(groupAsset, assetId);
        if (targetAsset == null) {
            String msg = "Did not get an item object for a given assetId.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        File originalFile = null;
        List files = targetAsset.getChildrenOfType(File.class);
        if (files != null) {
            for (File file : files) {
                if (!file.isOriginal()) continue;
                originalFile = file;
                break;
            }
        }
        if (originalFile == null) {
            String msg = "Could not find an original file associated with the given assetId.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        String fileUri = originalFile.getURL() != null ? originalFile.getURL() : "";
        String fileName = originalFile.getName() != null ? originalFile.getName() : "";
        int fileSize = originalFile.getSize();
        String mimeType = originalFile.getMIMEType() != null ? originalFile.getMIMEType() : "";
        String resolution = originalFile.getResolution() != null ? originalFile.getResolution() : "";
        String duration = originalFile.getDuration() != null ? originalFile.getDuration() : "";
        response.putValue(FILE_URI, fileUri);
        response.putValue(FILE_NAME, fileName);
        response.putValue(FILE_SIZE, Integer.toString(fileSize));
        response.putValue(MIME_TYPE, mimeType);
        response.putValue(RESOLUTION, resolution);
        response.putValue(DURATION, duration);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(GetOriginalFileInfoMessageHandler this_, WorkflowMessage transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return GetOriginalFileInfoMessageHandler.handleMessage_aroundBody0(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            WorkflowMessage workflowMessage = GetOriginalFileInfoMessageHandler.handleMessage_aroundBody0(this_, transactional);
            object.commit();
            return workflowMessage;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

