/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.FileType;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class RegisterFileMessageHandler
implements MessageHandler {
    private static final String MATERIAL_ID_XPATH = "/tns:Fields/tns:CustomFields/tns:CustomField[@name=MaterialId]/@value";
    private static final String ENCODE_PROFILE_XPATH = "/tns:Fields/tns:CustomFields/tns:CustomField[@name=EncodeProfile]/@value";
    private static final String ENCODE_FORMAT_XPATH = "/tns:Fields/tns:CustomFields/tns:CustomField[@name=EncodeFormat]/@value";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String FILE_SIZE = "fileSize";
    private static final String MIME_TYPE = "mimeType";
    private static final String FILE_NAME = "fileName";
    private static final String DURATION = "duration";
    private static final String ASPECTRATIO = "aspectratio";
    private static final String BITRATE = "bitrate";
    private static final String RESOLUTION = "resolution";
    private static final String MATERIAL_ID = "materialId";
    private static final String ENCODE_PROFILE = "encodeProfile";
    private static final String ENCODE_FORMAT = "encodeFormat";
    private static final String ORIGINAL_FILE_PATH = "originalFilePath";
    private static final String TITLE_ID = "titleId";
    private static final String FILE_URI = "fileURI";
    private static final String ASSET_ID = "assetId";
    private static final String RESULT = "result";
    private static final String SUCCESS = "SUCCESS";

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)RegisterFileMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), RegisterFileMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private Asset findAsset(Asset groupAsset, Long assetId) {
        if (groupAsset.getId() == assetId.longValue()) {
            return groupAsset;
        }
        List relations = groupAsset.getRelations();
        if (relations != null) {
            for (Relation relation : relations) {
                Asset a = relation.getTargetAsset();
                boolean found = this.search(a, assetId);
                if (!found) continue;
                return a;
            }
        }
        return null;
    }

    private boolean search(Asset asset, Long assetId) {
        if (asset.getId() == assetId.longValue()) {
            return true;
        }
        List relations = asset.getRelations();
        if (relations != null) {
            for (Relation relation : relations) {
                Asset a = relation.getTargetAsset();
                boolean found = this.search(a, assetId);
                if (!found) continue;
                return true;
            }
        }
        return false;
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(RegisterFileMessageHandler this_, WorkflowMessage message) {
        Util.validateRequired(message, TITLE_ID, FILE_URI, ASSET_ID, ORIGINAL_FILE_PATH);
        Long titleId = Util.getLongValue(message, TITLE_ID);
        String fileURI = Util.getStringValueTrimmed(message, FILE_URI);
        Long assetId = Util.getLongValue(message, ASSET_ID);
        String originalFilePath = Util.getStringValueTrimmed(message, ORIGINAL_FILE_PATH);
        String encodeFormat = Util.getStringValueTrimmed(message, ENCODE_FORMAT);
        String encodeProfile = Util.getStringValueTrimmed(message, ENCODE_PROFILE);
        String materialId = Util.getStringValueTrimmed(message, MATERIAL_ID);
        String resolution = Util.getStringValueTrimmed(message, RESOLUTION);
        String bitrate = Util.getStringValueTrimmed(message, BITRATE);
        String aspectratio = Util.getStringValueTrimmed(message, ASPECTRATIO);
        String duration = Util.getStringValueTrimmed(message, DURATION);
        String fileName = Util.getStringValueTrimmed(message, FILE_NAME);
        String mimeType = Util.getStringValueTrimmed(message, MIME_TYPE);
        String fileSize = Util.getStringValueTrimmed(message, FILE_SIZE);
        String width = Util.getStringValueTrimmed(message, WIDTH);
        String height = Util.getStringValueTrimmed(message, HEIGHT);
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitlePersistenceService service = (ITitlePersistenceService)registry.lookup(ITitlePersistenceService.class);
        Title title = null;
        try {
            title = service.get((Serializable)titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, e);
        }
        if (title == null) {
            String msg = "Did not get a Title from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Asset groupAsset = title.getAsset();
        if (groupAsset == null) {
            String msg = "Did not get a group object for a given title.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Asset targetAsset = this_.findAsset(groupAsset, assetId);
        if (targetAsset == null) {
            String msg = "Did not get an item object for a given assetId.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        com.tandbergtv.metadatamanager.model.File targetFile = null;
        for (Asset asset : targetAsset.getAllDescendantItems(true)) {
            com.tandbergtv.metadatamanager.model.File file;
            if (!(asset instanceof com.tandbergtv.metadatamanager.model.File) || !(file = (com.tandbergtv.metadatamanager.model.File)com.tandbergtv.metadatamanager.model.File.class.cast(asset)).getURL().equals(originalFilePath)) continue;
            targetFile = file;
            break;
        }
        if (targetFile == null) {
            String msg = "Did not find a file object for a given assetId and originalFilePath.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        com.tandbergtv.metadatamanager.model.File derivedFile = new com.tandbergtv.metadatamanager.model.File();
        derivedFile.setFileType(FileType.DERIVED);
        derivedFile.addField(new Field(FieldName.FILE_URL.toString(), fileURI));
        derivedFile.addField(new Field(ENCODE_FORMAT_XPATH, encodeFormat));
        derivedFile.addField(new Field(ENCODE_PROFILE_XPATH, encodeProfile));
        derivedFile.addField(new Field(MATERIAL_ID_XPATH, materialId));
        derivedFile.addField(new Field(FieldName.RESOLUTION.toString(), resolution));
        derivedFile.addField(new Field(FieldName.BITRATE.toString(), bitrate));
        derivedFile.addField(new Field(FieldName.ASPECTRATIO.toString(), aspectratio));
        derivedFile.addField(new Field(FieldName.DURATION.toString(), duration));
        derivedFile.addField(new Field(FieldName.FILE_NAME.toString(), fileName));
        derivedFile.addField(new Field(FieldName.MIME_TYPE.toString(), mimeType));
        if (fileSize == null || fileSize.equals("")) {
            fileSize = new File(fileURI).length() + "";
        }
        derivedFile.addField(new Field(FieldName.FILE_SIZE.toString(), fileSize));
        derivedFile.addField(new Field(FieldName.WIDTH.toString(), width));
        derivedFile.addField(new Field(FieldName.HEIGHT.toString(), height));
        targetFile.addChild((Asset)derivedFile);
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(RESULT, SUCCESS);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(RegisterFileMessageHandler this_, WorkflowMessage transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return RegisterFileMessageHandler.handleMessage_aroundBody0(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            WorkflowMessage workflowMessage = RegisterFileMessageHandler.handleMessage_aroundBody0(this_, transactional);
            object.commit();
            return workflowMessage;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

