/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job;

import com.tandbergtv.cms.rules.service.IRuleService;
import com.tandbergtv.cms.rules.service.RuleDeleteException;
import com.tandbergtv.watchpoint.pmm.entities.Job;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import java.util.List;

public class JobRulesetManager
implements IRuleService {
    public void canDelete(long ruleSetId) throws RuleDeleteException {
        if (this.haveJobs(ruleSetId)) {
            throw new RuleDeleteException("There are jobs associated with ruleset [id=" + ruleSetId + "], hence cannot delete this ruleset");
        }
    }

    public void canRemoveSchedulable(long ruleSetId) throws RuleDeleteException {
        if (this.haveJobs(ruleSetId)) {
            throw new RuleDeleteException("There are jobs associated with ruleset [id=" + ruleSetId + "], hence cannot remove schedulable event");
        }
    }

    private boolean haveJobs(long ruleSetId) {
        List<Job> jobs = JobManager.getInstance().getAllJobs(String.valueOf(ruleSetId));
        return jobs != null && jobs.size() > 0;
    }
}

