/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.scheduling;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.entities.Job;
import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.job.scheduling.IJobScheduleManager;
import com.tandbergtv.watchpoint.pmm.job.scheduling.MissedTriggerListener;
import com.tandbergtv.watchpoint.pmm.job.timers.ITimeRepresentation;
import com.tandbergtv.watchpoint.pmm.job.timers.TimerResult;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzScheduleManager
implements IJobScheduleManager,
IColleague {
    private static IJobScheduleManager instance;
    private Scheduler scheduler;
    private static String SERVICE_NAME;
    public static String JOB_GROUP_NAME;
    private static String TRIGGER_PREFIX;
    private static String TRIGGER_JOBID_DELIMETER;
    private static int THREAD_FACTORY_THREAD_COUNT;
    private static String JOB_PROPERTIES_FILENAME;
    private boolean isTemplateServiceStarted;
    private boolean isStarted;
    private static final Logger logger;

    private QuartzScheduleManager() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.register((IColleague)this);
    }

    public static synchronized IJobScheduleManager getInstance() {
        if (instance == null) {
            instance = new QuartzScheduleManager();
        }
        return instance;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    @Transactional
    public synchronized void addSchedule(Job job) {
        Job job2 = job;
        QuartzScheduleManager.addSchedule_aroundBody1$advice(this, job2, TransactionEnforcer.aspectOf(), QuartzScheduleManager.class.getDeclaredMethod("addSchedule", Job.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public synchronized void deleteSchedules(Job job) {
        Job job2 = job;
        QuartzScheduleManager.deleteSchedules_aroundBody3$advice(this, job2, TransactionEnforcer.aspectOf(), QuartzScheduleManager.class.getDeclaredMethod("deleteSchedules", Job.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public synchronized void updateSchedule(Job job) {
        Job job2 = job;
        QuartzScheduleManager.updateSchedule_aroundBody5$advice(this, job2, TransactionEnforcer.aspectOf(), QuartzScheduleManager.class.getDeclaredMethod("updateSchedule", Job.class).getAnnotation(Transactional.class), null);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        QuartzScheduleManager quartzScheduleManager = this;
        synchronized (quartzScheduleManager) {
            if (!this.isTemplateServiceStarted || this.isStarted) {
                return;
            }
        }
        this.isStarted = true;
        try {
            StdSchedulerFactory sf = new StdSchedulerFactory(JOB_PROPERTIES_FILENAME);
            this.scheduler = sf.getScheduler();
            if (this.scheduler == null) {
                String errorMsg = "Could not get scheduler from quartz scheduler factory.";
                throw new RuntimeException(errorMsg);
            }
            logger.debug((Object)"Will start the scheduler");
            Callable<Scheduler> starterThread = new Callable<Scheduler>(){

                @Override
                public Scheduler call() throws Exception {
                    if (QuartzScheduleManager.this.scheduler.getTriggerListener(MissedTriggerListener.NAME) == null) {
                        MissedTriggerListener triggerListener = new MissedTriggerListener();
                        QuartzScheduleManager.this.scheduler.addTriggerListener((TriggerListener)triggerListener);
                    }
                    QuartzScheduleManager.this.scheduler.start();
                    logger.debug((Object)"There you go. Started the Quartz standard scheduler.");
                    return QuartzScheduleManager.this.scheduler;
                }
            };
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(THREAD_FACTORY_THREAD_COUNT);
            executor.schedule(starterThread, 0L, TimeUnit.MILLISECONDS);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Error while getting/starting scheduler: ", e);
        }
    }

    public void stop() {
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Error while stopping scheduler: ", e);
        }
    }

    public String[] getAllScheduledJobNames() {
        try {
            return this.scheduler.getJobNames(JOB_GROUP_NAME);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Error while getting scheduled job names: ", (Throwable)e);
            return null;
        }
    }

    public int getExecutedJobCount() {
        try {
            return this.scheduler.getMetaData().numJobsExecuted();
        }
        catch (SchedulerException e) {
            logger.error((Object)"Error while getting executed job count: ", (Throwable)e);
            return 0;
        }
    }

    private JobDataMap buildJobDataMap(Job job) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(JobScheduleInfoConstants.JOB_NAME, job.getName());
        jobDataMap.put(JobScheduleInfoConstants.CONTEXTID, job.getContext().getId());
        List<JobParameter> jobParams = this.cloneJobParams(job.getJobParams());
        jobDataMap.put((Object)JobScheduleInfoConstants.JOB_PARAMETERS, jobParams);
        if (job.getPriority() != null) {
            jobDataMap.put(JobScheduleInfoConstants.JOB_PRIORITY, job.getPriority().toString());
            jobDataMap.put(JobScheduleInfoConstants.JOB_SELECTED_TEMPLATE_NAME, job.getTemplateName());
        }
        jobDataMap.put(JobScheduleInfoConstants.JOB_RULE_NAME, job.getRule().getType().getName());
        List<RuleParameter> ruleParams = this.cloneRuleParams(job.getRule().getParams());
        jobDataMap.put((Object)JobScheduleInfoConstants.JOB_RULE_PARAMETERS, ruleParams);
        jobDataMap.put((Object)JobScheduleInfoConstants.JOB_IS_ASSOCIATED_WITH_TITLES, (Object)job.isTitleAssociated());
        return jobDataMap;
    }

    private List<RuleParameter> cloneRuleParams(List<RuleParameter> params) {
        ArrayList<RuleParameter> clonedParams = new ArrayList<RuleParameter>();
        for (RuleParameter p : params) {
            RuleParameter param = new RuleParameter();
            param.setId(p.getId());
            param.setOrder(p.getOrder());
            param.setValue(p.getValue());
            clonedParams.add(param);
        }
        return clonedParams;
    }

    private List<JobParameter> cloneJobParams(List<JobParameter> jobParams) {
        ArrayList<JobParameter> clonedParams = new ArrayList<JobParameter>();
        for (JobParameter p : jobParams) {
            JobParameter param = new JobParameter();
            param.setId(p.getId());
            param.setName(p.getName());
            param.setValue(p.getValue());
            clonedParams.add(param);
        }
        return clonedParams;
    }

    public String getColleagueName() {
        return "com.tandbergtv.watchpoint.pmm.job.QuartzScheduleManager";
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(WorkflowEvent event) {
        ServiceEvent se;
        String servicename;
        if (event instanceof ServiceEvent && (servicename = (se = (ServiceEvent)event).getService().getServiceName()) == "Template Loader Service" && se.getEvent() == ServiceEvents.STARTED) {
            QuartzScheduleManager quartzScheduleManager = this;
            synchronized (quartzScheduleManager) {
                this.isTemplateServiceStarted = true;
            }
            this.start();
        }
    }

    static {
        SERVICE_NAME = "Job Scheduling service";
        JOB_GROUP_NAME = "Workflow PMM Jobs";
        TRIGGER_PREFIX = "TRIGGER";
        TRIGGER_JOBID_DELIMETER = "_";
        THREAD_FACTORY_THREAD_COUNT = 1;
        JOB_PROPERTIES_FILENAME = "com/tandbergtv/watchpoint/pmm/job/scheduling/job.quartz.properties";
        logger = Logger.getLogger(QuartzScheduleManager.class);
    }

    private static final /* synthetic */ void addSchedule_aroundBody0(QuartzScheduleManager this_, Job job) {
        String jobName = Long.toString(job.getId());
        Date jobEndDate = job.getRule().getEndDate();
        try {
            SimpleTrigger trigger;
            Class<?> callbackClass = Class.forName(job.getRule().getCallbackClass());
            JobDetail jobDetail = new JobDetail(jobName, JOB_GROUP_NAME, callbackClass);
            jobDetail.setDurability(true);
            jobDetail.setRequestsRecovery(true);
            jobDetail.setVolatility(true);
            jobDetail.setJobDataMap(this_.buildJobDataMap(job));
            String triggerName = TRIGGER_PREFIX + TRIGGER_JOBID_DELIMETER + job.getId();
            Class<?> timerClass = Class.forName(job.getRule().getTimeClass());
            ITimeRepresentation timer = (ITimeRepresentation)timerClass.newInstance();
            TimerResult result = (TimerResult)timer.getTime(job.getRule().getType().getParams(), job.getRule().getParams(), job.getRule().getStartDate());
            if (result == null) {
                String errorMsg = "Error while getting time from timer class. Result is null.";
                throw new RuntimeException(errorMsg);
            }
            if (result.getIsPeriodic()) {
                logger.info((Object)("Setting a periodic job starting at: " + result.getStartDate() + " every " + result.getRepeatInterval() + " msec."));
                trigger = new SimpleTrigger(triggerName, JOB_GROUP_NAME, jobName, JOB_GROUP_NAME, result.getStartDate(), jobEndDate, SimpleTrigger.REPEAT_INDEFINITELY, result.getRepeatInterval());
            } else {
                logger.info((Object)("Setting a one time job for date: " + result.getStartDate()));
                trigger = new SimpleTrigger(triggerName, JOB_GROUP_NAME, result.getStartDate());
                trigger.setJobName(jobName);
                trigger.setJobGroup(JOB_GROUP_NAME);
            }
            trigger.setMisfireInstruction(4);
            trigger.setVolatility(true);
            trigger.addTriggerListener(MissedTriggerListener.NAME);
            this_.scheduler.addJob(jobDetail, true);
            this_.scheduler.scheduleJob((Trigger)trigger);
            logger.info((Object)("Done scheduling job: " + jobDetail.getName()));
        }
        catch (SchedulerException se) {
            String errorMsg = "Error while scheduling job: " + se.toString();
            throw new RuntimeException(errorMsg, se);
        }
        catch (InstantiationException e1) {
            String errorMsg = "Error while instantiating timer class: " + e1.toString();
            throw new RuntimeException(errorMsg, e1);
        }
        catch (IllegalAccessException e2) {
            String errorMsg = "Error while accessing timer class: " + e2.toString();
            throw new RuntimeException(errorMsg, e2);
        }
        catch (ClassNotFoundException e3) {
            String errorMsg = "Error while loading timer class: " + e3.toString();
            throw new RuntimeException(errorMsg, e3);
        }
        catch (IllegalArgumentException e4) {
            String errorMsg = "Error while passing arguments for job/trigger: " + e4.toString();
            throw new RuntimeException(errorMsg, e4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object addSchedule_aroundBody1$advice(QuartzScheduleManager this_, Job transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            QuartzScheduleManager.addSchedule_aroundBody0(this_, transactional);
            return null;
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            QuartzScheduleManager.addSchedule_aroundBody0(this_, transactional);
            Object var7_8 = null;
            object.commit();
            return var7_8;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void deleteSchedules_aroundBody2(QuartzScheduleManager this_, Job job) {
        try {
            String jobName = Long.toString(job.getId());
            if (this_.scheduler.getJobDetail(jobName, JOB_GROUP_NAME) == null) {
                String errorMsg = "Scheduler did not find job: " + jobName + " hence cannot delete it.";
                throw new RuntimeException(errorMsg);
            }
            this_.scheduler.deleteJob(jobName, JOB_GROUP_NAME);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Error while deleting job: " + job.getId() + ":", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object deleteSchedules_aroundBody3$advice(QuartzScheduleManager this_, Job transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            QuartzScheduleManager.deleteSchedules_aroundBody2(this_, transactional);
            return null;
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            QuartzScheduleManager.deleteSchedules_aroundBody2(this_, transactional);
            Object var7_8 = null;
            object.commit();
            return var7_8;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void updateSchedule_aroundBody4(QuartzScheduleManager this_, Job job) {
        String jobName = Long.toString(job.getId());
        try {
            JobDetail detail = this_.scheduler.getJobDetail(jobName, JOB_GROUP_NAME);
            if (detail == null) {
                String errorMsg = "Job: " + jobName + " does not exist.";
                throw new RuntimeException(errorMsg);
            }
            this_.deleteSchedules(job);
            this_.addSchedule(job);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating job schedule: ", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object updateSchedule_aroundBody5$advice(QuartzScheduleManager this_, Job transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            QuartzScheduleManager.updateSchedule_aroundBody4(this_, transactional);
            return null;
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            QuartzScheduleManager.updateSchedule_aroundBody4(this_, transactional);
            Object var7_8 = null;
            object.commit();
            return var7_8;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

