/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.tandbergtv.watchpoint.pmm.entities.Context;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.notify.AbstractNotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.util.ContextManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;

public class PitchNotificationGenerator
extends AbstractNotificationGenerator {
    @Override
    protected String getType() {
        return "pitch";
    }

    @Override
    protected void addMessage(Notification notification, String status, Collection<Title> titles) {
        String message = super.constructMessage(status, titles);
        Schedule schedule = notification.getSchedule();
        String destination = this.getDestination(schedule);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(schedule.getDate());
        notification.addMessage("Pitch on " + date + " to " + destination + ", " + message);
    }

    private String getDestination(Schedule schedule) {
        IContainer container;
        long contextId = schedule.getContextID();
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Container Cache");
        if (cache != null && (container = (IContainer)cache.get((Serializable)Long.valueOf(contextId))) != null) {
            return container.getContainerName();
        }
        Context context = ContextManager.getInstance().getContext(contextId);
        if (context != null) {
            return context.getContainer().getContainerName();
        }
        throw new ScheduleRuntimeException("Cannot find destination " + contextId + " for schedule " + schedule);
    }

    @Override
    protected boolean isTitleDelayed(Title title, Schedule schedule, String status) {
        return schedule.getProgressItem(title, status) == null;
    }
}

