/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.tandbergtv.watchpoint.pmm.core.ProgressEvent;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.entities.event.AssetListEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationGeneratorFactory;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ScheduleNotifierService
implements IScheduleNotifier,
IColleague {
    private ISchedulerService<Void> scheduler;
    private Collection<Notification> notifications = new HashSet<Notification>();
    private static final long ONE_MINUTE_MILLIS = 60000L;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static final String SERVICE_NAME = "Schedule Notifier";
    private static final Logger logger = Logger.getLogger(ScheduleNotifierService.class);

    public Notification getNotification(Schedule schedule) {
        for (Notification notification : this.notifications) {
            if (!notification.getSchedule().equals((Object)schedule)) continue;
            return notification;
        }
        return null;
    }

    public Collection<Notification> getCurrentNotifications() {
        return this.notifications;
    }

    public String getColleagueName() {
        return SERVICE_NAME;
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(WorkflowEvent event) {
        if (!(event instanceof AssetListEvent || event instanceof ProgressEvent || event instanceof TitleStatusUpdatedEvent)) {
            return;
        }
        if (event instanceof TitleStatusUpdatedEvent) {
            Collection associatedAssetLists = ((TitleStatusUpdatedEvent)event).getTitle().getTitlelists();
            if (associatedAssetLists == null) {
                return;
            }
            for (IAssetList associatedAssetList : associatedAssetLists) {
                if (associatedAssetList.getType() != TitleListType.PLANNER) continue;
                ISchedulePersistenceService service = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
                Schedule s = service.get((Serializable)associatedAssetList.getId());
                this.reCalculateNotification(s);
            }
        } else {
            Schedule schedule = this.getSchedule(event);
            if (schedule == null) {
                return;
            }
            this.reCalculateNotification(schedule);
        }
    }

    private void reCalculateNotification(Schedule schedule) {
        Notification notification;
        logger.debug((Object)(schedule + ", recalculating notification"));
        this.removeNotification(schedule);
        if (this.fallsWithinWindow(schedule) && (notification = this.generate(schedule)) != null) {
            this.addNotification(notification);
        }
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.scheduler = new Scheduler("Notifications", 1, 1);
        this.scheduler.start();
        DefaultMediator.getInstance().register((IColleague)this);
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    ScheduleNotifierService.this.generate();
                }
                catch (Exception e) {
                    logger.error((Object)"Failure during generating notifications", (Throwable)e);
                }
            }
        }, 0L, 86400000L);
    }

    public void stop() {
        this.scheduler.stop();
    }

    private Schedule getSchedule(WorkflowEvent event) {
        if (event instanceof AssetListEvent) {
            AssetListEvent e = (AssetListEvent)AssetListEvent.class.cast(event);
            AssetList list = e.getList();
            if (list instanceof Schedule) {
                return (Schedule)Schedule.class.cast(list);
            }
        } else {
            ProgressEvent e = (ProgressEvent)((Object)ProgressEvent.class.cast(event));
            Long scheduleId = e.getScheduleId();
            if (scheduleId != null) {
                ISchedulePersistenceService service = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
                return service.get((Serializable)scheduleId);
            }
        }
        return null;
    }

    private void generate() {
        Collection<Schedule> schedules = this.getSchedules();
        this.removeNotifications();
        for (Schedule schedule : schedules) {
            Notification notification = this.generate(schedule);
            if (notification == null) continue;
            this.notify(notification);
        }
    }

    private Notification generate(Schedule schedule) {
        if (!(schedule instanceof Planner) && !(schedule instanceof DistributionSchedule)) {
            return null;
        }
        NotificationGeneratorFactory factory = NotificationGeneratorFactory.newInstance();
        INotificationGenerator generator = factory.newGenerator(schedule);
        Notification notification = generator.getNotification(schedule);
        return notification;
    }

    private void notify(Notification notification) {
        this.addNotification(notification);
        for (String message : notification.getMessages()) {
            logger.warn((Object)message);
        }
    }

    private void addNotification(Notification notification) {
        this.notifications.add(notification);
    }

    private void removeNotifications() {
        this.notifications.clear();
    }

    private void removeNotification(Schedule schedule) {
        Iterator<Notification> i = this.notifications.iterator();
        while (i.hasNext()) {
            Notification notification = i.next();
            if (!schedule.equals((Object)notification.getSchedule())) continue;
            i.remove();
            break;
        }
    }

    private boolean fallsWithinWindow(Schedule schedule) {
        Date date = schedule.getDate();
        return date.after(this.getWindowStart()) && date.before(this.getWindowEnd());
    }

    private Collection<Schedule> getSchedules() {
        IScheduleSearchService service = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Collection schedules = service.search(this.getSearchCriteria(DistributionSchedule.class));
        schedules.addAll(service.search(this.getSearchCriteria(Planner.class)));
        return schedules;
    }

    private SearchCriteria getSearchCriteria(Class<?> clazz) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", clazz, "s");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter(this.getDateRangeCriterion());
        e.addParameter((SearchParameterBase)new SortParameter(ScheduleSearchKey.PITCH_DATE.toString(), SortingOrder.DESCENDING));
        criteria.addParameter((SearchParameterBase)e);
        return criteria;
    }

    private SearchParameterBase getDateRangeCriterion() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date from = this.getWindowStart();
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, formatter.format(from));
        Date to = this.getWindowEnd();
        range.setTo(formatter.format(to));
        return range;
    }

    private Date getWindowStart() {
        Date today = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(today);
        ((Calendar)calendar).add(2, -1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private Date getWindowEnd() {
        Date today = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(today);
        ((Calendar)calendar).add(5, 7);
        return calendar.getTime();
    }
}

