/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.metadatamanager.JPFActivator;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.title.DefaultTitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationBuilder;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.specs.RightsManagerFactory;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderRegistry;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.DefaultTitleSearchStrategy;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.TitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.TitleProviderFactory;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.TitleProviderRegistry;
import com.tandbergtv.watchpoint.pmm.title.search.ITitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.title.template.TitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.title.validation.ITitleValidationService;
import com.tandbergtv.watchpoint.pmm.title.validation.TitleValidationService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginRegistry;
import org.springframework.context.ApplicationContext;

public class TitleActivator {
    private static final String PROVIDER_NAME = "Default";
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    public static final String PLUGIN_FOLDER_RELATIVE_PATH = "plugins";
    public static final String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";
    public static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String[] CONTEXT_CONFIG_FILES = new String[]{"MetadataBeansContext.xml", "com/tandbergtv/watchpoint/pmm/dao/hibernate/TitleMetadataManagerDB_JTA_Context.xml", "META-INF/metadatamanager/MDM_DataSource.xml"};
    private static final Logger logger = Logger.getLogger(TitleActivator.class);

    public void start() {
        ApplicationContext context = this.initializeSpringContext();
        PluginManager pluginManager = this.intializeMetadataPlugins();
        HibernateContext.getContext().initializeContext();
        this.addService((Service)new DefaultTitlePersistenceService());
        this.addService((Service)new TitleSearchService());
        this.addService(new TitleProviderRegistry());
        this.addService((Service)SpecificationManager.newInstance());
        this.addService(new TitleValidationService());
        this.addService((Service)TitleService.getInstance());
        this.addService(new TitleTemplateProvider());
        this.addDefaultTitleProvider();
        this.addMetadataFormatSpecifications(pluginManager, context);
        this.addTitleProviders(pluginManager);
        this.loadRightsManager(pluginManager);
        logger.debug((Object)"Title services started");
    }

    private void loadRightsManager(PluginManager pluginManager) {
        PluginRegistry registry = pluginManager.getRegistry();
        ExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, "rightsManager");
        RightsManagerFactory.createRightsManager(pluginManager, point);
    }

    public void stop() {
        this.removeTitleProviders();
        this.removeService(ITitleTemplateProvider.class);
        this.removeService(ITitleService.class);
        this.removeService(ITitleValidationService.class);
        this.removeService(ISpecificationManager.class);
        this.removeService(ITitleProviderRegistry.class);
        this.removeService(ITitleSearchService.class);
        this.removeService(ITitlePersistenceService.class);
        HibernateContext.getContext().closeContext();
        logger.debug((Object)"Title services stopped");
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void addTitleProviders(PluginManager pluginManager) {
        ITitleProviderRegistry registry = (ITitleProviderRegistry)ServiceRegistry.getDefault().lookup(ITitleProviderRegistry.class);
        for (ITitleProvider provider : this.loadTitleProviders(pluginManager)) {
            registry.addProvider(provider);
        }
    }

    private void addDefaultTitleProvider() {
        ITitleProviderRegistry registry = (ITitleProviderRegistry)ServiceRegistry.getDefault().lookup(ITitleProviderRegistry.class);
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        HashSet<String> names = new HashSet<String>();
        DefaultTitleSearchStrategy strategy = new DefaultTitleSearchStrategy();
        for (Specification spec : sm.getAllSpecifications()) {
            names.add(spec.getName());
        }
        TitleProvider provider = new TitleProvider(TitleSearchKey.DEFAULT_SYSTEM_ID.toString(), PROVIDER_NAME, strategy, names);
        strategy.setTitleProvider(provider);
        registry.addProvider(provider);
    }

    private void removeTitleProviders() {
    }

    private Collection<ITitleProvider> loadTitleProviders(PluginManager pluginManager) {
        HashSet<ITitleProvider> providers = new HashSet<ITitleProvider>();
        PluginRegistry registry = pluginManager.getRegistry();
        ExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, "titleprovider");
        TitleProviderFactory factory = TitleProviderFactory.newInstance();
        for (Extension extension : point.getAvailableExtensions()) {
            try {
                ITitleProvider provider = factory.createProvider(pluginManager, extension);
                providers.add(provider);
            }
            catch (Exception e) {
                String id = extension.getDeclaringPluginDescriptor().getId();
                id = id + ":" + extension.getId();
                logger.error((Object)("Failed to load Title Provider for extension[" + id + "], error: " + e.getMessage()), (Throwable)e);
            }
        }
        return providers;
    }

    private void addMetadataFormatSpecifications(PluginManager pluginManager, ApplicationContext context) {
        new com.tandbergtv.metadatamanager.conf.SpecificationBuilder(pluginManager, context).buildSpecifications();
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        SpecificationBuilder builder = SpecificationBuilder.createInstance(pluginManager, SpecHandlerFactory.getHandlers());
        for (Specification specification : builder.buildSpecifications()) {
            sm.addSpecification(specification);
        }
    }

    private ApplicationContext initializeSpringContext() {
        logger.debug((Object)"Initializing the Metadata Manager spring context...");
        ApplicationContextHelper helper = new ApplicationContextHelper(CONTEXT_CONFIG_FILES);
        logger.debug((Object)"Successfully initialized the Metadata Manager spring context.");
        return helper.getContext();
    }

    private PluginManager intializeMetadataPlugins() {
        Properties properties = new Properties();
        String installFolder = System.getProperty(PRODUCT_DIR);
        File pluginFolder = new File(installFolder, PLUGIN_FOLDER_RELATIVE_PATH);
        properties.put(JPF_PLUGIN_REPOSITORY_PROPERTY, pluginFolder.getAbsolutePath());
        JPFActivator jpfActivator = new JPFActivator();
        jpfActivator.start(properties);
        return jpfActivator.getPluginManager();
    }
}

