/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.marvin.udt.ValidationMessage;
import com.tandbergtv.marvin.udt.ValidationMessageType;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.MetadataValueFieldInfo;
import com.tandbergtv.metadatamanager.search.SearchInfo;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.MultipleTitlesForAnAssetException;
import com.tandbergtv.watchpoint.pmm.core.NoTitleForAnAssetException;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleServiceException;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.MenuOption;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.search.EntityName;
import com.tandbergtv.watchpoint.pmm.title.search.ITitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.search.ParamType;
import com.tandbergtv.watchpoint.pmm.title.search.SearchField;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchCriteriaBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.pmm.title.validation.TitleValidationCode;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.hibernate.classic.Session;
import org.w3c.dom.Document;

public class TitleService
implements ITitleService {
    private static final String SERVICE_NAME = "Title Service";
    private static final Logger logger = Logger.getLogger(TitleService.class);
    private static TitleService _instance;
    private ITitlePersistenceService titlePersistenceService;
    private ITitleSearchService titleSearchService;

    public static synchronized TitleService getInstance() {
        if (_instance == null) {
            _instance = new TitleService();
        }
        return _instance;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titlePersistenceService = this.getService(ITitlePersistenceService.class);
        this.titleSearchService = this.getService(ITitleSearchService.class);
    }

    public void stop() {
    }

    public Title approve(long titleID) throws PMMException {
        logger.debug((Object)("Approving title: [" + titleID + "]"));
        Title title = this.titlePersistenceService.get((Serializable)Long.valueOf(titleID));
        if (title.getStatus() != TitleStatus.READY) {
            throw new PMMException("Title status is " + title.getStatus() + " | Has to be " + TitleStatus.READY + " to be approved");
        }
        title.setStatus(TitleStatus.APPROVED);
        this.save(title);
        return title;
    }

    public Title disapprove(long titleID) throws PMMException {
        logger.debug((Object)("Disapproving title: [" + titleID + "]"));
        Title title = this.titlePersistenceService.get((Serializable)Long.valueOf(titleID));
        if (title.getStatus() != TitleStatus.APPROVED) {
            throw new PMMException("Title status is " + title.getStatus() + " | Has to be " + TitleStatus.APPROVED + " to be unapproved");
        }
        title.setStatus(TitleStatus.READY);
        this.save(title);
        return title;
    }

    public Collection<Asset> findAssetsWithFileName(String fileName) {
        AssetSearchService service = ApplicationContextHelper.getInstance().getAssetSearchService();
        SearchInfo info = this.buildSearchInfo(fileName);
        SearchCriteria criteria = service.getCriteria("asset", info, null, TitleSearchCriteriaBuilder.LATEST_REVISION);
        return service.search(criteria);
    }

    private SearchInfo buildSearchInfo(String filePath) {
        SearchInfo info = new SearchInfo();
        info.setProperty(AssetSearchKey.FIELDS.toString());
        ArrayList<MetadataValueFieldInfo> searchFields = new ArrayList<MetadataValueFieldInfo>();
        searchFields.add(new MetadataValueFieldInfo(FieldName.URL.toString(), SearchOperator.EQUAL, filePath));
        info.setFields(searchFields);
        return info;
    }

    @Deprecated
    public Title getExternalTitle(String specification, String externalLocationId, Map<String, String> keys) {
        SearchCriteria criteria = this.buildSearchCriteria(specification, externalLocationId, keys);
        Collection titles = this.titleSearchService.search(criteria);
        if (titles == null || titles.size() == 0) {
            String msg = "Failed to find any Title from external source[" + externalLocationId + "] for specification: " + specification + " using keys: " + keys;
            com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage message = new com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage(TitleValidationCode.EXTERNAL_TITLE_MISSING.getCode());
            throw new TitleServiceException(message, msg);
        }
        if (titles.size() > 1) {
            String msg = "Failed to find a unique Title from external source[" + externalLocationId + "] for specification: " + specification + " using keys: " + keys + ", found " + titles.size() + " titles.";
            com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage message = new com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage(TitleValidationCode.EXTERNAL_TITLE_DUPLICATE.getCode());
            message.getProperties().add(Integer.toString(titles.size()));
            throw new TitleServiceException(message, msg);
        }
        return (Title)titles.iterator().next();
    }

    @Deprecated
    public Title importTitle(Title title) {
        this.save(title);
        this.updateProgressItems(title);
        return title;
    }

    @Deprecated
    public Title syncTitle(Title title) {
        return null;
    }

    @Deprecated
    private void syncTitle(Title source, Title target) {
    }

    @Deprecated
    private void updateProgressItems(Title title) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IPMMService pmmService = (IPMMService)registry.lookup(IPMMService.class);
        pmmService.sendMetadataReceivedStatus(title, null, null, null);
        for (Asset sectionAsset : title.getAsset().getAllDescendantItems(false)) {
            Item sectionItem = (Item)sectionAsset;
            Field fileMetadataField = sectionItem.getFirstField(FieldName.URL.toString());
            if (fileMetadataField == null || fileMetadataField.getValue() == null || fileMetadataField.getValue().trim().length() <= 0) continue;
            pmmService.sendAssetReceivedStatus(title, sectionItem.getType(), null, null, null);
        }
    }

    @Deprecated
    private String evaluate(Title rootTitle, MenuOption jpmo) {
        return null;
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    private SearchCriteria buildSearchCriteria(String specName, String externalSourceId, Map<String, String> metadataKeys) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.setRecordsCount(2);
        Entity entity = new Entity(EntityName.TITLE.toString(), Title.class, "t");
        criteria.addParameter((SearchParameterBase)entity);
        entity.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_SPEC.toString(), SearchType.STRING, (Object)specName));
        String titleProviderId = this.getTitleProviderId(externalSourceId);
        criteria.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_PROVIDER_ID.toString(), SearchType.STRING, (Object)titleProviderId));
        entity.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_EXTERNAL_LOCATION.toString(), SearchType.STRING, (Object)externalSourceId));
        if (metadataKeys != null) {
            for (String key : metadataKeys.keySet()) {
                String value = metadataKeys.get(key);
                Entity metadata = new Entity(key, TitleSearchKey.COMPLETE_METADATA.toString(), "m");
                metadata.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.METADATA_NAME.toString(), SearchType.STRING, (Object)key));
                metadata.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.METADATA_VALUE.toString(), SearchType.STRING, (Object)value));
                entity.addParameter((SearchParameterBase)metadata);
            }
        }
        return criteria;
    }

    private String getTitleProviderId(String externalSourceId) {
        String providerId = null;
        if (externalSourceId != null) {
            String[] values = externalSourceId.split("-");
            providerId = values.length > 0 ? values[0] : "";
        }
        return providerId;
    }

    public Title getTitle(Asset rootAsset) {
        ArrayList<SearchField> searchFields = new ArrayList<SearchField>();
        SearchField field = new SearchField();
        field.setName("asset.id");
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(rootAsset.getId()));
        field.setValues(values);
        field.setParamType(ParamType.VALUE);
        field.setSearchOperator(SearchOperator.EQUAL);
        field.setSearchType(SearchType.NUMERIC);
        searchFields.add(field);
        SearchCriteria criteria = TitleSearchCriteriaBuilder.getCriteria((boolean)true, (String)"", (String)"", searchFields, (int)0, (int)Integer.MAX_VALUE, null, null, null);
        Collection matchingTitles = this.titleSearchService.search(criteria);
        if (matchingTitles.size() == 0) {
            throw new NoTitleForAnAssetException("No title found with asset id: " + rootAsset.getId());
        }
        if (matchingTitles.size() > 1) {
            throw new MultipleTitlesForAnAssetException("Multiple titles found with asset id: " + rootAsset.getId());
        }
        return (Title)matchingTitles.iterator().next();
    }

    public Collection<Title> getTitle(Document metadata) {
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadata);
        ArrayList<Asset> matchingAssets = new ArrayList<Asset>();
        try {
            List identifiers = specHandler.getIdentifiers(metadata);
            if (identifiers != null) {
                for (IIdentifier identifier : identifiers) {
                    matchingAssets.add(identifier.getAsset());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get matching Asset for the metadata document.", e);
        }
        ArrayList<Title> titles = new ArrayList<Title>();
        for (Asset a : matchingAssets) {
            titles.add(this.getTitle(a));
        }
        return titles;
    }

    @Transactional
    public Document getMetadata(Long titleId, String spec) throws MetadataException, SearchException, TranslationException {
        Long l = titleId;
        String string = spec;
        return (Document)TitleService.getMetadata_aroundBody1$advice(this, l, string, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("getMetadata", Long.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Collection<Field> getAllDecendantFields(long id) {
        long l = id;
        return (Collection)TitleService.getAllDecendantFields_aroundBody3$advice(this, l, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("getAllDecendantFields", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void nationalizeAndSave(Long titleId, String sourceComponentName, String sourceEntityName, String sourceId) {
        Long l = titleId;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        TitleService.nationalizeAndSave_aroundBody5$advice(this, l, string, string2, string3, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("nationalizeAndSave", Long.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void saveAsDraft(Title title) {
        Title title2 = title;
        TitleService.saveAsDraft_aroundBody7$advice(this, title2, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("saveAsDraft", Title.class).getAnnotation(Transactional.class), null);
    }

    private void save(Title title) {
        TitleStatus oldStatus = title.getStatus();
        this.getService(IPMMService.class).updateTitleStatus(title);
        this.titlePersistenceService.save(title);
        TitleStatus newStatus = title.getStatus();
        if (newStatus != oldStatus) {
            TitleStatusUpdatedEvent event = new TitleStatusUpdatedEvent((Object)this, title, oldStatus, newStatus);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
        }
    }

    private List<TitleValidationMessage> validate(Title title) throws TitleValidationException {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        assets.add(title.getAsset());
        List descendantAssets = title.getAsset().getAllDescendantItems(false);
        if (descendantAssets != null) {
            assets.addAll(descendantAssets);
        }
        for (Asset asset : assets) {
            logger.debug((Object)("Asset: " + asset));
            boolean originalFileAlreadyExist = false;
            List descendantFiles = asset.getAllDescendantFiles();
            if (descendantFiles == null) continue;
            for (com.tandbergtv.metadatamanager.model.File descendantFile : descendantFiles) {
                logger.debug((Object)("File: " + descendantFile + " | Is Original?: " + descendantFile.isOriginal()));
                if (!descendantFile.isOriginal()) continue;
                if (originalFileAlreadyExist) {
                    ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
                    TitleValidationMessage validationMessage = new TitleValidationMessage("More than one file of type ORIGINAL found mapped to asset [" + asset.getAssetType() + "]", TitleValidationMessage.Type.Error);
                    validationMessages.add(validationMessage);
                    throw new TitleValidationException(validationMessages);
                }
                originalFileAlreadyExist = true;
            }
        }
        List<ValidationMessage> validationMessages = RulesEngineFacade.validate(title);
        ArrayList<ValidationMessage> errorMessages = new ArrayList<ValidationMessage>();
        for (ValidationMessage validationMessage : validationMessages) {
            if (!validationMessage.getMessageType().equals((Object)ValidationMessageType.Error)) continue;
            errorMessages.add(validationMessage);
        }
        if (!errorMessages.isEmpty()) {
            throw new TitleValidationException(this.convertToLocalMessages(validationMessages));
        }
        return this.convertToLocalMessages(validationMessages);
    }

    private List<TitleValidationMessage> validateAndSave(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        List<TitleValidationMessage> validationMessages = this.validate(title);
        title.setStatus(TitleStatus.COMMITTED);
        this.save(title);
        IPMMService pmmService = this.getService(IPMMService.class);
        pmmService.sendStatus(title, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, sourceComponentName, sourceEntityName, sourceId);
        return validationMessages;
    }

    private List<TitleValidationMessage> convertToLocalMessages(Collection<ValidationMessage> messages) {
        ArrayList<TitleValidationMessage> localValidationMessages = new ArrayList<TitleValidationMessage>();
        if (messages != null) {
            for (ValidationMessage message : messages) {
                localValidationMessages.add(new TitleValidationMessage(message.getMessage(), TitleValidationMessage.Type.valueOf((String)message.getMessageType().name())));
            }
        }
        return localValidationMessages;
    }

    @Transactional
    public SaveResult create(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (SaveResult)TitleService.create_aroundBody9$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("create", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public SaveResult update(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (SaveResult)TitleService.update_aroundBody11$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("update", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private void moveFilesToMappedFilesDir(Asset asset) throws RuntimeException {
        AssetsManager assetsManager = AssetsManager.getThreadLocalInstance();
        List files = asset.getAllDescendantFiles();
        if (files != null) {
            for (com.tandbergtv.metadatamanager.model.File file : files) {
                String url;
                logger.debug((Object)("File: " + file));
                Field urlField = file.getFirstField(FieldName.FILE_URL.toString());
                if (urlField == null || (url = urlField.getValue()) == null || !url.startsWith(assetsManager.getUnmappedFilesDirectory().getAbsolutePath())) continue;
                File movedFile = null;
                try {
                    logger.debug((Object)("Attempting to move file [" + url + "] to mapped files dircetory."));
                    movedFile = AssetsManager.getThreadLocalInstance().moveToMappedFilesDirectory(new File(url));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to move file [" + url + "] from unmapped files directory to mapped files directory [" + assetsManager.getMappedFilesDirectory() + "]. ", e);
                }
                if (movedFile == null) continue;
                logger.debug((Object)("Moved file [" + url + "] to [" + movedFile.getAbsolutePath() + "]"));
                urlField.setValue(movedFile.getAbsolutePath());
            }
        }
    }

    @Transactional
    public SaveResult updateMetadata(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (SaveResult)TitleService.updateMetadata_aroundBody13$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("updateMetadata", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Title rollback(Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) throws MetadataException, SearchException, TranslationException, InvalidRevisionException, TitleValidationException {
        Long l = titleId;
        String string = version;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (Title)TitleService.rollback_aroundBody15$advice(this, l, string, string2, string3, string4, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("rollback", Long.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private Title doRollback(Long titleId, String version) throws MetadataException, SearchException, TranslationException, InvalidRevisionException {
        Title title = this.titlePersistenceService.get((Serializable)titleId);
        TTVId ttvId = title.getAsset().getTTVId();
        Session session = ApplicationContextHelper.getInstance().getSessionFactory().getCurrentSession();
        session.evict((Object)ttvId);
        session.evict((Object)title.getAsset());
        ISpecHandler ttvHandler = SpecHandlerFactory.getInstance((String)"TTV");
        ttvHandler.rollBackToRevision(ttvId, version);
        ITTVDataModelHandler ttvDataModelHandler = (ITTVDataModelHandler)ttvHandler;
        Asset rolledbackAsset = ttvDataModelHandler.getAsset(ttvId);
        title.setAsset(rolledbackAsset);
        return title;
    }

    public Document previewTitle(Title title, String spec) throws TranslationException {
        ISpecHandler handler = SpecHandlerFactory.getInstance((String)spec);
        Document doc = handler.convertAssetToXMLDocument(title.getAsset());
        return doc;
    }

    @Transactional
    public Title rollbackAndSaveAsDraft(Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) throws MetadataException, SearchException, TranslationException, InvalidRevisionException {
        Long l = titleId;
        String string = version;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (Title)TitleService.rollbackAndSaveAsDraft_aroundBody17$advice(this, l, string, string2, string3, string4, TransactionEnforcer.aspectOf(), TitleService.class.getDeclaredMethod("rollbackAndSaveAsDraft", Long.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ Document getMetadata_aroundBody0(TitleService this_, Long titleId, String spec) {
        ServiceRegistry registry;
        ISpecificationManager specManager;
        Specification specification;
        ISpecHandler specHandler;
        Document result = null;
        ITitlePersistenceService service = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
        Title t = service.get((Serializable)titleId);
        Asset groupAsset = t.getAsset();
        if (groupAsset != null && (specHandler = (specification = (specManager = (ISpecificationManager)(registry = ServiceRegistry.getDefault()).lookup(ISpecificationManager.class)).getSpecificationByName(spec)).getSpecHandler()) != null) {
            IIdentifier id = specHandler.extractId(groupAsset);
            result = specHandler.get(id);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getMetadata_aroundBody1$advice(TitleService this_, Long transactional, String ajc_aroundClosure, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_11 = e;
            void var11_12 = isTransactionOwner;
            return TitleService.getMetadata_aroundBody0(this_, transactional, ajc_aroundClosure);
        }
        try {
            transactionManager.begin();
            void var12_13 = e;
            void var13_14 = isTransactionOwner;
            Document document = TitleService.getMetadata_aroundBody0(this_, transactional, ajc_aroundClosure);
            transactionManager.commit();
            return document;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Collection getAllDecendantFields_aroundBody2(TitleService this_, long id) {
        ITitlePersistenceService service = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
        Title t = service.get((Serializable)Long.valueOf(id));
        t.getAsset().getAllDescendantAssetFields().size();
        for (Field f : t.getAsset().getAllDescendantAssetFields()) {
            f.setParentAsset(new AssetUtil().unWrap(f.getParentAsset()));
        }
        return t.getAsset().getAllDescendantAssetFields();
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getAllDecendantFields_aroundBody3$advice(TitleService this_, long transactional, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_10 = e;
            void var11_11 = isTransactionOwner;
            return TitleService.getAllDecendantFields_aroundBody2(this_, transactional);
        }
        try {
            transactionManager.begin();
            void var12_12 = e;
            void var13_13 = isTransactionOwner;
            Collection collection = TitleService.getAllDecendantFields_aroundBody2(this_, transactional);
            transactionManager.commit();
            return collection;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void nationalizeAndSave_aroundBody4(TitleService this_, Long titleId, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = this_.titlePersistenceService.get((Serializable)titleId);
        Title nationalizedTitle = RulesEngineFacade.nationalize(title);
        IPMMService pmmService = this_.getService(IPMMService.class);
        pmmService.sendStatus(nationalizedTitle, ProgressStatusHelper.NATIONALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
        try {
            this_.validateAndSave(nationalizedTitle, sourceComponentName, sourceEntityName, sourceId);
            RulesEngineFacade.sendNationalizedEvent(nationalizedTitle.getId());
        }
        catch (TitleValidationException e) {
            this_.saveAsDraft(nationalizedTitle);
            pmmService.sendStatus(nationalizedTitle, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object nationalizeAndSave_aroundBody5$advice(TitleService this_, Long transactional, String ajc_aroundClosure, String string, String string2, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            TitleService.nationalizeAndSave_aroundBody4(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
            return null;
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            TitleService.nationalizeAndSave_aroundBody4(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
            Object var10_11 = null;
            transactionManager2.commit();
            return var10_11;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void saveAsDraft_aroundBody6(TitleService this_, Title title) {
        title.setStatus(TitleStatus.DRAFT);
        this_.titlePersistenceService.save(title);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object saveAsDraft_aroundBody7$advice(TitleService this_, Title transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            TitleService.saveAsDraft_aroundBody6(this_, transactional);
            return null;
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            TitleService.saveAsDraft_aroundBody6(this_, transactional);
            Object var7_8 = null;
            object.commit();
            return var7_8;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ SaveResult create_aroundBody8(TitleService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        List<TitleValidationMessage> validationMessages = this_.validateAndSave(title, sourceComponentName, sourceEntityName, sourceId);
        IPMMService pmmService = this_.getService(IPMMService.class);
        pmmService.sendStatus(title, ProgressStatusHelper.CREATED, null, true, sourceComponentName, sourceEntityName, sourceId);
        return new SaveResult(title, validationMessages);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object create_aroundBody9$advice(TitleService this_, Title transactional, String ajc_aroundClosure, String string, String string2, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            return TitleService.create_aroundBody8(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            SaveResult saveResult = TitleService.create_aroundBody8(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
            transactionManager2.commit();
            return saveResult;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ SaveResult update_aroundBody10(TitleService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        List<TitleValidationMessage> validationMessages = this_.validateAndSave(title, sourceComponentName, sourceEntityName, sourceId);
        IPMMService pmmService = this_.getService(IPMMService.class);
        pmmService.sendStatus(title, ProgressStatusHelper.UPDATED, null, true, sourceComponentName, sourceEntityName, sourceId);
        return new SaveResult(title, validationMessages);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object update_aroundBody11$advice(TitleService this_, Title transactional, String ajc_aroundClosure, String string, String string2, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            return TitleService.update_aroundBody10(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            SaveResult saveResult = TitleService.update_aroundBody10(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
            transactionManager2.commit();
            return saveResult;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ SaveResult updateMetadata_aroundBody12(TitleService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title existingTitle = this_.titlePersistenceService.get((Serializable)title.getId());
        existingTitle.setAsset(title.getAsset());
        boolean success = false;
        try {
            this_.moveFilesToMappedFilesDir(existingTitle.getAsset());
            SaveResult result = this_.update(existingTitle, sourceComponentName, sourceEntityName, sourceId);
            success = true;
            SaveResult saveResult = result;
            return saveResult;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object updateMetadata_aroundBody13$advice(TitleService this_, Title transactional, String ajc_aroundClosure, String string, String string2, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            return TitleService.updateMetadata_aroundBody12(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            SaveResult saveResult = TitleService.updateMetadata_aroundBody12(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
            transactionManager2.commit();
            return saveResult;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Title rollback_aroundBody14(TitleService this_, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = this_.titlePersistenceService.get((Serializable)titleId);
        if (title.getStatus(version) == TitleStatus.DRAFT) {
            throw new RuntimeException("Cannot rollback to a DRAFT version.");
        }
        Title oldTitle = this_.titlePersistenceService.get((Serializable)titleId, version);
        List<ValidationMessage> validationMessages = RulesEngineFacade.validate(oldTitle);
        ArrayList<ValidationMessage> errorMessages = new ArrayList<ValidationMessage>();
        for (ValidationMessage validationMessage : validationMessages) {
            if (!validationMessage.getMessageType().equals((Object)ValidationMessageType.Error)) continue;
            errorMessages.add(validationMessage);
        }
        if (!errorMessages.isEmpty()) {
            throw new TitleValidationException(this_.convertToLocalMessages(errorMessages));
        }
        title.setStatus(TitleStatus.COMMITTED);
        title = this_.doRollback(titleId, version);
        this_.save(title);
        IPMMService pmmService = this_.getService(IPMMService.class);
        pmmService.sendStatus(title, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, sourceComponentName, sourceEntityName, sourceId);
        pmmService.sendStatus(title, ProgressStatusHelper.ROLLED_BACK, null, true, sourceComponentName, sourceEntityName, sourceId);
        return title;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object rollback_aroundBody15$advice(TitleService this_, Long transactional, String ajc_aroundClosure, String string, String string2, String string3, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            return TitleService.rollback_aroundBody14(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner, (String)e);
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            Title title = TitleService.rollback_aroundBody14(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner, (String)e);
            transactionManager2.commit();
            return title;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Title rollbackAndSaveAsDraft_aroundBody16(TitleService this_, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = this_.doRollback(titleId, version);
        this_.saveAsDraft(title);
        IPMMService pmmService = this_.getService(IPMMService.class);
        pmmService.sendStatus(title, ProgressStatusHelper.ROLLED_BACK, null, true, sourceComponentName, sourceEntityName, sourceId);
        return title;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object rollbackAndSaveAsDraft_aroundBody17$advice(TitleService this_, Long transactional, String ajc_aroundClosure, String string, String string2, String string3, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            return TitleService.rollbackAndSaveAsDraft_aroundBody16(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner, (String)e);
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            Title title = TitleService.rollbackAndSaveAsDraft_aroundBody16(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner, (String)e);
            transactionManager2.commit();
            return title;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

