/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.provider.internal;

import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderProperties;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleSearchStrategy;
import java.util.Collection;
import java.util.HashSet;

public abstract class AbstractTitleProvider
implements ITitleProvider {
    protected String systemId;
    protected String name;
    protected ITitleSearchStrategy strategy;
    protected Collection<String> specifications;
    protected ClassLoader classLoader;

    protected AbstractTitleProvider(ITitleProviderProperties properties) {
        this(properties, null);
    }

    protected AbstractTitleProvider(ITitleProviderProperties properties, ClassLoader classLoader) {
        this.systemId = properties.getSystemID();
        this.name = properties.getName();
        this.setSearchStrategy(properties.getSearchStrategy());
        this.specifications = new HashSet<String>();
        if (properties.getSupportedSpecifications() != null) {
            this.specifications.addAll(properties.getSupportedSpecifications());
        }
        this.classLoader = classLoader;
    }

    protected AbstractTitleProvider(String systemId, String name, String specification) {
        this.systemId = systemId;
        this.name = name;
        this.specifications = new HashSet<String>();
        this.specifications.add(specification);
    }

    protected AbstractTitleProvider(String systemId, String name, ITitleSearchStrategy strategy, Collection<String> specifications) {
        this.systemId = systemId;
        this.name = name;
        this.setSearchStrategy(strategy);
        this.specifications = specifications;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITitleSearchStrategy getSearchStrategy() {
        return this.strategy;
    }

    protected void setSearchStrategy(ITitleSearchStrategy strategy) {
        this.strategy = strategy;
        if (strategy != null) {
            strategy.setTitleProvider(this);
        }
    }

    @Override
    public Collection<String> getSupportedSpecifications() {
        return this.specifications;
    }

    @Override
    public String getSystemID() {
        return this.systemId;
    }

    @Override
    public boolean supportsSpecification(String specification) {
        return this.specifications.contains(specification);
    }

    public String toString() {
        return "[" + this.systemId + "] " + this.name;
    }
}

