/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import java.util.Collection;

public class MetadataMapInfo {
    private static final String TITLEID_PREFIX = "titleId:";
    private Status status;
    private StringBuffer mappedTitles = new StringBuffer();

    public MetadataMapInfo(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void addMappedTitle(Long titleId, boolean validationSuccess, Collection<String> titleNames) {
        if (this.mappedTitles.length() > 0) {
            this.mappedTitles.append(", ");
        }
        this.mappedTitles.append("[").append(TITLEID_PREFIX).append(titleId).append("|").append("Validation ").append(validationSuccess ? "Success" : "Failure").append("|");
        boolean firstTime = true;
        if (titleNames != null) {
            for (String titleName : titleNames) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.mappedTitles.append(", ");
                }
                this.mappedTitles.append(titleName);
            }
        }
        this.mappedTitles.append("]");
    }

    public String getMappedTitles() {
        return this.mappedTitles.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Status: ").append((Object)this.status).append(" | ");
        sb.append("Mapped Titles: ").append(this.mappedTitles);
        return sb.toString();
    }

    public static enum Status {
        TITLES_NOT_FOUND,
        TITLES_MERGED;

    }
}

