/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchServiceImpl;
import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.ListFieldInfo;
import com.tandbergtv.metadatamanager.search.MetadataValueFieldInfo;
import com.tandbergtv.metadatamanager.search.RangeFieldInfo;
import com.tandbergtv.metadatamanager.search.SearchInfo;
import com.tandbergtv.metadatamanager.search.SortInfo;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.SearchField;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.search.Association;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TitleSearchCriteriaBuilder {
    private static String ROOT_ENTITY_ALIAS = "rootAsset";
    public static int LATEST_REVISION = -1;

    public static SearchCriteria getCriteria(boolean isInternalSearch, String externalSourceId, String searchProperty, Collection<SearchField> searchFields, int startIndex, int maxRecordCount, String sortProperty, SortingOrder order, String sortName) {
        SearchCriteria criteria = new SearchCriteria();
        Entity title = new Entity("title", Title.class, "t");
        if (isInternalSearch) {
            criteria.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_PROVIDER_ID.toString(), SearchType.STRING, (Object)TitleSearchKey.DEFAULT_SYSTEM_ID));
        } else {
            criteria.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_PROVIDER_ID.toString(), SearchType.STRING, (Object)TitleSearchCriteriaBuilder.getTitleProviderId(externalSourceId)));
        }
        SearchInfo searchInfo = null;
        if (searchProperty.equals(AssetSearchKey.ALL_DESCENDANT_FIELDS.toString()) || searchProperty.equals(AssetSearchKey.FIELDS.toString())) {
            searchInfo = TitleSearchCriteriaBuilder.getSearchInfo(searchFields, searchProperty);
        } else {
            title = TitleSearchCriteriaBuilder.addSearchFields(title, searchFields);
        }
        SortInfo sortInfo = null;
        if (sortProperty != null && (sortProperty.equals(AssetSearchKey.ALL_DESCENDANT_FIELDS.toString()) || sortProperty.equals(AssetSearchKey.FIELDS.toString()))) {
            sortInfo = TitleSearchCriteriaBuilder.getSortInfo(order, sortName, sortProperty);
        } else {
            title = TitleSearchCriteriaBuilder.addSortField(title, order, sortName);
        }
        criteria.setStartingRecordNumber(startIndex);
        criteria.setRecordsCount(maxRecordCount);
        criteria.addParameter((SearchParameterBase)title);
        AssetSearchServiceImpl assetSearch = new AssetSearchServiceImpl();
        SearchCriteria assetCriteria = assetSearch.getCriteria(ROOT_ENTITY_ALIAS, searchInfo, sortInfo, LATEST_REVISION);
        Entity asset = (Entity)assetCriteria.getParameter(ROOT_ENTITY_ALIAS);
        Association a = new Association("titleAssetAssociation", title, "asset.id", asset, "id");
        criteria.addParameter((SearchParameterBase)a);
        criteria.addParameter((SearchParameterBase)asset);
        return criteria;
    }

    private static Entity addSortField(Entity title, SortingOrder order, String sortName) {
        if (sortName != null) {
            title.addParameter((SearchParameterBase)new SortParameter(sortName, order));
        }
        return title;
    }

    private static Entity addSearchFields(Entity title, Collection<SearchField> searchFields) {
        for (SearchField field : searchFields) {
            if (field.isListParameter()) {
                ListParameter listParam = new ListParameter(field.getName(), field.getSearchType(), field.getSearchOperator());
                listParam.setValues(field.getValues());
                continue;
            }
            if (field.isRangeParameter()) {
                RangeParameter rangeParam = new RangeParameter(field.getName(), field.getSearchType());
                rangeParam.setFrom(field.getValues().get(0));
                rangeParam.setTo(field.getValues().get(1));
                title.addParameter((SearchParameterBase)rangeParam);
                continue;
            }
            if (!field.isValueParameter()) continue;
            title.addParameter((SearchParameterBase)new ValueParameter(field.getName(), field.getSearchType(), (Object)field.getValues().get(0), field.getSearchOperator()));
        }
        return title;
    }

    private static SortInfo getSortInfo(SortingOrder order, String sortName, String sortKeyProperty) {
        if (sortName == null) {
            return null;
        }
        SortInfo info = new SortInfo();
        info.setOrder(order);
        info.setSortItemName(sortName);
        if (sortKeyProperty != null) {
            info.setProperty(sortKeyProperty.toString());
        }
        return info;
    }

    private static SearchInfo getSearchInfo(Collection<SearchField> searchFields, String fieldProperty) {
        if (searchFields.size() == 0) {
            return null;
        }
        SearchInfo info = new SearchInfo();
        info.setProperty(fieldProperty);
        List<FieldInfo> fields = TitleSearchCriteriaBuilder.getFields(searchFields);
        info.setFields(fields);
        return info;
    }

    private static List<FieldInfo> getFields(Collection<SearchField> searchFields) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (SearchField field : searchFields) {
            FieldInfo finfo = TitleSearchCriteriaBuilder.getFieldInfo(field);
            if (field.getSectionName() != null) {
                finfo.setAssetType(field.getSectionName());
            }
            fields.add(finfo);
        }
        return fields;
    }

    private static FieldInfo getFieldInfo(SearchField field) {
        if (field.isListParameter()) {
            return new ListFieldInfo(field.getName(), field.getValues(), field.getSearchOperator());
        }
        if (field.isValueParameter()) {
            String value = "";
            if (field.getValues() != null) {
                value = field.getValues().get(0);
            }
            return new MetadataValueFieldInfo(field.getName(), field.getSearchOperator(), value);
        }
        if (field.isRangeParameter()) {
            return new RangeFieldInfo(field.getName(), field.getValues().get(0), field.getValues().get(1));
        }
        return null;
    }

    private static String getTitleProviderId(String externalSourceId) {
        String providerId = null;
        if (externalSourceId != null) {
            String[] values = externalSourceId.split("-");
            providerId = values.length > 0 ? values[0] : "";
        }
        return providerId;
    }
}

