/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.DurationAware;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.taskmgmt.def.Task;

public abstract class AbstractTaskNode
extends TaskNode
implements DurationAware,
ResourceGroupAware {
    private Long resourceGroupID = DEFAULT_RESOURCE_GROUP_ID;
    private String duration;
    private String taskDuration;
    private static final Long DEFAULT_RESOURCE_GROUP_ID = -1L;
    private static final Logger logger = Logger.getLogger(AbstractTaskNode.class);
    public static final String[] supportedEventTypes = new String[]{"node-enter", "node-leave", "before-signal", "after-signal"};
    private static final long serialVersionUID = 36501193930537732L;

    public AbstractTaskNode() {
    }

    public AbstractTaskNode(String name) {
        super(name);
    }

    @Override
    public String getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(String duration) {
        this.duration = duration;
    }

    @Override
    public Long getResourceGroupID() {
        if (this.resourceGroupID.equals(DEFAULT_RESOURCE_GROUP_ID)) {
            return null;
        }
        return this.resourceGroupID;
    }

    @Override
    public void setResourceGroupID(Long resourceGroupID) {
        this.resourceGroupID = resourceGroupID == null ? DEFAULT_RESOURCE_GROUP_ID : resourceGroupID;
    }

    @Override
    public String getTaskDuration() {
        return this.taskDuration;
    }

    @Override
    public void setTaskDuration(String taskDuration) {
        this.taskDuration = taskDuration;
    }

    public void enter(ExecutionContext executionContext) {
        CustomToken token = (CustomToken)executionContext.getToken();
        token.setNode((Node)this);
        if (token.getStatus() != ProcessStatus.RUNNING) {
            throw new InvalidProcessStateException(token.toString());
        }
        logger.info((Object)(token + " (" + this.name + ")"));
        this.fireEvent("node-enter", executionContext);
        token.acquire();
        token.setNodeEnter(new Date());
        executionContext.setTransition(null);
        executionContext.setTransitionSource(null);
        this.execute(executionContext);
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        CustomToken token = (CustomToken)executionContext.getToken();
        if (token.getStatus() != ProcessStatus.BUSY) {
            throw new InvalidProcessStateException(token.toString());
        }
        logger.info((Object)(token + " (" + this.name + ")"));
        token.setNode((Node)this);
        executionContext.setTransition(transition);
        this.fireEvent("node-leave", executionContext);
        token.addLog((ProcessLog)new NodeLog((Node)this, token.getNodeEnter(), new Date()));
        executionContext.setTransitionSource((Node)this);
        token.release();
        transition.take(executionContext);
    }

    public void read(Element nodeElement, JpdlXmlReader jpdlXmlReader) {
        this.action = jpdlXmlReader.readSingleAction(nodeElement);
        this.setDuration(nodeElement.attributeValue("duration"));
        this.setTaskDuration(nodeElement.attributeValue("taskDuration"));
        super.read(nodeElement, jpdlXmlReader);
    }

    public void addTask(Task task) {
        if (this.getTasks() != null) {
            logger.warn((Object)"Can add exactly one task to this node");
            return;
        }
        super.addTask(task);
    }
}

