/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.WFSInterpreter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DurationUtility {
    private static final String ZERO_TIME = "00:00:00";
    private static final long ONE_DAY_MILLIS = 86400000L;
    private final SimpleDateFormat shortformat = new SimpleDateFormat("HH:mm:ss");
    private final SimpleDateFormat longformat = new SimpleDateFormat("dd'T'HH:mm:ss");
    private final long zero;
    private static final Logger logger = Logger.getLogger(DurationUtility.class);

    public DurationUtility() {
        try {
            this.zero = this.shortformat.parse(ZERO_TIME).getTime();
        }
        catch (ParseException e) {
            throw new Error();
        }
    }

    public String addDates(String str1, String str2) {
        Date date = null;
        try {
            long t1 = this.convertToMillis(this.shortformat, str1);
            long t2 = this.convertToMillis(this.shortformat, str2);
            date = new Date(t1 + t2 + this.zero);
            logger.debug((Object)(str1 + " + " + str2 + " -> " + date));
        }
        catch (ParseException e) {
            logger.error((Object)("Failed to add dates " + str1 + ", " + str2), (Throwable)e);
        }
        return this.longformat.format(date);
    }

    public String multiplyDate(String str, double factor) {
        Date date = null;
        try {
            long t = this.convertToMillis(this.shortformat, str);
            long resultMillis = new Double((double)t * factor).longValue();
            date = new Date(resultMillis + this.zero);
            logger.debug((Object)(str + " * " + factor + " -> " + date));
        }
        catch (ParseException e) {
            logger.error((Object)("Failed to multiply date " + str), (Throwable)e);
        }
        return this.longformat.format(date);
    }

    public long getDurationInMillis(String str, WFSInterpreter interpreter) throws Exception {
        long time = 0L;
        try {
            time = this.convertToMillis(this.shortformat, str);
        }
        catch (ParseException e) {
            try {
                time = this.convertToMillis(this.longformat, str) + 86400000L;
            }
            catch (ParseException e1) {
                time = this.evaluateExpression(interpreter, str);
            }
        }
        logger.debug((Object)(str + " -> " + time / 1000L + " seconds"));
        return time;
    }

    private long convertToMillis(DateFormat formatter, String duration) throws ParseException {
        return formatter.parse(duration).getTime() - this.zero;
    }

    private long evaluateExpression(WFSInterpreter interpreter, String expression) throws ParseException {
        long time = 0L;
        String duration = interpreter.evaluate(expression).toString();
        try {
            time = this.convertToMillis(this.shortformat, duration);
        }
        catch (ParseException e2) {
            time = this.convertToMillis(this.longformat, duration);
        }
        return time;
    }
}

