/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.thread;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Scheduler<T>
implements ISchedulerService<T> {
    private int size;
    private int max;
    private String name;
    private ScheduledThreadPoolExecutor executor;

    public Scheduler(String name) {
        this.name = name;
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".scheduler");
        this.size = Integer.parseInt(bundle.getString("scheduler.pool.size"));
        this.max = Integer.parseInt(bundle.getString("scheduler.pool.max"));
        this.executor = new ScheduledThreadPoolExecutor(this.size);
        this.executor.setMaximumPoolSize(this.max);
        this.executor.setThreadFactory(new NamedThreadFactory());
    }

    public Scheduler(String name, int size, int max) {
        this.name = name;
        this.size = size;
        this.max = max;
        this.executor = new ScheduledThreadPoolExecutor(this.size);
        this.executor.setMaximumPoolSize(this.max);
        this.executor.setThreadFactory(new NamedThreadFactory());
    }

    @Override
    public Future schedule(Runnable runnable, long delay, long period) {
        return this.executor.scheduleAtFixedRate(runnable, delay, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<T> schedule(Callable<T> callable, long delay) {
        return this.executor.schedule(callable, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<T> schedule(Callable<T> callable) {
        return this.schedule(callable, 0L);
    }

    @Override
    public int count() {
        return this.executor.getQueue().size();
    }

    @Override
    public void purge() {
        this.executor.purge();
    }

    @Override
    public void start() {
        this.executor.prestartCoreThread();
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    private class NamedThreadFactory
    implements ThreadFactory {
        final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        final AtomicInteger threadNumber = new AtomicInteger(1);

        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            thread.setName(Scheduler.this.name + "-" + this.threadNumber.getAndIncrement());
            return thread;
        }
    }
}

