/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.IterateInstr;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class ContinueInstr
extends Instruction {
    private WithParam[] actualParams = null;
    private IterateInstr iterateInstr;
    private UserFunction continueFunction;
    static ValueRepresentation[] emptyArgs = new ValueRepresentation[0];
    public static StructuredQName SAXON_CONTINUE = new StructuredQName("saxon", "http://saxon.sf.net/", "continue");

    public ContinueInstr(IterateInstr iterateInstr) {
        this.iterateInstr = iterateInstr;
        this.continueFunction = new UserFunction();
        this.continueFunction.setFunctionName(SAXON_CONTINUE);
    }

    public void setParameters(WithParam[] actualParams) {
        this.actualParams = actualParams;
    }

    public Iterator iterateSubExpressions() {
        ArrayList list = new ArrayList(10);
        WithParam.getXPathExpressions(this.actualParams, list);
        return list.iterator();
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        XPathContextMajor cm = (XPathContextMajor)context;
        ParameterSet params = ContinueInstr.assembleParams(context, this.actualParams);
        cm.setLocalParameters(params);
        cm.requestTailCall(this.continueFunction, emptyArgs);
        return null;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        WithParam.simplify(this.actualParams, visitor);
        return this;
    }

    public Expression copy() {
        return this;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("saxonContinue");
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.displayExpressions(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

