/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.rof;

import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractReadOnlyFile
implements ReadOnlyFile {
    static final /* synthetic */ boolean $assertionsDisabled;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        int read;
        int total = 0;
        do {
            if ((read = this.read(buf, off + total, len - total)) >= 0) continue;
            throw new EOFException();
        } while ((total += read) < len);
    }

    public int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        long fp = this.getFilePointer();
        long len = this.length();
        long rem = len - fp;
        if ((long)n > rem) {
            n = (int)rem;
        }
        this.seek(fp + (long)n);
        if (!$assertionsDisabled && this.getFilePointer() != fp + (long)n) {
            throw new AssertionError();
        }
        return n;
    }

    static {
        $assertionsDisabled = !AbstractReadOnlyFile.class.desiredAssertionStatus();
    }
}

