/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ZipEntry
implements Cloneable {
    private static final byte NAME = 0;
    private static final byte PLATFORM = 1;
    private static final byte GENERAL = 2;
    private static final byte METHOD = 3;
    private static final byte DOS_TIME = 4;
    private static final byte CRC = 5;
    private static final byte CSIZE = 6;
    private static final byte SIZE = 7;
    public static final byte UNKNOWN = -1;
    public static final short PLATFORM_FAT = 0;
    public static final short PLATFORM_UNIX = 3;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    public static final long MIN_DOS_TIME = 0x210000L;
    private byte init;
    private String name;
    private byte platform = (byte)-1;
    private short general = (short)-1;
    private short method = (short)-1;
    private int dosTime = -1;
    private int crc = -1;
    private int csize = -1;
    private int size = -1;
    private byte[] extra;
    private String comment;
    long offset = -1L;
    private static final ThreadLocal calendar;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipEntry(String name) {
        this.setName0(name);
    }

    public ZipEntry(ZipEntry blueprint) {
        this.init = blueprint.init;
        this.name = blueprint.name;
        this.platform = blueprint.platform;
        this.general = blueprint.general;
        this.method = blueprint.method;
        this.dosTime = blueprint.dosTime;
        this.crc = blueprint.crc;
        this.csize = blueprint.csize;
        this.size = blueprint.size;
        this.extra = blueprint.extra;
        this.comment = blueprint.comment;
        this.offset = blueprint.offset;
        this.setInit((byte)0, false);
    }

    public Object clone() {
        try {
            ZipEntry entry = (ZipEntry)super.clone();
            entry.setInit((byte)0, false);
            return entry;
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    private final boolean isInit(byte index) {
        if (!($assertionsDisabled || 0 <= index && index < 8)) {
            throw new AssertionError((Object)("bit index out of range" + index));
        }
        return (this.init & 1 << index) != 0;
    }

    private final void setInit(byte index, boolean init) {
        if (!($assertionsDisabled || 0 <= index && index < 8)) {
            throw new AssertionError((Object)("bit index out of range" + index));
        }
        this.init = init ? (byte)(this.init | 1 << index) : (byte)(this.init & ~(1 << index));
    }

    public String getName() {
        return this.name;
    }

    final int getNameLength(String charset) throws UnsupportedEncodingException {
        return this.name != null ? this.name.getBytes(charset).length : 0;
    }

    protected void setName(String name) {
        this.setName0(name);
    }

    private void setName0(String name) {
        if (this.isInit((byte)0)) {
            throw new IllegalStateException("name has already been set");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (name.length() > 65535) {
            throw new IllegalArgumentException("name too long");
        }
        this.setInit((byte)0, true);
        this.name = name;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public short getPlatform() {
        return this.isInit((byte)1) ? (short)(this.platform & 0xFF) : (short)-1;
    }

    public void setPlatform(short platform) {
        if (platform < -1 || 255 < platform) {
            throw new IllegalArgumentException(this.name + ": invalid platform: " + platform);
        }
        this.setInit((byte)1, platform != -1);
        this.platform = (byte)platform;
    }

    int getGeneral() {
        return this.isInit((byte)2) ? this.general & 0xFFFF : -1;
    }

    void setGeneral(int general) {
        if (general < -1 || 65535 < general) {
            throw new IllegalArgumentException(this.name + ": invalid general purpose bit flag: " + general);
        }
        this.setInit((byte)2, general != -1);
        this.general = (short)general;
    }

    final boolean getGeneralBit(int index) {
        if (!this.isInit((byte)2)) {
            throw new IllegalStateException(this.name + ": general purpose bit flag not initialized");
        }
        if (index < 0 || 15 < index) {
            throw new IllegalArgumentException(this.name + ": general purpose bit index out of range: " + index);
        }
        return (this.general & 1 << index) != 0;
    }

    final void setGeneralBit(int index, boolean bit) {
        if (index < 0 || 15 < index) {
            throw new IllegalArgumentException(this.name + ": general purpose bit index out of range: " + index);
        }
        this.setInit((byte)2, true);
        this.general = bit ? (short)(this.general | 1 << index) : (short)(this.general & ~(1 << index));
    }

    public int getMethod() {
        return this.isInit((byte)3) ? this.method & 0xFFFF : -1;
    }

    public void setMethod(int method) {
        if (method < -1 || 65535 < method) {
            throw new IllegalArgumentException(this.name + ": invalid compression method: " + method);
        }
        this.setInit((byte)3, method != -1);
        this.method = (short)method;
    }

    protected long getDosTime() {
        return this.isInit((byte)4) ? (long)this.dosTime & 0xFFFFFFFFL : -1L;
    }

    protected void setDosTime(long dosTime) {
        if (dosTime < -1L || 0xFFFFFFFFL < dosTime) {
            throw new IllegalArgumentException(this.name + ": invalid DOS date/time field value: " + dosTime);
        }
        this.setInit((byte)4, dosTime != -1L);
        this.dosTime = (int)dosTime;
    }

    public long getTime() {
        return this.isInit((byte)4) ? ZipEntry.dos2javaTime((long)this.dosTime & 0xFFFFFFFFL) : -1L;
    }

    public void setTime(long time) {
        this.setDosTime(time != -1L ? ZipEntry.java2dosTime(time) : -1L);
    }

    public long getCrc() {
        return this.isInit((byte)5) ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public void setCrc(long crc) {
        if (crc < -1L || 0xFFFFFFFFL < crc) {
            throw new IllegalArgumentException(this.name + ": invalid CRC-32: " + crc);
        }
        this.setInit((byte)5, crc != -1L);
        this.crc = (int)crc;
    }

    public long getCompressedSize() {
        return this.isInit((byte)6) ? (long)this.csize & 0xFFFFFFFFL : -1L;
    }

    public void setCompressedSize(long csize) {
        if (csize < -1L || 0xFFFFFFFFL < csize) {
            throw new IllegalArgumentException(this.name + ": invalid compressed size: " + csize);
        }
        this.setInit((byte)6, csize != -1L);
        this.csize = (int)csize;
    }

    public long getSize() {
        return this.isInit((byte)7) ? (long)this.size & 0xFFFFFFFFL : -1L;
    }

    public void setSize(long size) {
        if (size < -1L || 0xFFFFFFFFL < size) {
            throw new IllegalArgumentException(this.name + ": invalid size: " + size);
        }
        this.setInit((byte)7, size != -1L);
        this.size = (int)size;
    }

    public byte[] getExtra() {
        return this.extra != null ? (byte[])this.extra.clone() : null;
    }

    final int getExtraLength() {
        return this.extra != null ? this.extra.length : 0;
    }

    public void setExtra(byte[] extra) {
        if (extra != null && 65535 < extra.length) {
            throw new IllegalArgumentException(this.name + ": extra field length too long: " + extra.length);
        }
        this.extra = extra != null ? (byte[])extra.clone() : null;
    }

    public String getComment() {
        return this.comment;
    }

    final int getCommentLength(String charset) throws UnsupportedEncodingException {
        return this.comment != null ? this.comment.getBytes(charset).length : 0;
    }

    public void setComment(String comment) {
        if (comment != null && 65535 < comment.length()) {
            throw new IllegalArgumentException(this.name + ": comment length too long: " + comment.length());
        }
        this.comment = comment;
    }

    public String toString() {
        return this.getName();
    }

    protected static long dos2javaTime(long dosTime) {
        if (dosTime < 0L || 0xFFFFFFFFL < dosTime) {
            throw new IllegalArgumentException("invalid DOS date/time field value: " + dosTime);
        }
        int time = (int)dosTime;
        Calendar cal = (Calendar)calendar.get();
        cal.set(1, (time >> 25 & 0xFF) + 1980);
        cal.set(2, (time >> 21 & 0xF) - 1);
        cal.set(5, time >> 16 & 0x1F);
        cal.set(11, time >> 11 & 0x1F);
        cal.set(12, time >> 5 & 0x3F);
        cal.set(13, time << 1 & 0x3E);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    protected static long java2dosTime(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("invalid modification time: " + time);
        }
        Calendar cal = (Calendar)calendar.get();
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        if (year < 1980) {
            return 0x210000L;
        }
        long dosTime = (year - 1980 & 0xFF) << 25 | cal.get(2) + 1 << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
        if (!$assertionsDisabled && dosTime < 0x210000L) {
            throw new AssertionError();
        }
        return dosTime;
    }

    static {
        $assertionsDisabled = !ZipEntry.class.desiredAssertionStatus();
        calendar = new ThreadLocal(){

            protected Object initialValue() {
                return new GregorianCalendar();
            }
        };
    }
}

