/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.contentmgmt.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class GetAllFilesMessageHandler
implements MessageHandler {
    private static final String LIST_OF_FILES = "listOfFiles";
    private static final String TITLE_ID = "titleId";

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)GetAllFilesMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), GetAllFilesMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(GetAllFilesMessageHandler this_, WorkflowMessage message) {
        Util.validateRequired(message, TITLE_ID);
        Long titleId = Util.getLongValue(message, TITLE_ID);
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitlePersistenceService service = (ITitlePersistenceService)registry.lookup(ITitlePersistenceService.class);
        Title title = null;
        try {
            title = service.getWithHistory((Serializable)titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, e);
        }
        if (title == null) {
            String msg = "Did not get a Title from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Asset groupAsset = title.getAsset();
        if (groupAsset == null) {
            String msg = "Did not get a group object for a given title.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        StringBuilder listOfFiles = new StringBuilder();
        boolean first = true;
        for (File file : groupAsset.getAllDescendantFiles()) {
            if (file.getURL() == null) continue;
            if (!first) {
                listOfFiles.append(",");
            } else {
                first = false;
            }
            listOfFiles.append(file.getURL());
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(LIST_OF_FILES, listOfFiles.toString());
        return response;
    }

    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(GetAllFilesMessageHandler this_, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return GetAllFilesMessageHandler.handleMessage_aroundBody0(this_, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = GetAllFilesMessageHandler.handleMessage_aroundBody0(this_, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

