/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.assetlist;

import com.tandbergtv.watchpoint.pmm.assetlist.AssetListPersistenceService;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListSearchService;
import com.tandbergtv.watchpoint.pmm.assetlist.IAssetListTemplateProvider;
import com.tandbergtv.watchpoint.pmm.assetlist.template.AssetListTemplateProvider;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.SchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.schedule.notify.ScheduleNotifierService;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;

public class AssetListActivator {
    public void start() {
        this.addService((Service)new SchedulePersistenceService());
        this.addService((Service)new ScheduleSearchService());
        this.addService((Service)new ScheduleNotifierService());
        AssetListPersistenceService titleListPersistenceService = new AssetListPersistenceService("TitleList Persistence Service");
        this.addService((Service)titleListPersistenceService);
        AssetListSearchService titleListSearchService = new AssetListSearchService("TitleList Search Service");
        this.addService((Service)titleListSearchService);
        this.addService((Service)new AssetListTemplateProvider());
    }

    public void stop() {
        this.removeService(IAssetListTemplateProvider.class);
        this.removeService("TitleList Search Service");
        this.removeService("TitleList Persistence Service");
        this.removeService(IScheduleNotifier.class);
        this.removeService(IScheduleSearchService.class);
        this.removeService(ISchedulePersistenceService.class);
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void removeService(String serviceName) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup(serviceName);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

