/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.callback;

import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.job.callback.AbstractJobCallback;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.callback.MultipleTitleEvaluator;
import com.tandbergtv.watchpoint.pmm.job.callback.NoOpCallback;
import com.tandbergtv.watchpoint.pmm.job.callback.RuleSetInvoker;
import com.tandbergtv.watchpoint.pmm.job.execution.WorkOrderCreator;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DefaultCallback
extends AbstractJobCallback
implements Job {
    private static final Logger logger = Logger.getLogger(DefaultCallback.class);

    public DefaultCallback() {
        this.next = new RuleSetInvoker(new MultipleTitleEvaluator(new WorkOrderCreator(new NoOpCallback())));
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap callbackInfo = context.getJobDetail().getJobDataMap();
        Date date = new Date();
        logger.info((Object)("Received callback to execute job[" + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + "]"));
        try {
            super.preexecute((Map<String, Object>)callbackInfo, new Date());
            this.next.executeJob((Map)callbackInfo, date);
        }
        catch (RuntimeException e) {
            IContainer container = CallbackHelper.getContainer((Map<String, Object>)callbackInfo);
            String errorMsg = "Job execution failed for: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new JobExecutionException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public void executeJob(Map<String, Object> callbackInfo, Date jobExecutionDate) {
        logger.debug((Object)("Executing job that was missed at: " + jobExecutionDate.toString()));
        try {
            super.preexecute(callbackInfo, jobExecutionDate);
            this.next.executeJob(callbackInfo, jobExecutionDate);
        }
        catch (RuntimeException e) {
            IContainer container = CallbackHelper.getContainer(callbackInfo);
            String errorMsg = "Job execution failed for missed job: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }
}

