/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.conf;

import com.tandbergtv.watchpoint.pmm.entities.EntityType;
import com.tandbergtv.watchpoint.pmm.job.conf.ParameterReferenceGroup;
import com.tandbergtv.watchpoint.pmm.job.conf.ParameterReferenceGroupType;
import com.tandbergtv.watchpoint.pmm.job.conf.ParameterReferenceItem;
import com.tandbergtv.watchpoint.pmm.job.ui.IMenuOptionProvider;
import com.tandbergtv.watchpoint.pmm.job.util.ParameterReferenceHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParameterReferenceFileParser {
    private Map<EntityType, List<ParameterReferenceGroup>> rules = new HashMap<EntityType, List<ParameterReferenceGroup>>();
    private Map<EntityType, List<ParameterReferenceGroup>> parameters = new HashMap<EntityType, List<ParameterReferenceGroup>>();
    private static final Logger logger = Logger.getLogger(ParameterReferenceFileParser.class);
    private static String PARAMETER_REFERENCE_FILE = "jobParameterReference.xml";
    private static String ENTITY_ELEMENT = "entity";
    private static String ENTITY_TYPE_ELEMENT = "type";
    private static String RULE_MENU_ELEMENT = "ruleMenu";
    private static String PARAMETER_MENU_ELEMENT = "paramMenu";
    private static String ITEMGROUP_ELEMENT = "itemGroup";
    private static String ITEM_GROUPNAME_ATTR = "name";
    private static String ITEM_GROUP_PROVIDERCLASS = "class";
    private static String ITEMGROUP_TYPE_ATTR = "type";
    private static String ITEMGROUP_CALLBACK_ELEMENT = "callback";
    private static String CALLBACK_CLASS_ATTR = "class";
    private static String ITEMGROUP_ITEM_ELEMENT = "item";
    private static String ITEM_NAME_ATTR = "name";
    private String spec;

    public Map<EntityType, List<ParameterReferenceGroup>> getRules() {
        return this.rules;
    }

    public void setRules(Map<EntityType, List<ParameterReferenceGroup>> rules) {
        this.rules = rules;
    }

    public Map<EntityType, List<ParameterReferenceGroup>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<EntityType, List<ParameterReferenceGroup>> parameters) {
        this.parameters = parameters;
    }

    public ParameterReferenceFileParser(String spec) {
        this.spec = spec;
        this.readConfig();
    }

    private void readConfig() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(this.getClass().getResourceAsStream(PARAMETER_REFERENCE_FILE));
            NodeList entities = doc.getElementsByTagName(ENTITY_ELEMENT);
            for (int i = 0; i < entities.getLength(); ++i) {
                Node currEntity = entities.item(i);
                String type = ((Element)currEntity).getAttribute(ENTITY_TYPE_ELEMENT);
                NodeList children = currEntity.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    List<ParameterReferenceGroup> groups;
                    Node currChild = children.item(j);
                    if (currChild.getNodeName().equals(RULE_MENU_ELEMENT)) {
                        groups = this.getGroupsFromMenu(currChild);
                        logger.debug((Object)("Adding rule group entry for type: " + type));
                        this.rules.put(EntityType.toType((String)type), groups);
                        continue;
                    }
                    if (!currChild.getNodeName().equals(PARAMETER_MENU_ELEMENT)) continue;
                    groups = this.getGroupsFromMenu(currChild);
                    logger.debug((Object)("Adding parameter group entry for type: " + type));
                    this.parameters.put(EntityType.toType((String)type), groups);
                }
            }
            logger.debug((Object)("Final Rules map count: " + this.rules.size()));
            logger.debug((Object)("Final Parameters map count: " + this.parameters.size()));
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)("Error while parsing the file: " + PARAMETER_REFERENCE_FILE + e.toString()));
        }
        catch (SAXException e) {
            logger.error((Object)("SAX exception while parsing the file: " + PARAMETER_REFERENCE_FILE + e.toString()));
        }
        catch (IOException e) {
            logger.error((Object)("SAX exception while parsing the file: " + PARAMETER_REFERENCE_FILE + e.toString()));
            e.printStackTrace();
        }
    }

    private List<ParameterReferenceGroup> getGroupsFromMenu(Node menu) {
        ArrayList<ParameterReferenceGroup> groupList = new ArrayList<ParameterReferenceGroup>();
        try {
            NodeList itemGroups = ((Element)menu).getElementsByTagName(ITEMGROUP_ELEMENT);
            for (int i = 0; i < itemGroups.getLength(); ++i) {
                Node currItemGroup = itemGroups.item(i);
                Element itemGroupElement = (Element)currItemGroup;
                ParameterReferenceGroup group = new ParameterReferenceGroup();
                String groupName = itemGroupElement.getAttribute(ITEM_GROUPNAME_ATTR);
                group.setName(groupName);
                ParameterReferenceGroupType type = ParameterReferenceGroupType.INDEPENDENT;
                if (itemGroupElement.hasAttribute(ITEMGROUP_TYPE_ATTR)) {
                    type = ParameterReferenceGroupType.getType(itemGroupElement.getAttribute(ITEMGROUP_TYPE_ATTR));
                }
                group.setType(type);
                NodeList callbacks = itemGroupElement.getElementsByTagName(ITEMGROUP_CALLBACK_ELEMENT);
                if (callbacks.getLength() > 0) {
                    String callbackClass = ((Element)callbacks.item(0)).getAttribute(CALLBACK_CLASS_ATTR);
                    group.setCallback(callbackClass);
                }
                if (itemGroupElement.hasAttribute(ITEM_GROUP_PROVIDERCLASS)) {
                    String groupProviderClass = itemGroupElement.getAttribute(ITEM_GROUP_PROVIDERCLASS);
                    if (groupProviderClass.trim().length() > 0) {
                        Class<?> groupProvider = Class.forName(groupProviderClass);
                        IMenuOptionProvider provider = (IMenuOptionProvider)groupProvider.newInstance();
                        List<Object> providerItems = new ArrayList();
                        if (menu.getNodeName().equalsIgnoreCase(RULE_MENU_ELEMENT)) {
                            providerItems = provider.getJobRuleMenuOptions(this.spec);
                        } else if (menu.getNodeName().equalsIgnoreCase(PARAMETER_MENU_ELEMENT)) {
                            providerItems = provider.getJobParameterMenuOptions(this.spec);
                        }
                        group.setItems(providerItems);
                        for (int j = 0; j < providerItems.size(); ++j) {
                            ParameterReferenceItem currItem = (ParameterReferenceItem)providerItems.get(j);
                            currItem.setParent(group);
                            if (!currItem.getClass().equals(ParameterReferenceGroup.class)) continue;
                            ((ParameterReferenceGroup)currItem).setType(group.getType());
                        }
                    }
                } else {
                    NodeList items = itemGroupElement.getElementsByTagName(ITEMGROUP_ITEM_ELEMENT);
                    for (int j = 0; j < items.getLength(); ++j) {
                        Element currItem = (Element)items.item(j);
                        ParameterReferenceItem item = new ParameterReferenceItem();
                        String itemName = currItem.getAttribute(ITEM_NAME_ATTR);
                        item.setName(itemName);
                        item.setParent(group);
                        group.addItem(item);
                    }
                }
                groupList.add(group);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("Error while loading class: " + e.toString()));
        }
        catch (InstantiationException e) {
            logger.error((Object)("Error : " + e.toString()));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("Error : " + e.toString()));
        }
        return groupList;
    }

    public String getCallback(EntityType type, String groupName) {
        if (this.rules.containsKey(type)) {
            List<ParameterReferenceGroup> groups = this.rules.get(type);
            for (ParameterReferenceGroup group : groups) {
                if (!group.getName().equalsIgnoreCase(groupName)) continue;
                return group.getCallback();
            }
        }
        return new String();
    }

    public List<ParameterReferenceGroup> getRules(EntityType type) {
        ArrayList<ParameterReferenceGroup> groups = new ArrayList<ParameterReferenceGroup>();
        if (this.rules.containsKey(type)) {
            return this.rules.get(type);
        }
        return groups;
    }

    public List<ParameterReferenceGroup> getParameters(EntityType type) {
        ArrayList<ParameterReferenceGroup> groups = new ArrayList<ParameterReferenceGroup>();
        if (this.parameters.containsKey(type)) {
            return this.parameters.get(type);
        }
        return groups;
    }

    public List<ParameterReferenceGroup> getParameters(EntityType type, boolean associatedWithTitles) {
        ArrayList<ParameterReferenceGroup> paramGroups = new ArrayList<ParameterReferenceGroup>();
        if (this.parameters.containsKey(type)) {
            List<ParameterReferenceGroup> groups = this.parameters.get(type);
            if (associatedWithTitles) {
                return groups;
            }
            for (ParameterReferenceGroup currGroup : groups) {
                if (currGroup.getType() != ParameterReferenceGroupType.INDEPENDENT) continue;
                paramGroups.add(currGroup);
            }
        }
        return paramGroups;
    }

    public String getJobParameterValue(EntityType type, String itemName) {
        List<ParameterReferenceGroup> groups = this.getParameters().get(type);
        for (ParameterReferenceGroup g : groups) {
            String internalName = this.getInternalName(g, itemName);
            if (internalName == null) continue;
            return internalName;
        }
        return null;
    }

    public String getRuleParameterValue(EntityType type, String itemName) {
        List<ParameterReferenceGroup> groups = this.getRules(type);
        for (ParameterReferenceGroup g : groups) {
            String internalName = this.getInternalName(g, itemName);
            if (internalName == null) continue;
            return internalName;
        }
        return null;
    }

    private String getInternalName(ParameterReferenceGroup group, String itemName) {
        String parentGroup = ParameterReferenceHelper.getParentGroup(itemName);
        if (!group.getName().equals(parentGroup)) {
            return null;
        }
        itemName = ParameterReferenceHelper.removeParentGroup(itemName);
        for (ParameterReferenceItem item : group.getItems()) {
            if (item instanceof ParameterReferenceGroup) {
                String internalName = this.getInternalName((ParameterReferenceGroup)item, itemName);
                if (internalName == null) continue;
                return internalName;
            }
            if (!item.getName().equals(itemName)) continue;
            return item.getValue();
        }
        return null;
    }

    public ParameterReferenceItem getJobParameter(EntityType type, String internalName) {
        List<ParameterReferenceGroup> groups = this.getParameters().get(type);
        for (ParameterReferenceGroup g : groups) {
            ParameterReferenceItem displayItem = this.getItem(g, internalName);
            if (displayItem == null) continue;
            return displayItem;
        }
        return null;
    }

    public ParameterReferenceItem getJobRuleParameter(EntityType type, String internalName) {
        List<ParameterReferenceGroup> groups = this.getRules(type);
        for (ParameterReferenceGroup g : groups) {
            ParameterReferenceItem displayItem = this.getItem(g, internalName);
            if (displayItem == null) continue;
            return displayItem;
        }
        return null;
    }

    private ParameterReferenceItem getItem(ParameterReferenceGroup group, String internalName) {
        for (ParameterReferenceItem item : group.getItems()) {
            if (item instanceof ParameterReferenceGroup) {
                ParameterReferenceItem displayItem = this.getItem((ParameterReferenceGroup)item, internalName);
                if (displayItem == null) continue;
                return displayItem;
            }
            if (item.getValue() == null || !item.getValue().equals(internalName)) continue;
            return item;
        }
        return null;
    }
}

