/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import java.io.Serializable;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.springframework.context.ApplicationContext;

public class DefaultTitlePersistenceService
implements ITitlePersistenceService {
    @Transactional
    public void save(Title t) {
        Title title = t;
        DefaultTitlePersistenceService.save_aroundBody1$advice(this, title, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("save", Title.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Title get(Serializable id) {
        Serializable serializable = id;
        return (Title)DefaultTitlePersistenceService.get_aroundBody3$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("get", Serializable.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Title get(Serializable id, String version) {
        Serializable serializable = id;
        String string = version;
        return (Title)DefaultTitlePersistenceService.get_aroundBody5$advice(this, serializable, string, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("get", Serializable.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Title getWithHistory(Serializable id) {
        Serializable serializable = id;
        return (Title)DefaultTitlePersistenceService.getWithHistory_aroundBody7$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("getWithHistory", Serializable.class).getAnnotation(Transactional.class), null);
    }

    private Title loadTitle(Serializable id) {
        return (Title)this.getCurrentSession().load(Title.class, id);
    }

    @Transactional
    public Title getTitleForUpdate(Serializable id) {
        Serializable serializable = id;
        return (Title)DefaultTitlePersistenceService.getTitleForUpdate_aroundBody9$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("getTitleForUpdate", Serializable.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public synchronized boolean delete(Serializable id) {
        Serializable serializable = id;
        return Conversions.booleanValue((Object)DefaultTitlePersistenceService.delete_aroundBody11$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("delete", Serializable.class).getAnnotation(Transactional.class), null));
    }

    public String getServiceName() {
        return "Title Persistence";
    }

    public void start() {
    }

    public void stop() {
    }

    private Session getCurrentSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private ITTVDataModelHandler getTTVDataModelHandler() {
        return (ITTVDataModelHandler)this.getMetadataManagerBean("TTVSpecHandler");
    }

    private Object getMetadataManagerBean(String beanId) {
        ApplicationContext springContext = ApplicationContextHelper.getInstance().getContext();
        return springContext.getBean(beanId);
    }

    private static final /* synthetic */ void save_aroundBody0(DefaultTitlePersistenceService this_, Title t) {
        try {
            boolean draft = TitleStatus.DRAFT.equals((Object)t.getStatus());
            Asset asset = this_.getTTVDataModelHandler().saveAsset(t.getAsset(), draft);
            t.setAsset(asset);
            t.getAssetStatusMap().put(asset.getVersion(), t.getStatus());
        }
        catch (MetadataException e) {
            String msg = "Failed to save title, error: " + e.getMessage();
            String errorCode = "TPS-001";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)e);
            error.getParameters().add(e.getLocalizedMessage());
            throw error;
        }
        this_.getCurrentSession().saveOrUpdate((Object)t);
    }

    private static final /* synthetic */ Object save_aroundBody1$advice(DefaultTitlePersistenceService this_, Title t, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            DefaultTitlePersistenceService.save_aroundBody0(this_, t);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            DefaultTitlePersistenceService.save_aroundBody0(this_, t);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Title get_aroundBody2(DefaultTitlePersistenceService this_, Serializable id) {
        Title title = this_.loadTitle(id);
        TTVId ttvId = title.getAsset().getTTVId();
        try {
            Asset latestVersionAsset = this_.getTTVDataModelHandler().getAsset(ttvId);
            title.setAsset(latestVersionAsset);
        }
        catch (SearchException se) {
            String msg = "Failed to get title[" + id + "], error: " + se.getMessage();
            String errorCode = "TPS-003";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(String.valueOf(id));
            error.getParameters().add(ttvId != null ? String.valueOf(ttvId.getId()) : "null");
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return title;
    }

    private static final /* synthetic */ Object get_aroundBody3$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.get_aroundBody2(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Title object = DefaultTitlePersistenceService.get_aroundBody2(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Title get_aroundBody4(DefaultTitlePersistenceService this_, Serializable id, String version) {
        Title title = this_.loadTitle(id);
        TTVId ttvId = title.getAsset().getTTVId();
        try {
            Asset olderVersionAsset = this_.getTTVDataModelHandler().getAsset(ttvId, version);
            title.setAsset(olderVersionAsset);
        }
        catch (SearchException se) {
            String msg = "Failed to get title[" + id + ", version: " + version + "], error: " + se.getMessage();
            String errorCode = "TPS-002";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return title;
    }

    private static final /* synthetic */ Object get_aroundBody5$advice(DefaultTitlePersistenceService this_, Serializable id, String version, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.get_aroundBody4(this_, id, version);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Title object = DefaultTitlePersistenceService.get_aroundBody4(this_, id, version);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Title getWithHistory_aroundBody6(DefaultTitlePersistenceService this_, Serializable id) {
        Title title = this_.loadTitle(id);
        TTVId ttvId = title.getAsset().getTTVId();
        try {
            Asset completeAsset = this_.getTTVDataModelHandler().getAssetWithDeletedRelationships(ttvId);
            title.setAsset(completeAsset);
        }
        catch (SearchException se) {
            String msg = "Failed to get title[" + id + "] with history, error: " + se.getMessage();
            String errorCode = "TPS-003";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(String.valueOf(id));
            error.getParameters().add(ttvId != null ? String.valueOf(ttvId.getId()) : "null");
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return title;
    }

    private static final /* synthetic */ Object getWithHistory_aroundBody7$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.getWithHistory_aroundBody6(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Title object = DefaultTitlePersistenceService.getWithHistory_aroundBody6(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Title getTitleForUpdate_aroundBody8(DefaultTitlePersistenceService this_, Serializable id) {
        Title t = (Title)this_.getCurrentSession().load(Title.class, id, LockMode.UPGRADE);
        this_.getCurrentSession().refresh((Object)t);
        TTVId ttvId = t.getAsset().getTTVId();
        try {
            Asset latestVersionAsset = this_.getTTVDataModelHandler().getAsset(ttvId);
            t.setAsset(latestVersionAsset);
        }
        catch (SearchException se) {
            String msg = "Failed to get title[" + id + "], error: " + se.getMessage();
            String errorCode = "TPS-003";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(String.valueOf(id));
            error.getParameters().add(ttvId != null ? String.valueOf(ttvId.getId()) : "null");
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return t;
    }

    private static final /* synthetic */ Object getTitleForUpdate_aroundBody9$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.getTitleForUpdate_aroundBody8(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Title object = DefaultTitlePersistenceService.getTitleForUpdate_aroundBody8(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ boolean delete_aroundBody10(DefaultTitlePersistenceService this_, Serializable id) {
        Session session = this_.getCurrentSession();
        Title title = (Title)session.get(Title.class, id);
        if (title == null) {
            return false;
        }
        try {
            this_.getTTVDataModelHandler().delete(title.getAsset());
        }
        catch (SearchException e) {
            String msg = "Failed to delete title[" + id + "], error: " + e.getMessage();
            String errorCode = "TPS-002";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)e);
            error.getParameters().add(e.getLocalizedMessage());
            throw error;
        }
        title.setIsActive(Boolean.valueOf(false));
        Collection lists = title.getTitlelists();
        for (IAssetList list : lists) {
            AssetList clone = (AssetList)session.load(AssetList.class, (Serializable)list.getId());
            clone.removeTitle(title);
            session.saveOrUpdate((Object)clone);
        }
        for (ProgressItem item : title.getProgressItems()) {
            item.setIsActive(Boolean.valueOf(false));
        }
        session.saveOrUpdate((Object)title);
        return true;
    }

    private static final /* synthetic */ Object delete_aroundBody11$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)DefaultTitlePersistenceService.delete_aroundBody10(this_, id));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)DefaultTitlePersistenceService.delete_aroundBody10(this_, id));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

