/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.provider.internal;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleSearchStrategy;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class DefaultTitleSearchStrategy
implements ITitleSearchStrategy {
    private static final Logger logger = Logger.getLogger(DefaultTitleSearchStrategy.class);
    private ITitleProvider provider;

    @Override
    public ITitleProvider getTitleProvider() {
        return this.provider;
    }

    @Override
    public void setTitleProvider(ITitleProvider provider) {
        this.provider = provider;
    }

    @Override
    public int count(SearchCriteria criteria) {
        int count = 0;
        Session session = this.getSession();
        Query query = session.createQuery(this.getCountQuery(criteria));
        count = Integer.parseInt(query.uniqueResult().toString());
        return count;
    }

    @Override
    public Collection<Title> search(SearchCriteria criteria) {
        ArrayList<Title> titles = new ArrayList();
        int index = criteria.getStartingRecordNumber();
        int count = criteria.getRecordsCount();
        String s = this.getQuery(criteria);
        logger.debug((Object)("Executing query :" + System.getProperty("line.separator") + s));
        Session session = this.getSession();
        Query query = session.createQuery(s);
        query.setFirstResult(index);
        query.setMaxResults(count == 0 ? Integer.MAX_VALUE : count);
        List result = query.list();
        titles = this.getTitles(result);
        return titles;
    }

    private Collection<Title> getTitles(List<?> result) {
        ArrayList<Title> titles = new ArrayList<Title>();
        for (int i = 0; i < result.size(); ++i) {
            Object[] objs;
            if (result.get(i) instanceof Title) {
                Title title = (Title)Title.class.cast(result.get(i));
                titles.add(title);
                continue;
            }
            for (Object o : objs = (Object[])result.get(i)) {
                if (!(o instanceof Title)) continue;
                Title title = (Title)Title.class.cast(o);
                titles.add(title);
            }
        }
        return titles;
    }

    public String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public String getCountQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildCountQuery(criteria);
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

