/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util.validation;

import com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.List;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 4530695438426588152L;
    private List<ValidationMessage> validationMessages;

    public ValidationException(List<ValidationMessage> messages) {
        this.setValidationMessages(messages);
    }

    public ValidationException(String message, Throwable cause, List<ValidationMessage> messages) {
        super(message, cause);
        this.setValidationMessages(messages);
    }

    public ValidationException(String message, List<ValidationMessage> messages) {
        super(message);
        this.setValidationMessages(messages);
    }

    public ValidationException(Throwable cause, List<ValidationMessage> messages) {
        super(cause);
        this.setValidationMessages(messages);
    }

    public List<ValidationMessage> getValidationMessages() {
        return this.validationMessages;
    }

    protected void setValidationMessages(List<ValidationMessage> messages) {
        if (messages == null) {
            messages = new ArrayList<ValidationMessage>();
        }
        this.validationMessages = messages;
    }

    @Override
    public String getMessage() {
        StringBuilder msg = new StringBuilder();
        if (super.getMessage() != null) {
            msg.append(super.getMessage());
            msg.append(" ");
        }
        msg.append("There are " + this.validationMessages.size() + " validation errors present.");
        msg.append(System.getProperty("line.separator"));
        for (ValidationMessage validationMessage : this.validationMessages) {
            msg.append(validationMessage.getCode());
            msg.append(": ");
            msg.append(validationMessage.getProperties());
            msg.append(System.getProperty("line.separator"));
        }
        return msg.toString();
    }
}

