/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.plugins.ta;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.conf.IAutoFillVariableProvider;
import java.net.InetAddress;
import java.text.DecimalFormat;

public class AssetIdGenerator
implements IAutoFillVariableProvider {
    private static final String IP_LOCALHOST = "127.0.0.1";

    public String getValue(Title title, Asset asset) {
        return this.getPrefix(asset) + this.getNewId();
    }

    private String getPrefix(Asset asset) {
        String assetType = asset.getAssetType();
        if (assetType == null || assetType.length() < 2) {
            return "CMXX";
        }
        return "CM" + assetType.substring(0, 2);
    }

    private String getNewId() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long t = System.currentTimeMillis();
        String hostId = this.getHostId();
        if (hostId == null) {
            hostId = IP_LOCALHOST;
        }
        String subnet = null;
        try {
            subnet = hostId.substring(hostId.lastIndexOf(46) + 1);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (subnet == null) {
            subnet = "1";
        }
        String IDString = subnet + t;
        t = Long.parseLong(IDString);
        DecimalFormat df = new DecimalFormat();
        df.setMinimumIntegerDigits(16);
        String pattern = "0000000000000000";
        df.applyPattern(pattern);
        return df.format(t);
    }

    private String getHostId() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostAddress();
        }
        catch (Exception ex) {
            return IP_LOCALHOST;
        }
    }
}

