/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.FieldSearchKey;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.builder.JoinOperator;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.search.builder.QueryOperators;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.metadatamanager.util.DateParseException;
import com.tandbergtv.metadatamanager.util.DateUtil;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MetadataValueFieldInfo
extends FieldInfo {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    LogicalOperator operator;
    String value;

    public MetadataValueFieldInfo(String ttvxpath, LogicalOperator operator, String value) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.value = value;
        this.isConjunction = true;
    }

    public MetadataValueFieldInfo(String ttvxpath, LogicalOperator operator, String value, boolean isConjunction) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.value = value;
        this.isConjunction = isConjunction;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public LogicalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(LogicalOperator operator) {
        this.operator = operator;
    }

    private RangeParameter handleEqualsOnDate(String valueColumnName) {
        String buffer = this.convertDate();
        RangeParameter range = new RangeParameter(valueColumnName, SearchType.DATE, buffer);
        range.setTo(buffer);
        return range;
    }

    private String convertDate() {
        if (this.value == null) {
            return null;
        }
        if (this.value.equals("")) {
            return "";
        }
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            if (this.operator.equals((Object)LogicalOperator.LESSTHANTODAY) || this.operator.equals((Object)LogicalOperator.GREATERTHANTODAY) || this.operator.equals((Object)LogicalOperator.NOTGREATERTHANTODAY) || this.operator.equals((Object)LogicalOperator.NOTLESSTHANTODAY)) {
                if (this.operator.equals((Object)LogicalOperator.NOTGREATERTHANTODAY)) {
                    this.operator = LogicalOperator.LESSTHANEQUAL;
                } else if (this.operator.equals((Object)LogicalOperator.NOTLESSTHANTODAY)) {
                    this.operator = LogicalOperator.GREATERTHANEQUAL;
                }
                calendar.setTime(new Date());
                ((Calendar)calendar).add(5, Integer.parseInt(this.value));
            } else {
                calendar.setTime(DateUtil.convertDate(this.value));
            }
        }
        catch (DateParseException e) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(this.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(this.twoDigit(calendar.get(5)));
        return buffer.toString();
    }

    private String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    @Override
    public String getCondition(String alias) {
        String valueColumnName;
        SearchType searchType;
        StringBuilder fieldConditions = new StringBuilder();
        if (!this.ttvxpath.isEmpty()) {
            boolean isComplexField = this.isFieldComplex(this.ttvxpath);
            String op = isComplexField ? QueryOperators.LIKE.toString() : QueryOperators.EQUAL.toString();
            String xpath = isComplexField ? this.getTtvxpath() + QueryConstants.TTV_XPATH_SEPARATOR + QueryConstants.WILDCARD : this.getTtvxpath();
            fieldConditions.append(alias + QueryConstants.PERIOD + (Object)((Object)FieldSearchKey.TTV_XPATH) + QueryConstants.SPACE + op + QueryConstants.SPACE + QueryConstants.QUOTE + xpath + QueryConstants.QUOTE);
            if (this.operator.equals((Object)LogicalOperator.ISNOTEMPTY) || this.operator.equals((Object)LogicalOperator.ISEMPTY)) {
                return fieldConditions.toString();
            }
            fieldConditions.append(QueryConstants.SPACE);
            fieldConditions.append((Object)JoinOperator.AND);
            fieldConditions.append(QueryConstants.SPACE);
        }
        if ((searchType = this.getSearchTypeBasedOnColumn(valueColumnName = this.getValueColumnName())) == SearchType.DATE && (this.operator.equals((Object)LogicalOperator.EQUAL) || this.operator.equals((Object)LogicalOperator.NOTEQUAL))) {
            String betweenOp = QueryConstants.BETWEEN;
            if (this.operator.equals((Object)LogicalOperator.NOTEQUAL)) {
                betweenOp = QueryConstants.NOT_BETWEEN;
                fieldConditions.append(QueryConstants.SPACE);
                fieldConditions.append(alias);
                fieldConditions.append(QueryConstants.PERIOD);
                fieldConditions.append(valueColumnName);
                fieldConditions.append(QueryConstants.NOTNULL);
                fieldConditions.append((Object)JoinOperator.AND);
                fieldConditions.append(QueryConstants.SPACE);
            }
            RangeParameter range = this.handleEqualsOnDate(valueColumnName);
            fieldConditions.append(alias + QueryConstants.PERIOD + valueColumnName + betweenOp + QueryConstants.TO_DATE + QueryConstants.START_PARENTHESIS + QueryConstants.QUOTE + range.getFrom() + QueryConstants.QUOTE + QueryConstants.COMMA + QueryConstants.DATE_FORMAT + QueryConstants.END_PARENTHESIS + QueryConstants.SPACE + (Object)((Object)JoinOperator.AND) + QueryConstants.SPACE + QueryConstants.TO_DATE + QueryConstants.START_PARENTHESIS + QueryConstants.QUOTE + this.getModifiedToDate(range.getTo()) + QueryConstants.QUOTE + QueryConstants.COMMA + QueryConstants.DATE_TIME_FORMAT + QueryConstants.END_PARENTHESIS);
        } else {
            if (searchType == SearchType.DATE) {
                this.value = this.convertDate();
            }
            if (this.operator.equals((Object)LogicalOperator.CONTAINSUNPARSABLE) || this.operator.equals((Object)LogicalOperator.DOESNOTCONTAINUNPARSABLE)) {
                fieldConditions.append(alias + QueryConstants.PERIOD + (Object)((Object)FieldSearchKey.PARSABLE) + QueryConstants.SPACE + (Object)((Object)QueryOperators.EQUAL) + QueryConstants.SPACE + "0");
            } else if (this.operator.equals((Object)LogicalOperator.DOESNOTSTARTWITH) || this.operator.equals((Object)LogicalOperator.STARTSWITH) || this.operator.equals((Object)LogicalOperator.DOESNOTENDWITH) || this.operator.equals((Object)LogicalOperator.ENDSWITH)) {
                if (searchType == SearchType.STRING) {
                    this.value = this.operator.equals((Object)LogicalOperator.DOESNOTSTARTWITH) || this.operator.equals((Object)LogicalOperator.STARTSWITH) ? QueryConstants.QUOTE + this.value + QueryConstants.WILDCARD + QueryConstants.QUOTE : QueryConstants.QUOTE + QueryConstants.WILDCARD + this.value + QueryConstants.QUOTE;
                    if (this.isIgnoreCase()) {
                        this.value = QueryConstants.TO_LOWER + QueryConstants.START_PARENTHESIS + this.value + QueryConstants.END_PARENTHESIS;
                        fieldConditions.append(QueryConstants.TO_LOWER + QueryConstants.START_PARENTHESIS);
                    }
                    fieldConditions.append(alias + QueryConstants.PERIOD + valueColumnName);
                    if (this.isIgnoreCase()) {
                        fieldConditions.append(QueryConstants.END_PARENTHESIS);
                    }
                    fieldConditions.append(QueryConstants.SPACE + (Object)((Object)QueryOperators.LIKE) + QueryConstants.SPACE + this.value);
                }
            } else {
                String value;
                String string = value = this.operator.equals((Object)LogicalOperator.CONTAINS) || this.operator.equals((Object)LogicalOperator.DOESNOTCONTAIN) ? QueryConstants.WILDCARD + this.getValue() + QueryConstants.WILDCARD : this.getValue();
                if (searchType == SearchType.STRING) {
                    value = QueryConstants.QUOTE + value + QueryConstants.QUOTE;
                    if (this.isIgnoreCase()) {
                        value = QueryConstants.TO_LOWER + QueryConstants.START_PARENTHESIS + value + QueryConstants.END_PARENTHESIS;
                    }
                } else if (searchType == SearchType.DATE) {
                    String dateFormat = QueryConstants.DATE_FORMAT;
                    if (this.operator.equals((Object)LogicalOperator.LESSTHANEQUAL) || this.operator.equals((Object)LogicalOperator.GREATERTHAN) || this.operator.equals((Object)LogicalOperator.GREATERTHANTODAY)) {
                        value = this.getModifiedToDate(value);
                        dateFormat = QueryConstants.DATE_TIME_FORMAT;
                    }
                    value = QueryConstants.TO_DATE + QueryConstants.START_PARENTHESIS + QueryConstants.QUOTE + value + QueryConstants.QUOTE + QueryConstants.COMMA + dateFormat + QueryConstants.END_PARENTHESIS;
                }
                if (searchType == SearchType.STRING && this.isIgnoreCase()) {
                    fieldConditions.append(QueryConstants.TO_LOWER + QueryConstants.START_PARENTHESIS);
                }
                fieldConditions.append(alias + QueryConstants.PERIOD + valueColumnName);
                if (searchType == SearchType.STRING && this.isIgnoreCase()) {
                    fieldConditions.append(QueryConstants.END_PARENTHESIS);
                }
                fieldConditions.append(QueryConstants.SPACE + QueryOperators.lookUp(this.operator.name()) + QueryConstants.SPACE + value);
            }
        }
        return fieldConditions.toString();
    }

    private boolean isFieldComplex(String ttvxpath) {
        String dataType = DataTypeMappingReader.getInstance().determineDataType(ttvxpath);
        return dataType == null;
    }

    @Override
    public String getSelectProperties() {
        return "";
    }

    private String getModifiedToDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        SimpleDateFormat formatBetter = new SimpleDateFormat(DATE_TIME_FORMAT);
        GregorianCalendar c = new GregorianCalendar();
        try {
            c.setTimeInMillis(format.parse(date).getTime());
            c.add(5, 1);
            c.add(13, -1);
            return formatBetter.format(c.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not evaluate the 'to' date" + date, e);
        }
    }
}

