/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.PropertyValueField;
import com.tandbergtv.metadatamanager.search.SearchField;
import com.tandbergtv.metadatamanager.search.SearchFieldList;
import com.tandbergtv.metadatamanager.search.SearchInfo;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.SpecHandlerBase;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AssetValidator {
    private SpecHandlerBase parentHandler;

    public AssetValidator(SpecHandlerBase specificationHandler) {
        this.parentHandler = specificationHandler;
    }

    public void validate(Asset rootAsset) throws MetadataException {
        Collection<ISpecHandler> handlers = this.getSpecificationHandlersForValidation();
        for (ISpecHandler handler : handlers) {
            this.validateAssetTree(rootAsset, handler, false);
        }
    }

    public void validateWithCurrentSpecification(Asset rootAsset) throws MetadataException {
        this.validateAssetTree(rootAsset, this.parentHandler, false);
    }

    public void validateForPersistence(Asset rootAsset) throws MetadataException {
        Collection<ISpecHandler> handlers = this.getSpecificationHandlersForValidation();
        for (ISpecHandler handler : handlers) {
            this.validateAssetTree(rootAsset, handler, true);
        }
    }

    private void validateAssetTree(Asset rootAsset, ISpecHandler handler, boolean usePersistenceStore) throws MetadataException {
        List<Asset> assets = this.getAssetsInTree(rootAsset);
        ArrayList<SearchCriteria> assetKeys = new ArrayList<SearchCriteria>();
        for (Asset currentAsset : assets) {
            if (!usePersistenceStore) {
                this.validateAssetInTree(currentAsset, handler, assetKeys);
                continue;
            }
            this.validateAssetForPersistence(currentAsset, handler);
        }
    }

    private List<Asset> getAssetsInTree(Asset asset) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        this.getAssetsInTree(asset, assets);
        return assets;
    }

    private void getAssetsInTree(Asset asset, List<Asset> assets) {
        assets.add(asset);
        int currentIndex = 0;
        while (currentIndex < assets.size()) {
            Asset currentAsset;
            if ((currentAsset = assets.get(currentIndex++)).getRelations() == null) continue;
            for (Relation relation : asset.getRelations()) {
                Asset target = relation.getTargetAsset();
                if (assets.contains(target)) continue;
                assets.add(target);
            }
        }
    }

    private void validateAssetInTree(Asset asset, ISpecHandler hander, Collection<SearchCriteria> assetKeys) throws MetadataException {
        SearchCriteria assetKey = this.getAssetSpecificationKey(asset, hander);
        if (assetKey == null || assetKey.isEmptyCriteria()) {
            return;
        }
        if (this.hasAssetKey(assetKeys, assetKey)) {
            String specificationName = hander.getSpecName();
            String msg = "Found multiple assets in asset tree with key " + assetKey.toString() + " for specification " + specificationName + ".";
            throw new MetadataException(msg);
        }
        assetKeys.add(assetKey);
    }

    private void validateAssetForPersistence(Asset asset, ISpecHandler handler) throws MetadataException {
        TTVId assetID = asset.getTTVId();
        List<SearchField> searchFields = handler.getSearchFieldsToValidatePersistedCopies(asset);
        if (searchFields.isEmpty() || searchFields == null) {
            return;
        }
        if (assetID.isValidIdentifier()) {
            String idCol = DBNameFinder.getInstance().getColumnName(Asset.class, AssetSearchKey.ASSET_ID.toString());
            ArrayList<String> values = new ArrayList<String>();
            values.add(String.valueOf(asset.getId()));
            PropertyValueField idField = new PropertyValueField(idCol, values, LogicalOperator.NOTIN, Asset.class);
            idField.setConjunction(true);
            searchFields.add(idField);
            SearchFieldList fieldList = new SearchFieldList();
            fieldList.setConjunction(true);
            fieldList.setAreChildrenConjunction(false);
            String orgCol = DBNameFinder.getInstance().getColumnName(Asset.class, AssetSearchKey.ORIGINAL_ASSET_ID.toString());
            PropertyValueField subField1 = new PropertyValueField(orgCol, values, LogicalOperator.NOTIN, Asset.class);
            subField1.setConjunction(false);
            fieldList.getSubFields().add(subField1);
            PropertyValueField subField2 = new PropertyValueField(orgCol, new ArrayList<String>(), LogicalOperator.ISNULL, Asset.class);
            fieldList.getSubFields().add(subField2);
            subField2.setConjunction(false);
            searchFields.add(fieldList);
        }
        AssetSearchService service = this.parentHandler.searchService;
        SearchInfo info = new SearchInfo();
        info.setFields(searchFields);
        String query = service.getQuery("", "", info, null);
        Collection<Long> assetIDs = service.searchForAssetId(query);
        int matchingAssetCount = assetIDs != null ? assetIDs.size() : 0;
        Long originalAssetID = asset.getOriginalAssetID();
        if (matchingAssetCount > 0 && !assetIDs.contains(originalAssetID)) {
            String specificationName = handler.getSpecName();
            String assetName = "Asset[";
            assetName = assetName + (assetID.isValidIdentifier() ? Long.valueOf(asset.getId()) : asset.getAssetType());
            assetName = assetName + "]";
            SearchCriteria assetKey = this.getAssetSpecificationKey(asset, handler);
            String msg = assetName + " has key " + assetKey.toString() + " in specification " + specificationName + " which is not unique in the system.";
            throw new MetadataException(msg);
        }
    }

    private SearchCriteria getAssetSpecificationKey(Asset asset, ISpecHandler handler) {
        IIdentifier identifier = handler.extractId(asset);
        if (!identifier.isValidIdentifier()) {
            return null;
        }
        Map<String, String> idPaths = identifier.getTTVPaths();
        Map<String, String> identifiers = identifier.getSpecIdentifiers();
        SearchCriteria criteria = new SearchCriteria();
        for (String specificationIDXPath : idPaths.keySet()) {
            String ttvIDXPath = idPaths.get(specificationIDXPath);
            String value = identifiers.get(specificationIDXPath);
            if (AssetSearchKey.ASSET_ID.toString().equals(ttvIDXPath)) {
                return null;
            }
            if (value != null && value.equals("")) {
                value = null;
            }
            criteria.put(ttvIDXPath, value);
        }
        return criteria;
    }

    private boolean hasAssetKey(Collection<SearchCriteria> assetKeys, SearchCriteria assetKey) {
        for (SearchCriteria currentAssetKey : assetKeys) {
            if (!assetKey.hasSameCriteria(currentAssetKey)) continue;
            return true;
        }
        return false;
    }

    private Collection<ISpecHandler> getSpecificationHandlersForValidation() {
        LinkedHashSet<ISpecHandler> handlers = new LinkedHashSet<ISpecHandler>();
        Map<String, ISpecHandler> specHandlerMap = SpecHandlerFactory.getHandlers();
        HashSet<Set<String>> allTTVIdentifiers = new HashSet<Set<String>>();
        for (ISpecHandler handler : specHandlerMap.values()) {
            Set<String> ttvIdentifier = this.getTTVIdentifiers(handler);
            if (ttvIdentifier == null || ttvIdentifier.size() == 0 || allTTVIdentifiers.contains(ttvIdentifier)) continue;
            allTTVIdentifiers.add(ttvIdentifier);
            handlers.add(handler);
        }
        return handlers;
    }

    private Set<String> getTTVIdentifiers(ISpecHandler handler) {
        HashSet<String> ttvXPaths = new HashSet<String>();
        Map<String, String> identifiers = handler.getIdentifier().getTTVPaths();
        boolean hasPersistenceKey = false;
        for (String ttvPath : identifiers.values()) {
            if (AssetSearchKey.ASSET_ID.toString().equals(ttvPath)) {
                hasPersistenceKey = true;
                break;
            }
            ttvXPaths.add(ttvPath);
        }
        if (hasPersistenceKey) {
            return null;
        }
        return ttvXPaths;
    }
}

