/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt;

import com.jinfonet.awt.JGraphics;
import com.jinfonet.awt.Rasterable;
import com.jinfonet.awt.Rect2D;
import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExPolygon
implements Cloneable {
    public static final int UPWARDS = 1;
    public static final int HORIZONTAL = 0;
    public static final int DOWNWARDS = -1;
    public static final int CLOCKWISE = 1;
    public static final int ANTICLOCKWISE = -1;
    public int npoints = 0;
    public double[] xpoints = new double[4];
    public double[] ypoints = new double[4];
    protected Rect2D bounds = null;
    protected Vector children;
    protected int roundDir = 0;
    public static boolean VERIFY = false;
    static int D = 0;
    public static Graphics g;
    private static final Color[] QOIV;

    public ExPolygon dup() {
        ExPolygon exPolygon = new ExPolygon();
        int n = this.npoints;
        exPolygon.xpoints = new double[n];
        exPolygon.ypoints = new double[n];
        System.arraycopy(this.xpoints, 0, exPolygon.xpoints, 0, n);
        System.arraycopy(this.ypoints, 0, exPolygon.ypoints, 0, n);
        exPolygon.npoints = n;
        exPolygon.roundDir = this.roundDir;
        if (this.bounds != null) {
            exPolygon.bounds = this.bounds.dup();
        }
        if (this.children != null) {
            int n2 = this.children.size();
            Vector<ExPolygon> vector = new Vector<ExPolygon>(n2);
            int n3 = 0;
            while (n3 < n2) {
                vector.addElement(((ExPolygon)this.children.elementAt(n3)).dup());
                ++n3;
            }
            exPolygon.children = vector;
        }
        return exPolygon;
    }

    public void add(ExPolygon exPolygon) {
        if (exPolygon.npoints < 3) {
            return;
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        exPolygon.closePath();
        if (VERIFY) {
            exPolygon.verify();
        }
        int n = this.children.size() - 1;
        while (n >= 0) {
            int n2;
            ExPolygon exPolygon2 = this.doubleValue(n);
            if (VERIFY) {
                exPolygon.verifyInterserction(exPolygon2);
            }
            if ((n2 = exPolygon.compareTo(exPolygon2)) > 0) {
                this.children.removeElementAt(n);
                exPolygon.add(exPolygon2);
            } else if (n2 < 0) {
                exPolygon2.add(exPolygon);
                return;
            }
            --n;
        }
        this.children.addElement(exPolygon);
    }

    public void addPoint(double d, double d2) {
        if (this.npoints >= 1 && d == this.xpoints[this.npoints - 1] && d2 == this.ypoints[this.npoints - 1]) {
            return;
        }
        if (this.npoints >= 2) {
            if (this.xpoints[this.npoints - 2] == this.xpoints[this.npoints - 1] && d == this.xpoints[this.npoints - 1]) {
                this.xpoints[this.npoints - 1] = d;
                this.ypoints[this.npoints - 1] = d2;
                return;
            }
            if (this.ypoints[this.npoints - 2] == this.ypoints[this.npoints - 1] && d2 == this.ypoints[this.npoints - 1]) {
                if (ExPolygon.copyInto(this.ypoints[this.npoints - 2], this.ypoints[this.npoints - 1]) == ExPolygon.copyInto(this.ypoints[this.npoints - 1], d2)) {
                    this.xpoints[this.npoints - 1] = d;
                    this.ypoints[this.npoints - 1] = d2;
                    return;
                }
                throw new RuntimeException("Overlap segs");
            }
        }
        if (this.npoints == this.xpoints.length) {
            double[] dArray = new double[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, dArray, 0, this.npoints);
            this.xpoints = dArray;
            dArray = new double[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, dArray, 0, this.npoints);
            this.ypoints = dArray;
        }
        this.xpoints[this.npoints] = d;
        this.ypoints[this.npoints] = d2;
        ++this.npoints;
        if (this.bounds != null) {
            this.abs(d, d2);
        }
    }

    public Rect2D getBounds() {
        if (this.bounds == null) {
            if (this.npoints == 0) {
                return null;
            }
            this.VERIFY(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds;
    }

    public void closePath() {
        if (this.npoints > 1 && (this.xpoints[this.npoints - 1] != this.xpoints[0] || this.ypoints[this.npoints - 1] != this.ypoints[0])) {
            this.addPoint(this.xpoints[0], this.ypoints[0]);
        }
    }

    private boolean D() {
        return this.xpoints[this.npoints - 1] == this.xpoints[0] && this.ypoints[this.npoints - 1] == this.ypoints[0];
    }

    private void QOIV() {
        double[] dArray = this.xpoints;
        double[] dArray2 = this.ypoints;
        int n = this.npoints - 3;
        while (n >= 0) {
            if (dArray[n] == dArray[n + 1] && dArray[n + 1] == dArray[n + 2] && ExPolygon.copyInto(dArray[n], dArray[n + 1]) == ExPolygon.copyInto(dArray[n + 1], dArray[n + 2]) || dArray2[n] == dArray2[n + 1] && dArray2[n + 1] == dArray2[n + 2] && ExPolygon.copyInto(dArray2[n], dArray2[n + 1]) == ExPolygon.copyInto(dArray2[n + 1], dArray2[n + 2])) {
                System.arraycopy(this.xpoints, n + 2, this.xpoints, n + 1, this.npoints - n - 2);
                System.arraycopy(this.ypoints, n + 2, this.ypoints, n + 1, this.npoints - n - 2);
                --this.npoints;
            }
            --n;
        }
    }

    public int getRoundDir() {
        if (this.roundDir != 0 || this.npoints <= 2) {
            return this.roundDir;
        }
        double[][] dArray = this.addPoint(this.getBounds().y, 8, -1);
        this.roundDir = (int)Math.round(dArray[0][7]);
        return this.roundDir;
    }

    private void VERIFY(double[] dArray, double[] dArray2, double d) {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        int n = 0;
        while ((double)n < d) {
            double d6 = dArray[n];
            d2 = Math.min(d2, d6);
            d4 = Math.max(d4, d6);
            double d7 = dArray2[n];
            d3 = Math.min(d3, d7);
            d5 = Math.max(d5, d7);
            ++n;
        }
        this.bounds = new Rect2D(d2, d3, d4 - d2, d5 - d3);
    }

    private void abs(double d, double d2) {
        if (d < this.bounds.x) {
            this.bounds.width += this.bounds.x - d;
            this.bounds.x = d;
        } else {
            this.bounds.width = Math.max(this.bounds.width, d - this.bounds.x);
        }
        if (d2 < this.bounds.y) {
            this.bounds.height += this.bounds.y - d2;
            this.bounds.y = d2;
        } else {
            this.bounds.height = Math.max(this.bounds.height, d2 - this.bounds.y);
        }
    }

    private double add(double[] dArray, double d) {
        return dArray[0] + (dArray[2] - dArray[0]) * (d - dArray[1]) / (dArray[3] - dArray[1]);
    }

    private double[][] addElement(double d, int n, int n2) {
        Rect2D rect2D = this.getBounds();
        if (d < rect2D.y || d > rect2D.y + rect2D.height || n2 == -1 && d == rect2D.y + rect2D.height || n2 == 1 && d == rect2D.y) {
            return null;
        }
        Vector<double[]> vector = new Vector<double[]>();
        double d2 = this.xpoints[0];
        double d3 = this.ypoints[0];
        int n3 = 1;
        while (n3 < this.npoints) {
            double d4 = this.xpoints[n3];
            double d5 = this.ypoints[n3];
            boolean bl = false;
            double d6 = Math.max(d3, d5);
            double d7 = Math.min(d3, d5);
            if (d7 != d6 && (d7 < d && d < d6 || n2 == -1 && d7 == d || n2 == 1 && d6 == d)) {
                double[] dArray = new double[n];
                dArray[0] = d2;
                dArray[1] = d3;
                dArray[2] = d4;
                dArray[3] = d5;
                dArray[4] = this.add(new double[]{d2, d3, d4, d5}, d);
                dArray[5] = d;
                dArray[6] = n3 - 1;
                dArray[7] = ExPolygon.compareTo(d3, d5);
                vector.addElement(dArray);
            }
            d2 = d4;
            d3 = d5;
            ++n3;
        }
        if (vector.size() == 0) {
            return null;
        }
        double[][] dArrayArray = new double[vector.size()][];
        vector.copyInto((Object[])dArrayArray);
        ExPolygon.compare(dArrayArray, n2 == 1 ? -1 : -2);
        return dArrayArray;
    }

    private double[][] addPoint(double d, int n, int n2) {
        double[][] dArray = this.addElement(d, n, n2);
        return new double[][]{dArray[0], dArray[dArray.length - 1]};
    }

    private ExPolygon[] adjust(double d, int n) {
        double[][] dArray = this.addElement(d, 8, n);
        this.bounds(dArray[0]);
        dArray = this.addElement(d, 11, n);
        int n2 = dArray.length;
        double[][] dArrayArray = new double[n2][];
        int n3 = 0;
        while (n3 < n2) {
            dArrayArray[n3] = dArray[n3];
            dArrayArray[n3][8] = n3;
            ++n3;
        }
        double[][] dArrayArray2 = new double[n2][];
        int n4 = 0;
        while (n4 < n2) {
            dArrayArray2[n4] = dArray[n4];
            ++n4;
        }
        ExPolygon.compare(dArrayArray2, 6);
        int n5 = 0;
        while (n5 < n2) {
            dArrayArray2[n5][9] = n5;
            ++n5;
        }
        return this.append(n, dArrayArray, dArrayArray2, n2);
    }

    private ExPolygon[] append(int n, double[][] dArray, double[][] dArray2, int n2) {
        Object[] objectArray;
        Vector<ExPolygon> vector = new Vector<ExPolygon>();
        Vector<double[]> vector2 = new Vector<double[]>();
        if (n == 1) {
            int n3 = 0;
            while (true) {
                if (n3 < n2) {
                    if ((int)dArray[n3][10] != 0) {
                        ++n3;
                        continue;
                    }
                }
                if (n3 != n2) {
                    vector2.setSize(0);
                    double[] dArray3 = dArray[n3];
                    double[] dArray4 = dArray2[(int)dArray3[9] + 1];
                    dArray3[10] = dArray3[10] + 1.0;
                    dArray4[10] = dArray4[10] + 1.0;
                    vector2.addElement(dArray3);
                    vector2.addElement(dArray4);
                    int n4 = (int)dArray3[8];
                    int n5 = (int)dArray4[8];
                    if (n5 - n4 >= 2) {
                        int n6 = n5 - 1;
                        while (true) {
                            double[] dArray5 = dArray[n6];
                            double[] dArray6 = dArray2[(int)dArray5[9] + 1];
                            int n7 = (int)dArray6[8];
                            vector2.addElement(dArray5);
                            vector2.addElement(dArray6);
                            dArray5[10] = dArray5[10] + 1.0;
                            dArray6[10] = dArray6[10] + 1.0;
                            if (n7 - n4 == 1) break;
                            n6 = n7 - 1;
                        }
                    }
                    objectArray = (Object[])new double[vector2.size()][];
                    vector2.copyInto(objectArray);
                    vector.addElement(this.arraycopy((double[][])objectArray, n));
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            int n8 = n2 - 1;
            while (true) {
                if (n8 >= 0) {
                    if ((int)dArray[n8][10] != 0) {
                        --n8;
                        continue;
                    }
                }
                if (n8 < 0) break;
                vector2.setSize(0);
                double[] dArray7 = dArray[n8];
                double[] dArray8 = dArray2[(int)dArray7[9] + 1];
                int n9 = (int)dArray7[8];
                int n10 = (int)dArray8[8];
                if (n9 - n10 >= 2) {
                    int n11 = n10 + 1;
                    while (true) {
                        double[] dArray9 = dArray[n11];
                        double[] dArray10 = dArray2[(int)dArray9[9] + 1];
                        int n12 = (int)dArray10[8];
                        vector2.addElement(dArray9);
                        vector2.addElement(dArray10);
                        dArray9[10] = dArray9[10] + 1.0;
                        dArray10[10] = dArray10[10] + 1.0;
                        if (n9 - n12 == 1) break;
                        n11 = n12 + 1;
                    }
                }
                vector2.addElement(dArray7);
                vector2.addElement(dArray8);
                dArray7[10] = dArray7[10] + 1.0;
                dArray8[10] = dArray8[10] + 1.0;
                objectArray = (Object[])new double[vector2.size()][];
                vector2.copyInto(objectArray);
                vector.addElement(this.arraycopy((double[][])objectArray, n));
                --n8;
            }
        }
        objectArray = new ExPolygon[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private ExPolygon arraycopy(double[][] dArray, int n) {
        int n2;
        ExPolygon exPolygon = new ExPolygon();
        int n3 = dArray.length;
        if (n == -1) {
            n2 = (int)dArray[n3 - 1][6] + 1;
            exPolygon.addPoint(this.xpoints[n2], this.ypoints[n2]);
        }
        n2 = 0;
        while (n2 < n3) {
            double[] dArray2 = dArray[n2];
            int n4 = (int)dArray2[6];
            exPolygon.addPoint(dArray2[4], dArray2[5]);
            if (dArray2[4] != this.xpoints[n4 + 1] || dArray2[5] != this.ypoints[n4 + 1]) {
                exPolygon.addPoint(this.xpoints[n4 + 1], this.ypoints[n4 + 1]);
            }
            double[] dArray3 = dArray[n2 + 1];
            int n5 = (int)dArray3[6];
            int n6 = n4 + 2;
            while (n6 <= n5) {
                exPolygon.addPoint(this.xpoints[n6], this.ypoints[n6]);
                ++n6;
            }
            if (dArray3[4] != this.xpoints[n5] || dArray3[5] != this.ypoints[n5]) {
                exPolygon.addPoint(dArray3[4], dArray3[5]);
            }
            n2 += 2;
        }
        exPolygon.closePath();
        return exPolygon;
    }

    private static ExPolygon[] black(ExPolygon exPolygon, ExPolygon exPolygon2) {
        int n;
        int n2;
        double[] dArray;
        int n3;
        int n4;
        double[][] dArray2 = exPolygon2.addElement(exPolygon2.getBounds().y, 8, -1);
        exPolygon2.bounds(dArray2[0]);
        dArray2 = exPolygon2.addElement(exPolygon2.getBounds().y, 9, -1);
        int n5 = dArray2.length;
        int n6 = 0;
        while (n6 < n5) {
            dArray2[n6][8] = -1.0;
            ++n6;
        }
        int n7 = 0;
        int n8 = exPolygon.npoints - 2;
        while (n8 >= 0) {
            double d = exPolygon.xpoints[n8];
            double d2 = exPolygon.ypoints[n8];
            double d3 = exPolygon.xpoints[n8 + 1];
            double d4 = exPolygon.ypoints[n8 + 1];
            n4 = 0;
            while (n4 < n5 && n7 < n5) {
                double[] dArray3 = dArray2[n4];
                if (!(dArray3[8] >= 0.0)) {
                    double d5 = dArray3[4];
                    double d6 = dArray3[5];
                    if (d == d5 && d2 == d6 || d2 == d4 && d2 == d6 && d <= d5 && d5 < d3) {
                        dArray3[8] = n8;
                        ++n7;
                    }
                }
                ++n4;
            }
            --n8;
        }
        double[] dArray4 = new double[(exPolygon.npoints + exPolygon2.npoints) * 2];
        double[] dArray5 = new double[(exPolygon.npoints + exPolygon2.npoints) * 2];
        int n9 = 0;
        int n10 = (n5 - 2) / 2;
        ExPolygon[] exPolygonArray = null;
        if (n10 > 0) {
            exPolygonArray = new ExPolygon[n10];
            n3 = 0;
            while (n3 < n10) {
                double[] dArray6 = dArray2[2 * n3 + 1];
                dArray = dArray2[(n3 + 1) * 2];
                n2 = (int)Math.round(dArray[8]);
                n4 = (int)Math.round(dArray6[8]);
                int n11 = (int)Math.round(dArray[6]) + 1;
                int n12 = (int)Math.round(dArray6[6]);
                n9 = 0;
                int n13 = n11;
                while (n13 >= n12) {
                    dArray4[n9] = exPolygon2.xpoints[n13];
                    dArray5[n9++] = exPolygon2.ypoints[n13];
                    --n13;
                }
                n = n4 + 1;
                while (n <= n2) {
                    dArray4[n9] = exPolygon.xpoints[n];
                    dArray5[n9++] = exPolygon.ypoints[n];
                    ++n;
                }
                if (exPolygon.xpoints[n4] != dArray[4] || exPolygon.ypoints[n4] != dArray[5]) {
                    dArray4[n9] = dArray[4];
                    dArray5[n9++] = dArray[5];
                }
                ExPolygon exPolygon3 = new ExPolygon();
                exPolygon3.blue(dArray4, dArray5, n9);
                exPolygonArray[n3] = exPolygon3;
                ++n3;
            }
        }
        dArray = dArray2[0];
        double[] dArray7 = dArray2[n5 - 1];
        n2 = (int)Math.round(dArray[8]) + 1;
        n4 = (int)Math.round(dArray7[8]);
        int n14 = (int)Math.round(dArray[6]) + 1;
        int n15 = (int)Math.round(dArray7[6]);
        n3 = 0;
        while (n3 < n4) {
            dArray4[n9] = exPolygon.xpoints[n3];
            dArray5[n9++] = exPolygon.ypoints[n3];
            ++n3;
        }
        if (exPolygon.xpoints[n4] != dArray[4] || exPolygon.ypoints[n4] != dArray[5]) {
            dArray4[n9] = exPolygon.xpoints[n4];
            dArray5[n9++] = exPolygon.ypoints[n4];
        }
        int n16 = n14;
        while (n16 >= n15) {
            dArray4[n9] = exPolygon2.xpoints[n16];
            dArray5[n9++] = exPolygon2.ypoints[n16];
            --n16;
        }
        n = n2;
        while (n < exPolygon.npoints) {
            dArray4[n9] = exPolygon.xpoints[n];
            dArray5[n9++] = exPolygon.ypoints[n];
            ++n;
        }
        exPolygon.blue(dArray4, dArray5, n9);
        exPolygon.closePath();
        return exPolygonArray;
    }

    public void unfold() {
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.children.size()) {
            ExPolygon exPolygon = this.doubleValue(n);
            Vector vector = exPolygon.children;
            if (vector == null || vector.size() == 0) {
                ++n;
                continue;
            }
            int n2 = vector.size();
            double d = Double.MAX_VALUE;
            int n3 = 0;
            while (n3 < n2) {
                d = Math.min(d, ((ExPolygon)vector.elementAt((int)n3)).getBounds().y);
                ++n3;
            }
            ExPolygon[] exPolygonArray = exPolygon.adjust(d, 1);
            ExPolygon[] exPolygonArray2 = exPolygon.adjust(d, -1);
            int n4 = exPolygonArray.length;
            int n5 = exPolygonArray2.length;
            if (n4 > 0) {
                this.children.setElementAt(exPolygonArray[0], n);
            } else {
                this.children.setElementAt(exPolygonArray2[0], n);
            }
            int n6 = 1;
            while (n6 < n4) {
                this.children.addElement(exPolygonArray[n6]);
                ++n6;
            }
            int n7 = n4 > 0 ? 0 : 1;
            while (n7 < n5) {
                this.children.addElement(exPolygonArray2[n7]);
                ++n7;
            }
            int n8 = 0;
            while (n8 < n5 && vector.size() > 0) {
                ExPolygon exPolygon2 = exPolygonArray2[n8];
                int n9 = vector.size() - 1;
                while (n9 >= 0) {
                    ExPolygon exPolygon3 = (ExPolygon)vector.elementAt(n9);
                    if (exPolygon2.compareTo(exPolygon3) > 0) {
                        if (ExPolygon.copyInto(exPolygon2.getBounds().y, exPolygon3.getBounds().y) == 0) {
                            int n10;
                            ExPolygon[] exPolygonArray3;
                            if (exPolygon3.children != null) {
                                exPolygonArray3 = exPolygon3.children;
                                n10 = 0;
                                while (n10 < exPolygonArray3.size()) {
                                    this.children.addElement((ExPolygon)exPolygonArray3.elementAt(n10));
                                    ++n10;
                                }
                            }
                            if ((exPolygonArray3 = ExPolygon.black(exPolygon2, exPolygon3)) != null) {
                                n10 = 0;
                                while (n10 < exPolygonArray3.length) {
                                    this.children.addElement(exPolygonArray3[n10]);
                                    ++n10;
                                }
                            }
                        } else {
                            if (exPolygon2.children == null) {
                                exPolygon2.children = new Vector();
                            }
                            exPolygon2.children.addElement(exPolygon3);
                        }
                        vector.removeElementAt(n9);
                    }
                    --n9;
                }
                ++n8;
            }
        }
        int n11 = this.children.size();
        int n12 = 0;
        while (n12 < n11) {
            this.doubleValue(n12).QOIV();
            ++n12;
        }
    }

    private void blue(double[] dArray, double[] dArray2, int n) {
        if (this.xpoints.length < n) {
            this.xpoints = new double[n];
            this.ypoints = new double[n];
        }
        System.arraycopy(dArray, 0, this.xpoints, 0, n);
        System.arraycopy(dArray2, 0, this.ypoints, 0, n);
        this.npoints = n;
        this.bounds = null;
        this.roundDir = 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append("@").append(this.hashCode());
        stringBuffer.append("{n=").append(this.npoints).append(" ");
        stringBuffer.append("round=").append(this.getRoundDir() == 1 ? "CLK" : "ACLK").append(" ");
        Rect2D rect2D = this.getBounds();
        if (rect2D != null) {
            stringBuffer.append("bounds ").append(rect2D.x + "_" + rect2D.y + "_" + rect2D.width + "_" + rect2D.height + " ");
        }
        int n = 0;
        while (n < this.npoints) {
            stringBuffer.append(" ");
            stringBuffer.append((int)this.xpoints[n]).append("_").append((int)this.ypoints[n]);
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void bounds(double[] dArray) {
        boolean bl;
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        int n = (int)Math.round(dArray[6]);
        int n2 = (int)Math.round(dArray[7]);
        int n3 = this.getRoundDir();
        boolean bl2 = d5 == d && d6 == d2;
        boolean bl3 = bl = d5 == d3 && d6 == d4;
        if (bl2 && n == 0 && n3 == 1) {
            return;
        }
        if (this.xpoints[this.npoints - 1] == this.xpoints[0] && this.ypoints[this.npoints - 1] == this.ypoints[0]) {
            --this.npoints;
        }
        int n4 = this.npoints + (bl2 || bl ? 1 : 2);
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        dArray2[0] = d5;
        dArray3[0] = d6;
        dArray2[n4 - 1] = d5;
        dArray3[n4 - 1] = d6;
        if (n3 == 1) {
            if (bl) {
                n = n == this.npoints - 1 ? 0 : n + 1;
                d = this.xpoints[n];
                d2 = this.ypoints[n];
                d3 = this.xpoints[n + 1];
                d4 = this.ypoints[n + 1];
                bl2 = true;
                bl = false;
            }
            System.arraycopy(this.xpoints, n + 1, dArray2, 1, this.npoints - n - 1);
            System.arraycopy(this.ypoints, n + 1, dArray3, 1, this.npoints - n - 1);
            System.arraycopy(this.xpoints, 0, dArray2, this.npoints - n, n + 1);
            System.arraycopy(this.ypoints, 0, dArray3, this.npoints - n, n + 1);
        } else {
            if (bl2) {
                n = n == 0 ? this.npoints - 1 : n - 1;
                d = this.xpoints[n];
                d2 = this.ypoints[n];
                d3 = this.xpoints[n + 1];
                d4 = this.ypoints[n + 1];
                bl2 = false;
                bl = true;
            }
            int n5 = 1;
            int n6 = n;
            while (n6 >= 0) {
                dArray2[n5] = this.xpoints[n6];
                dArray3[n5] = this.ypoints[n6];
                ++n5;
                --n6;
            }
            int n7 = this.npoints - 1;
            while (n7 > n) {
                dArray2[n5] = this.xpoints[n7];
                dArray3[n5] = this.ypoints[n7];
                ++n5;
                --n7;
            }
        }
        this.npoints = n4;
        this.xpoints = dArray2;
        this.ypoints = dArray3;
        this.roundDir = 1;
    }

    public int compareTo(ExPolygon exPolygon) {
        return ExPolygon.compare(this, exPolygon);
    }

    public static int compare(ExPolygon exPolygon, ExPolygon exPolygon2) {
        Rect2D rect2D = exPolygon.getBounds();
        Rect2D rect2D2 = exPolygon2.getBounds();
        Rect2D rect2D3 = rect2D.intersection(rect2D2);
        if (rect2D3.width <= 0.0 || rect2D3.height <= 0.0) {
            return 0;
        }
        double d = rect2D3.y;
        double[][] dArray = exPolygon.addElement(d, 9, -1);
        double[][] dArray2 = exPolygon2.addElement(d, 9, -1);
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = 0;
        while (n3 < n) {
            dArray[n3][8] = 1.0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            dArray2[n4][8] = 2.0;
            ++n4;
        }
        int n5 = n + n2;
        double[][] dArrayArray = new double[n5][];
        System.arraycopy(dArray, 0, dArrayArray, 0, n);
        System.arraycopy(dArray2, 0, dArrayArray, n, n2);
        ExPolygon.compare(dArrayArray, -2);
        if (dArrayArray[0][8] != dArrayArray[n5 - 1][8]) {
            return 0;
        }
        double d2 = dArrayArray[0][8];
        int n6 = 1;
        while (dArrayArray[n6][8] == d2 && n6 < n5 - 1) {
            ++n6;
        }
        if (n6 % 2 == 0) {
            return 0;
        }
        return ExPolygon.copyInto(dArrayArray[n6][8], d2);
    }

    private static final int children(double[] dArray, double[] dArray2, int n) {
        if (n >= 0) {
            return ExPolygon.copyInto(dArray[n], dArray2[n]);
        }
        switch (n) {
            case -2: 
            case -1: {
                double[] dArray3;
                double[] dArray4;
                double d = dArray[4];
                double d2 = dArray2[4];
                if (d != d2) {
                    return ExPolygon.copyInto(d, d2);
                }
                if (n == -1) {
                    dArray4 = dArray[7] == 1.0 ? new double[]{dArray[4], dArray[5], dArray[2], dArray[3]} : new double[]{dArray[4], dArray[5], dArray[0], dArray[1]};
                    dArray3 = dArray2[7] == 1.0 ? new double[]{dArray2[4], dArray2[5], dArray2[2], dArray2[3]} : new double[]{dArray2[4], dArray2[5], dArray2[0], dArray2[1]};
                } else if (n == -2) {
                    dArray4 = dArray[7] == 1.0 ? new double[]{dArray[4], dArray[5], dArray[0], dArray[1]} : new double[]{dArray[4], dArray[5], dArray[2], dArray[3]};
                    dArray3 = dArray2[7] == 1.0 ? new double[]{dArray2[4], dArray2[5], dArray2[0], dArray2[1]} : new double[]{dArray2[4], dArray2[5], dArray2[2], dArray2[3]};
                } else {
                    throw new RuntimeException("unsupport type " + n);
                }
                int n2 = ExPolygon.closePath(dArray4, dArray3);
                return n2;
            }
        }
        throw new RuntimeException("Unsupport compareTo type " + n);
    }

    private static int close(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        int n = ExPolygon.copyInto(d, d5);
        return n != 0 ? n : ExPolygon.copyInto((d3 - d) * (d8 - d6), (d4 - d2) * (d7 - d5)) * ExPolygon.copyInto(d4, d2);
    }

    private static int closePath(double[] dArray, double[] dArray2) {
        return ExPolygon.close(dArray[0], dArray[1], dArray[2], dArray[3], dArray2[0], dArray2[1], dArray2[2], dArray2[3]);
    }

    private static final void compare(double[][] dArray, int n) {
        ExPolygon.sort(dArray, 0, dArray.length - 1, n);
    }

    public static final void sort(double[][] dArray, int n, int n2, int n3) {
        if (ExPolygon.children(dArray[n], dArray[n2], n3) > 0) {
            double[] dArray2 = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = dArray2;
        }
        if (n + 1 >= n2) {
            return;
        }
        int n4 = (n2 - n + 1) / 3;
        ExPolygon.sort(dArray, n, n2 - n4, n3);
        ExPolygon.sort(dArray, n + n4, n2, n3);
        ExPolygon.sort(dArray, n, n2 - n4, n3);
    }

    private static final int compareTo(double d, double d2) {
        return d == d2 ? 0 : (d > d2 ? 1 : -1);
    }

    private static final int copyInto(double d, double d2) {
        if (Math.abs(d - d2) < 1.0E-5) {
            return 0;
        }
        return d > d2 ? 1 : (d < d2 ? -1 : 0);
    }

    private final ExPolygon doubleValue(int n) {
        return (ExPolygon)this.children.elementAt(n);
    }

    public void fill(Graphics graphics, double d, double d2) {
        this.fillOutline(graphics, d, d2);
        if (this.children != null) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                this.doubleValue(n).fill(graphics, d, d2);
                --n;
            }
        }
    }

    public void fillOutline(Graphics graphics, double d, double d2) {
        if (this.npoints < 2) {
            return;
        }
        if (graphics instanceof JGraphics) {
            graphics = ((JGraphics)graphics).getImpl();
        }
        if (graphics instanceof Rasterable) {
            double[] dArray = new double[this.npoints];
            double[] dArray2 = new double[this.npoints];
            int n = 0;
            while (n < this.npoints) {
                dArray[n] = this.xpoints[n] + d;
                dArray2[n] = this.ypoints[n] + d2;
                ++n;
            }
            ((Rasterable)((Object)graphics)).fillPolygon(dArray, dArray2, this.npoints);
        } else {
            int[] nArray = new int[this.npoints];
            int[] nArray2 = new int[this.npoints];
            int n = 0;
            while (n < this.npoints) {
                nArray[n] = (int)Math.round(this.xpoints[n]) + (int)Math.round(d);
                nArray2[n] = (int)Math.round(this.ypoints[n]) + (int)Math.round(d2);
                ++n;
            }
            graphics.fillPolygon(nArray, nArray2, this.npoints);
        }
    }

    public void draw(Graphics graphics, double d, double d2) {
        this.draw(graphics, d, d2, false);
    }

    public void draw(Graphics graphics, double d, double d2, boolean bl) {
        this.drawOutline(graphics, d, d2, bl);
        if (this.children != null) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                this.doubleValue(n).draw(graphics, d, d2, bl);
                --n;
            }
        }
    }

    public void drawOutline(Graphics graphics, double d, double d2, boolean bl) {
        if (this.npoints <= 1) {
            return;
        }
        double d3 = this.xpoints[0];
        double d4 = this.ypoints[0];
        double d5 = d3;
        double d6 = d4;
        int n = 1;
        while (n < this.npoints) {
            d5 = this.xpoints[n];
            d6 = this.ypoints[n];
            ExPolygon.drawLine(graphics, d + d3, d2 + d4, d + d5, d2 + d6);
            d3 = d5;
            d4 = d6;
            ++n;
        }
        d5 = this.xpoints[0];
        d6 = this.ypoints[0];
        if (d3 != d5 || d4 != d6) {
            ExPolygon.drawLine(graphics, d + d3, d2 + d4, d + d5, d2 + d6);
        }
    }

    public static void drawLine(Graphics graphics, double d, double d2, double d3, double d4) {
        graphics.drawLine((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
    }

    public void adjust(double d, double d2) {
        int n = 0;
        while (n < this.npoints) {
            int n2 = n;
            this.xpoints[n2] = this.xpoints[n2] - d;
            int n3 = n++;
            this.ypoints[n3] = this.ypoints[n3] - d2;
        }
        if (this.bounds != null) {
            this.bounds.x -= d;
            this.bounds.y -= d2;
        }
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        int n4 = 0;
        while (n4 < this.children.size()) {
            this.doubleValue(n4).adjust(d, d2);
            ++n4;
        }
    }

    public void zoom(double d) {
        int n = 0;
        while (n < this.npoints) {
            int n2 = n;
            this.xpoints[n2] = this.xpoints[n2] * d;
            int n3 = n++;
            this.ypoints[n3] = this.ypoints[n3] * d;
            this.bounds = null;
            this.roundDir = 0;
        }
        if (this.children == null) {
            return;
        }
        int n4 = 0;
        while (n4 < this.children.size()) {
            this.doubleValue(n4).zoom(d);
            ++n4;
        }
    }

    public boolean verifyInterserction(ExPolygon exPolygon) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.npoints - 1) {
            double d = this.xpoints[n];
            double d2 = this.ypoints[n];
            double d3 = this.xpoints[n + 1];
            double d4 = this.ypoints[n + 1];
            int n2 = 0;
            while (n2 < exPolygon.npoints - 1) {
                double[][] dArray = ExPolygon.getLineJunc(d, d2, d3, d4, exPolygon.xpoints[n2], exPolygon.ypoints[n2], exPolygon.xpoints[n2 + 1], exPolygon.ypoints[n2 + 1]);
                if (dArray != null && dArray.length > 0) {
                    stringBuffer.append("this seg " + d + "_" + d2 + "_" + d3 + "_" + d4 + " intersects with other " + exPolygon.xpoints[n2] + "_" + exPolygon.ypoints[n2] + "_" + exPolygon.xpoints[n2 + 1] + "_" + exPolygon.ypoints[n2 + 1] + "\n");
                }
                ++n2;
            }
            ++n;
        }
        if (stringBuffer.length() == 0) {
            return true;
        }
        System.err.println("*** Verify intersection ***");
        this.dump(1);
        exPolygon.dump(1);
        System.err.println("Found following errors");
        System.err.print(stringBuffer);
        new Exception().printStackTrace(System.err);
        System.err.println("***************************");
        return false;
    }

    public void verify() {
        int n = this.npoints;
        double[] dArray = this.xpoints;
        double[] dArray2 = this.ypoints;
        StringBuffer stringBuffer = new StringBuffer();
        if (n <= 2) {
            stringBuffer.append("Points are less than 3\n");
        }
        if (!this.D()) {
            stringBuffer.append("Unclosed\n");
        }
        int n2 = 0;
        while (n2 < n - 1) {
            if (dArray[n2] == dArray[n2 + 1] && dArray2[n2] == dArray2[n2 + 1]) {
                stringBuffer.append("Dup points are at " + n2 + " " + dArray[n2] + "_" + dArray2[n2] + "\n");
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 2) {
            if (dArray[n3] == dArray[n3 + 1] && dArray[n3 + 1] == dArray[n3 + 2] && ExPolygon.copyInto(dArray[n3], dArray[n3 + 1]) != ExPolygon.copyInto(dArray[n3 + 1], dArray[n3 + 2])) {
                stringBuffer.append("Overlap segs at X, pos " + n3 + " " + dArray[n3] + "_" + dArray2[n3] + " " + dArray[n3 + 1] + "_" + dArray2[n3 + 1] + " " + dArray[n3 + 2] + "_" + dArray2[n3 + 2] + "\n");
            }
            if (dArray2[n3] == dArray2[n3 + 1] && dArray2[n3 + 1] == dArray2[n3 + 2] && ExPolygon.copyInto(dArray2[n3], dArray2[n3 + 1]) != ExPolygon.copyInto(dArray2[n3 + 1], dArray2[n3 + 2])) {
                stringBuffer.append("Overlap segs at Y, pos " + n3 + " " + dArray[n3] + "_" + dArray2[n3] + " " + dArray[n3 + 1] + "_" + dArray2[n3 + 1] + " " + dArray[n3 + 2] + "_" + dArray2[n3 + 2] + "\n");
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n - 3) {
            int n5 = n4 + 3;
            while (n5 < n - 2) {
                double[][] dArray3 = ExPolygon.getLineJunc(dArray[n4], dArray2[n4], dArray[n4 + 1], dArray2[n4 + 1], dArray[n5], dArray2[n5], dArray[n5 + 1], dArray2[n5 + 1]);
                if (dArray3 != null && dArray3.length == 1) {
                    stringBuffer.append("intersects seg " + n4 + " and " + n5 + ", " + dArray[n4] + "_" + dArray2[n4] + "_" + dArray[n4 + 1] + "_" + dArray2[n4 + 1] + " " + dArray[n5] + "_" + dArray2[n5] + "_" + dArray[n5 + 1] + "_" + dArray2[n5 + 1] + ", junc:" + dArray3[0][0] + "_" + dArray3[0][1]);
                }
                ++n5;
            }
            ++n4;
        }
        if (this.bounds != null) {
            Rect2D rect2D = this.bounds;
            this.bounds = null;
            if (!rect2D.equals(this.getBounds())) {
                stringBuffer.append("Exprired bounds, org " + this.bounds + ", new " + this.getBounds() + "\n");
                this.bounds = rect2D;
            }
        }
        if (this.roundDir != 0) {
            int n6 = this.roundDir;
            this.roundDir = 0;
            if (n6 != this.getRoundDir()) {
                stringBuffer.append("Exprired roundDir, org " + n6 + ", new " + this.roundDir + "\n");
                this.roundDir = n6;
            }
        }
        if (stringBuffer.length() > 0) {
            System.err.println("*** Verify polygon ***");
            this.dump(1);
            System.err.println("Found Following errors:");
            System.err.print(stringBuffer.toString());
            new Exception().printStackTrace();
            System.err.println("**********************");
        }
    }

    public static double[][] getLineJunc(double[] dArray, double[] dArray2) {
        return ExPolygon.getLineJunc(dArray[0], dArray[1], dArray[2], dArray[3], dArray2[0], dArray2[1], dArray2[2], dArray2[3]);
    }

    public static double[][] getLineJunc(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        if (d == d3) {
            if (d5 == d7) {
                return d == d5 ? null : new double[][]{};
            }
            d10 = d;
            d = d5;
            d5 = d10;
            d10 = d3;
            d3 = d7;
            d7 = d10;
            d10 = d2;
            d2 = d6;
            d6 = d10;
            d10 = d4;
            d4 = d8;
            d8 = d10;
        }
        d10 = (d4 - d2) / (d3 - d);
        double d11 = d2 - d10 * d;
        if (d5 == d7) {
            d9 = d5;
        } else {
            double d12 = (d8 - d6) / (d7 - d5);
            double d13 = d6 - d12 * d5;
            if (d12 == d10) {
                return d13 == d11 ? null : new double[][]{};
            }
            d9 = (d11 - d13) / (d12 - d10);
        }
        double d14 = d10 * d9 + d11;
        if (ExPolygon.copyInto(d, d9) == 0 && ExPolygon.copyInto(d2, d14) == 0 || ExPolygon.copyInto(d3, d9) == 0 && ExPolygon.copyInto(d4, d14) == 0 || ExPolygon.copyInto(d5, d9) == 0 && ExPolygon.copyInto(d6, d14) == 0 || ExPolygon.copyInto(d7, d9) == 0 && ExPolygon.copyInto(d8, d14) == 0) {
            return new double[0][];
        }
        if (ExPolygon.copyInto(d, d9) == ExPolygon.copyInto(d9, d3) && ExPolygon.copyInto(d2, d14) == ExPolygon.copyInto(d14, d4) && ExPolygon.copyInto(d5, d9) == ExPolygon.copyInto(d9, d7) && ExPolygon.copyInto(d6, d14) == ExPolygon.copyInto(d14, d8)) {
            return new double[][]{{d9, d14}};
        }
        return new double[0][];
    }

    public Rect2D getOutlineRect() {
        if (this.children == null || this.children.size() == 0) {
            throw new RuntimeException("Null ExPolygon");
        }
        Rect2D rect2D = this.doubleValue(0).getBounds();
        int n = 1;
        while (n < this.children.size()) {
            rect2D = rect2D.union(this.doubleValue(n).getBounds());
            ++n;
        }
        return rect2D;
    }

    public double[] adjust() {
        Rect2D rect2D = this.getOutlineRect();
        this.adjust(rect2D.x, rect2D.y);
        return new double[]{rect2D.x, rect2D.y};
    }

    public static void drawRect(Graphics graphics, double d, double d2, double d3, double d4) {
        graphics.drawRect((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
    }

    public static void fillRect(Graphics graphics, double d, double d2, double d3, double d4) {
        graphics.fillRect((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
    }

    public static void drawString(Graphics graphics, String string, double d, double d2) {
        graphics.drawString(string, (int)Math.round(d), (int)Math.round(d2));
    }

    public static void dump(double[] dArray) {
        ExPolygon.dump(dArray, System.out, false);
    }

    public static void dump(double[] dArray, PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print("seg:" + dArray[0] + "_" + dArray[1] + "_" + dArray[2] + "_" + dArray[3] + " junc:" + dArray[4] + "_" + dArray[5] + " segnum:" + dArray[6] + ((int)dArray[7] == 1 ? " UP" : ((int)dArray[7] == -1 ? " DOWN" : ((int)dArray[7] == 0 ? " HORI" : " UNKNOWN DIR " + dArray[7]))));
        } else {
            printStream.print("seg:" + (int)dArray[0] + "_" + (int)dArray[1] + "_" + (int)dArray[2] + "_" + (int)dArray[3] + " junc:" + (int)dArray[4] + "_" + (int)dArray[5] + " segnum:" + dArray[6] + ((int)dArray[7] == 1 ? " UP" : ((int)dArray[7] == -1 ? " DOWN" : ((int)dArray[7] == 0 ? " HORI" : " UNKNOWN DIR " + dArray[7]))));
        }
        if (dArray.length > 10) {
            printStream.print(" xodr:" + (int)dArray[8]);
            printStream.print(" segodr:" + (int)dArray[9]);
            printStream.print(" touched:" + (int)dArray[10]);
        } else {
            int n = 8;
            while (n < dArray.length) {
                printStream.print(" " + n + ":" + dArray[n]);
                ++n;
            }
        }
        printStream.println();
    }

    public void dump(int n) {
        this.dump(n, true);
    }

    public void dump(int n, boolean bl) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("  ");
            ++n2;
        }
        System.out.print("" + n + ": ");
        if (bl) {
            System.out.println(this);
        } else {
            System.out.println(this.hashCode());
        }
        if (this.children != null) {
            int n3 = 0;
            while (n3 < this.children.size()) {
                this.doubleValue(n3).dump(n + 1);
                ++n3;
            }
        }
    }

    public void dump(Graphics graphics, int n, int n2) {
        this.drawLine(graphics, n, n2, 0);
    }

    public void save(String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            this.draw(printStream, -1);
            printStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void draw(PrintStream printStream, int n) throws IOException {
        int n2;
        if (this.npoints > 0) {
            n2 = 0;
            while (n2 < n) {
                printStream.print("   ");
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.npoints) {
                printStream.print("" + this.xpoints[n3] + "_" + this.ypoints[n3] + ",");
                ++n3;
            }
        }
        printStream.println();
        if (this.children == null) {
            return;
        }
        n2 = 0;
        while (n2 < this.children.size()) {
            this.doubleValue(n2).draw(printStream, n + 1);
            ++n2;
        }
    }

    public static ExPolygon read(String string) {
        try {
            String string2;
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            ExPolygon exPolygon = new ExPolygon();
            while ((string2 = dataInputStream.readLine()) != null) {
                if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#") || string2.startsWith(";")) continue;
                ExPolygon exPolygon2 = new ExPolygon();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,_");
                while (stringTokenizer.hasMoreTokens()) {
                    double d = new Double(stringTokenizer.nextToken());
                    double d2 = new Double(stringTokenizer.nextToken());
                    exPolygon2.addPoint(d, d2);
                }
                exPolygon.add(exPolygon2);
            }
            dataInputStream.close();
            return exPolygon;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(QOIV[n3]);
        this.fill(graphics, n, n2);
        if (this.children == null) {
            return;
        }
        int n4 = 0;
        while (n4 < this.children.size()) {
            this.doubleValue(n4).drawLine(graphics, n, n2, n3 + 1);
            ++n4;
        }
    }

    static {
        QOIV = new Color[]{Color.white, Color.black, Color.blue, Color.red, Color.green, Color.yellow};
    }
}

