/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui;

import guitools.toolkit.JDebug;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jet.cs.CSUtil;
import jet.cs.ReportListIntf;
import jet.cs.ValueTrigger;
import jet.cs.ui.CSGuiUtil;
import jet.cs.ui.JRButton;
import jet.cs.ui.schedule.CheckListItem;
import jet.cs.ui.schedule.VersionRecordForDisplay;
import jet.cs.ui.schedule.trigger.TriggerDBUser;
import jet.cs.ui.schedule.trigger.TriggerEditorPanel;
import jet.cs.ui.schedule.trigger.TriggerLanguage;
import jet.cs.ui.schedule.trigger.TriggerPrint;
import jet.cs.ui.schedule.trigger.TriggerStyleGroup;
import jet.util.EncodingSupport;

public class ReportTriggerPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    public static int DEFAULT_WD = 480;
    public static int DEFAULT_HT = 380;
    private ReportListIntf QOIV;
    private boolean WARNING;
    private Properties add;
    private int addActionListener;
    private ValueTrigger[] addListSelectionListener;
    private JPanel cbConvert = new JPanel();
    private JLabel cbPrint = new JLabel("Catalog:");
    private JComboBox cbStyleGroup = new JComboBox();
    private JLabel cbbEncoding = new JLabel("Report Set:");
    private JComboBox cbbFrom = new JComboBox();
    private JLabel cbbLanguage = new JLabel();
    private JLabel cbbStyleGroup = new JLabel();
    private JRButton cbbTo = new JRButton("Browse...");
    private JRButton createEtchedBorder = new JRButton("Browse...");
    private JLabel createTitledBorder = new JLabel("Catalog Version:");
    private JComboBox elementAt = new JComboBox();
    private JLabel equals = new JLabel("Report Set Version:");
    private JComboBox get = new JComboBox();
    private JLabel getAvailableLanguages = new JLabel("Task Name:");
    private JTextField getBoolean = new JTextField();
    private Rectangle getBooleanNames = new Rectangle(0, 0, 330, 180);
    private JPanel getCatalog = new JPanel();
    private CheckListItem[] getCatalogs = null;
    private JList getElementAt = null;
    private JScrollPane getItemAt = new JScrollPane();
    private JPanel getItemCount = new JPanel();
    private String getLogonUser = null;
    private String getMessage = null;
    private Frame getModel = null;

    public ReportTriggerPanel(Frame frame, Properties properties, ReportListIntf reportListIntf, boolean bl) throws Exception {
        this.getModel = frame;
        this.QOIV = reportListIntf;
        this.WARNING = bl;
        this.add = properties;
        Vector vector = ValueTrigger.getTriggers(properties);
        int n = vector.size();
        int n2 = 0;
        while (n2 < this.addActionListener) {
            this.addListSelectionListener[n2] = n2 < n ? (ValueTrigger)vector.elementAt(n2) : null;
            ++n2;
        }
        this.DEFAULT_HT();
    }

    private void DEFAULT_HT() {
        this.setLayout(null);
        this.setSize(DEFAULT_WD, DEFAULT_HT);
        this.cbConvert.setLayout(null);
        this.cbbEncoding.setBounds(0, 0, 60, 20);
        this.cbbFrom.setBounds(70, 0, 240, 20);
        this.cbbStyleGroup.setBounds(110, 0, 250, 20);
        this.createEtchedBorder.setBounds(320, 0, 90, 20);
        this.cbPrint.setBounds(0, 25, 60, 20);
        this.cbStyleGroup.setBounds(70, 25, 240, 20);
        this.cbbLanguage.setBounds(70, 25, 300, 20);
        this.cbbTo.setBounds(320, 25, 90, 20);
        this.createTitledBorder.setBounds(0, 55, 100, 20);
        this.elementAt.setBounds(110, 55, 300, 20);
        this.equals.setBounds(0, 80, 100, 20);
        this.get.setBounds(110, 80, 300, 20);
        this.getAvailableLanguages.setBounds(0, 105, 105, 20);
        this.getBoolean.setBounds(110, 105, 300, 20);
        this.cbConvert.setBounds(25, 10, 430, 155);
        this.cbConvert.add(this.cbPrint);
        this.cbConvert.add(this.cbStyleGroup);
        this.cbConvert.add(this.cbbEncoding);
        this.cbConvert.add(this.cbbFrom);
        this.cbConvert.add((Component)this.cbbTo);
        this.cbConvert.add((Component)this.createEtchedBorder);
        this.cbConvert.add(this.createTitledBorder);
        this.cbConvert.add(this.elementAt);
        this.cbConvert.add(this.equals);
        this.cbConvert.add(this.get);
        this.cbConvert.add(this.getAvailableLanguages);
        this.cbConvert.add(this.getBoolean);
        this.getCatalogs = new CheckListItem[5];
        this.getCatalogs[0] = new CheckListItem("Trigger Task", "Trigger Task", new TriggerEditorPanel(this.getModel, this.QOIV, this.add), false);
        this.getCatalogs[1] = new CheckListItem("DB User", "DB User", new TriggerDBUser(), false);
        this.getCatalogs[2] = new CheckListItem("Language", "Language", new TriggerLanguage(), false);
        this.getCatalogs[3] = new CheckListItem("Style Group", "Style Group", new TriggerStyleGroup(), false);
        this.getCatalogs[4] = new CheckListItem("Print", "Print", new TriggerPrint(), false);
        this.getElementAt = new JList<CheckListItem>(this.getCatalogs);
        this.getItemAt.setBounds(10, 20, 100, 180);
        this.getItemAt.setViewportView(this.getElementAt);
        this.getItemCount.setBounds(120, 20, 340, 180);
        ((JPanel)this.getCatalogs[0].getValue()).setBounds(this.getBooleanNames);
        this.getItemCount.setLayout(null);
        this.getItemCount.add((JPanel)this.getCatalogs[0].getValue());
        this.getCatalog.setLayout(null);
        this.getCatalog.setBounds(0, 160, 470, 210);
        this.getCatalog.add(this.getItemAt);
        this.getCatalog.add(this.getItemCount);
        this.getElementAt.setSelectedIndex(0);
        this.getElementAt.addListSelectionListener(this);
        this.cbbTo.addActionListener((ActionListener)this);
        this.createEtchedBorder.addActionListener((ActionListener)this);
        this.cbStyleGroup.addActionListener(this);
        this.cbbFrom.addActionListener(this);
        this.getCatalog.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Setting"));
        this.add(this.cbConvert);
        this.add(this.getCatalog);
        this.DEFAULT_WD(this.add);
    }

    public Properties toProperties(Properties properties) throws Exception {
        if (properties != null) {
            Object object;
            Object object2;
            String string;
            String string2 = (String)this.cbbFrom.getSelectedItem();
            String string3 = (String)this.cbStyleGroup.getSelectedItem();
            if (string2 != null) {
                properties.put("jrs.report", string2);
            }
            if (string3 != null) {
                properties.put("jrs.catalog", string3);
            }
            VersionRecordForDisplay versionRecordForDisplay = (VersionRecordForDisplay)this.get.getSelectedItem();
            VersionRecordForDisplay versionRecordForDisplay2 = (VersionRecordForDisplay)this.elementAt.getSelectedItem();
            if (versionRecordForDisplay != null) {
                properties.put("jrs.rpt_version", versionRecordForDisplay.getVersionNumber());
            }
            if (versionRecordForDisplay2 != null) {
                properties.put("jrs.cat_version", versionRecordForDisplay2.getVersionNumber());
            }
            if ((string = this.getBoolean.getText()) != null && string.trim().length() > 0) {
                properties.put("jrs.task_name", string);
            }
            TriggerEditorPanel triggerEditorPanel = (TriggerEditorPanel)((CheckListItem)this.getElementAt.getModel().getElementAt(0)).getValue();
            triggerEditorPanel.getValues(properties);
            TriggerDBUser triggerDBUser = (TriggerDBUser)((CheckListItem)this.getElementAt.getModel().getElementAt(1)).getValue();
            boolean bl = triggerDBUser.rbDefaultDBUser.isSelected();
            properties.put("jrs.use_def_db_user", String.valueOf(bl));
            if (!bl) {
                properties.put("jrs.db_user", triggerDBUser.tfUser.getText());
                properties.put("jrs.db_pswd", triggerDBUser.pfPasswd.getText());
            }
            TriggerLanguage triggerLanguage = (TriggerLanguage)((CheckListItem)this.getElementAt.getModel().getElementAt(2)).getValue();
            String string4 = (String)triggerLanguage.cbbEncoding.getSelectedItem();
            properties.put("jrs.rpt_encoding", string4);
            String string5 = (String)triggerLanguage.cbbLanguage.getSelectedItem();
            if (string5 != null && string5.trim().length() > 0) {
                properties.put("jrs.rpt_language", string5);
            }
            boolean bl2 = triggerLanguage.cbConvert.isSelected();
            properties.put("jrs.has_convert_enc", String.valueOf(bl2));
            if (bl2) {
                object2 = null;
                String string6 = null;
                object2 = triggerLanguage.cbbFrom.getSelectedItem().toString();
                if (object2 != null && ((String)object2).equals("GB2312")) {
                    object2 = "0";
                } else if (object2 != null && ((String)object2).equals("Big5")) {
                    object2 = "2";
                }
                string6 = triggerLanguage.cbbTo.getSelectedItem().toString();
                if (string6 != null && string6.equals("GB2312")) {
                    string6 = "0";
                } else if (string6 != null && string6.equals("Big5")) {
                    string6 = "2";
                }
                if (object2 != null && string6 != null) {
                    properties.put("jrs.from_encoding", object2);
                    properties.put("jrs.to_encoding", string6);
                }
            }
            object2 = (TriggerStyleGroup)((CheckListItem)this.getElementAt.getModel().getElementAt(3)).getValue();
            boolean bl3 = ((TriggerStyleGroup)object2).cbStyleGroup.isSelected();
            properties.put("jrs.has_style", String.valueOf(bl3));
            if (bl3 && (object = (String)((TriggerStyleGroup)object2).cbbStyleGroup.getSelectedItem()) != null) {
                properties.put("jrs.style_group", object);
            }
            object = (TriggerPrint)((CheckListItem)this.getElementAt.getModel().getElementAt(4)).getValue();
            boolean bl4 = ((TriggerPrint)object).cbPrint.isSelected();
            String string7 = ((TriggerPrint)object).printer.getPrinter();
            properties.put("jrs.printer", bl4 ? string7 : "");
        }
        return properties;
    }

    private void DEFAULT_WD(Hashtable hashtable) {
        if (hashtable != null) {
            Object object;
            Object object2;
            String string;
            Object object3;
            Object object4;
            String string2;
            String string3 = (String)hashtable.get("jrs.report");
            String string4 = (String)hashtable.get("jrs.catalog");
            String string5 = (String)hashtable.get("jrs.rpt_version");
            String string6 = (String)hashtable.get("jrs.cat_version");
            if (string3 != null) {
                string2 = string3.substring(0, string3.lastIndexOf("/"));
                if (string2.trim().length() == 0) {
                    string2 = "/";
                }
                object4 = this.QOIV.getReports(string2);
                CSGuiUtil.loadToComboBox((Vector)object4, this.cbbFrom);
                this.cbbFrom.setSelectedItem(string3);
            }
            if (string4 != null) {
                string2 = string4.substring(0, string4.lastIndexOf("/"));
                if (string2.trim().length() == 0) {
                    string2 = "/";
                }
                object4 = this.QOIV.getCatalogs(string2);
                CSGuiUtil.loadToComboBox((Vector)object4, this.cbStyleGroup);
                this.cbStyleGroup.setSelectedItem(string4);
            }
            this.cbStyleGroup();
            this.cbPrint();
            this.addListSelectionListener();
            if (string5 != null) {
                int n = 0;
                while (n < this.get.getItemCount()) {
                    object4 = (VersionRecordForDisplay)this.get.getItemAt(n);
                    if (object4 != null && string5.equals(((VersionRecordForDisplay)object4).getVersionNumber())) {
                        this.get.setSelectedIndex(n);
                        break;
                    }
                    ++n;
                }
            }
            if (string6 != null) {
                int n = 0;
                while (n < this.elementAt.getItemCount()) {
                    object4 = (VersionRecordForDisplay)this.elementAt.getItemAt(n);
                    if (object4 != null && string5.equals(((VersionRecordForDisplay)object4).getVersionNumber())) {
                        this.elementAt.setSelectedIndex(n);
                        break;
                    }
                    ++n;
                }
            }
            String string7 = (String)hashtable.get("jrs.task_name");
            this.getBoolean.setText(string7);
            object4 = (TriggerEditorPanel)((CheckListItem)this.getElementAt.getModel().getElementAt(0)).getValue();
            ((TriggerEditorPanel)object4).setValues(hashtable);
            boolean bl = CSUtil.getBoolean((String)((String)hashtable.get("jrs.use_def_db_user")), (boolean)true);
            TriggerDBUser triggerDBUser = (TriggerDBUser)((CheckListItem)this.getElementAt.getModel().getElementAt(1)).getValue();
            triggerDBUser.rbDefaultDBUser.setSelected(bl);
            triggerDBUser.rbCostumDBUser.setSelected(!bl);
            if (!bl) {
                object3 = (String)hashtable.get("jrs.db_user");
                string = (String)hashtable.get("jrs.db_pswd");
                triggerDBUser.tfUser.setText((String)object3);
                triggerDBUser.pfPasswd.setText(string);
            }
            object3 = (TriggerLanguage)((CheckListItem)this.getElementAt.getModel().getElementAt(2)).getValue();
            ((TriggerLanguage)object3).cbbLanguage.removeAllItems();
            string = (String)hashtable.get("jrs.rpt_encoding");
            String string8 = (String)((TriggerLanguage)object3).cbbLanguage.getSelectedItem();
            if (string8 != null && string4 != null && string3 != null) {
                try {
                    CSGuiUtil.loadToComboBox(this.QOIV.getAvailableLanguages(this.QOIV.getLogonUser(), string4, string3, string8), ((TriggerLanguage)object3).cbbLanguage);
                }
                catch (Exception exception) {
                    JDebug.WARNING((Throwable)exception);
                    JOptionPane.showMessageDialog(this.getModel, exception.getMessage(), "Error", 0);
                }
            }
            ((TriggerLanguage)object3).cbbLanguage.setEnabled(((TriggerLanguage)object3).cbbLanguage.getItemCount() > 0);
            ((TriggerLanguage)object3).labLanguage.setEnabled(((TriggerLanguage)object3).cbbLanguage.isEnabled());
            CSGuiUtil.loadToComboBox(EncodingSupport.getSupportedEncodingDescriptions(), ((TriggerLanguage)object3).cbbEncoding);
            if (string != null) {
                ((TriggerLanguage)object3).cbbEncoding.setSelectedItem(string);
            }
            String[] stringArray = new String[]{"GB2312", "Big5"};
            CSGuiUtil.loadToComboBox(stringArray, ((TriggerLanguage)object3).cbbFrom);
            CSGuiUtil.loadToComboBox(stringArray, ((TriggerLanguage)object3).cbbTo);
            boolean bl2 = CSUtil.getBoolean((String)((String)hashtable.get("jrs.has_convert_enc")), (boolean)false);
            ((TriggerLanguage)object3).cbConvert.setSelected(bl2);
            ((TriggerLanguage)object3).cbbFrom.setEnabled(bl2);
            ((TriggerLanguage)object3).cbbFrom.setSelectedIndex(1);
            ((TriggerLanguage)object3).cbbTo.setEnabled(bl2);
            if (bl2) {
                String string9;
                Object object5 = object2 = hashtable == null ? "2" : (String)hashtable.get("jrs.from_encoding");
                if (object2 == null) {
                    object2 = "2";
                }
                String string10 = string9 = this.add == null ? "0" : (String)hashtable.get("jrs.to_encoding");
                if (string9 == null) {
                    string9 = "0";
                }
                if (object2 != null && ((String)object2).trim().length() > 0) {
                    if (((String)object2).equals("0")) {
                        ((TriggerLanguage)object3).cbbFrom.setSelectedItem(stringArray[0]);
                    } else if (((String)object2).equals("2")) {
                        ((TriggerLanguage)object3).cbbFrom.setSelectedItem(stringArray[1]);
                    }
                }
                if (string9 != null && string9.trim().length() > 0) {
                    if (string9.equals("0")) {
                        ((TriggerLanguage)object3).cbbTo.setSelectedItem(stringArray[0]);
                    } else if (string9.equals("2")) {
                        ((TriggerLanguage)object3).cbbTo.setSelectedItem(stringArray[1]);
                    }
                }
            }
            object2 = (TriggerStyleGroup)((CheckListItem)this.getElementAt.getModel().getElementAt(3)).getValue();
            boolean bl3 = CSUtil.getBoolean((String)((String)hashtable.get("jrs.has_style")), (boolean)false);
            ((TriggerStyleGroup)object2).cbStyleGroup.setSelected(bl3);
            ((TriggerStyleGroup)object2).cbbStyleGroup.setEnabled(bl3);
            if (string4 != null && string3 != null) {
                try {
                    ((TriggerStyleGroup)object2).cbbStyleGroup.removeAllItems();
                    CSGuiUtil.loadToComboBox(this.QOIV.getStyleGroupDisplayNames(this.QOIV.getLogonUser(), string4, string3), ((TriggerStyleGroup)object2).cbbStyleGroup);
                }
                catch (Exception exception) {
                    JDebug.WARNING((Throwable)exception);
                    JOptionPane.showMessageDialog(this.getModel, exception.getMessage(), "Error", 0);
                }
                object = (String)hashtable.get("jrs.style_group");
                if (object != null && ((String)object).trim().length() > 0) {
                    ((TriggerStyleGroup)object2).cbbStyleGroup.setSelectedItem(object);
                }
            }
            object = (TriggerPrint)((CheckListItem)this.getElementAt.getModel().getElementAt(4)).getValue();
            ((TriggerPrint)object).setPrinters(this.QOIV.getPrintersOfServer(this.QOIV.getLogonUser()));
            String string11 = (String)hashtable.get("jrs.printer");
            if (string11 != null && string11.trim().length() > 0) {
                ((TriggerPrint)object).printer.setPrinter(string11);
            }
        }
    }

    public boolean checkTask() {
        TriggerEditorPanel triggerEditorPanel = (TriggerEditorPanel)((CheckListItem)this.getElementAt.getModel().getElementAt(0)).getValue();
        return triggerEditorPanel.hasEdited();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        CheckListItem checkListItem = (CheckListItem)this.getElementAt.getSelectedValue();
        this.getItemCount.removeAll();
        if (checkListItem != null && (object = checkListItem.getValue()) != null) {
            ((JComponent)object).setBounds(this.getBooleanNames);
            this.getItemCount.add((JComponent)object);
        }
        this.getItemCount.updateUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cbStyleGroup) {
            this.add();
        } else if (object == this.cbbFrom) {
            this.addActionListener();
        } else if (object == this.cbbTo) {
            this.QOIV();
        } else if (object == this.createEtchedBorder) {
            this.WARNING();
        }
    }

    private void QOIV() {
        String string = this.QOIV.getCatalog((String)this.cbStyleGroup.getSelectedItem());
        if (string != null) {
            String string2 = string.substring(0, string.lastIndexOf("/"));
            if (string2.trim().length() == 0) {
                string2 = "/";
            }
            Vector vector = this.QOIV.getCatalogs(string2);
            CSGuiUtil.loadToComboBox(vector, this.cbStyleGroup);
            this.cbStyleGroup.setSelectedItem(string);
            this.add();
        }
    }

    private void WARNING() {
        String string = this.QOIV.getReport((String)this.cbbFrom.getSelectedItem());
        if (string != null) {
            String string2 = string.substring(0, string.lastIndexOf("/"));
            if (string2.trim().length() == 0) {
                string2 = "/";
            }
            Vector vector = this.QOIV.getReports(string2);
            CSGuiUtil.loadToComboBox(vector, this.cbbFrom);
            this.cbbFrom.setSelectedItem(string);
            String string3 = (String)this.cbStyleGroup.getSelectedItem();
            if (string3 == null || string3.trim().length() == 0) {
                Vector vector2 = this.QOIV.getCatalogs(string2);
                CSGuiUtil.loadToComboBox(vector2, this.cbStyleGroup);
                this.add();
            }
            this.addActionListener();
        }
    }

    private void add() {
        this.addListSelectionListener();
        this.cbConvert();
        this.cbPrint();
        this.cbbEncoding();
    }

    private void addActionListener() {
        String string = (String)this.cbbFrom.getSelectedItem();
        if (string != null) {
            if (!string.equals(this.getLogonUser)) {
                this.getLogonUser = string;
            }
        } else {
            this.getLogonUser = null;
        }
        this.addListSelectionListener();
        this.cbConvert();
        this.cbStyleGroup();
        this.cbbEncoding();
    }

    private void addListSelectionListener() {
        String string = (String)this.cbStyleGroup.getSelectedItem();
        String string2 = (String)this.cbbFrom.getSelectedItem();
        if (string != null && string2 != null) {
            try {
                Vector vector = this.QOIV.getBooleanNames(this.QOIV.getLogonUser(), string, string2);
                CheckListItem checkListItem = (CheckListItem)this.getElementAt.getModel().getElementAt(0);
                TriggerEditorPanel triggerEditorPanel = (TriggerEditorPanel)checkListItem.getValue();
                triggerEditorPanel.setParameterNames(vector);
            }
            catch (Exception exception) {
                JDebug.WARNING((Throwable)exception);
                JOptionPane.showMessageDialog(this.getModel, exception.getMessage(), "Error", 0);
            }
        }
    }

    private void cbConvert() {
        String string = (String)this.cbStyleGroup.getSelectedItem();
        String string2 = (String)this.cbbFrom.getSelectedItem();
        TriggerLanguage triggerLanguage = (TriggerLanguage)((CheckListItem)this.getElementAt.getModel().getElementAt(2)).getValue();
        triggerLanguage.cbbLanguage.removeAllItems();
        if (string != null && string2 != null) {
            String string3 = (String)triggerLanguage.cbbLanguage.getSelectedItem();
            try {
                CSGuiUtil.loadToComboBox(this.QOIV.getAvailableLanguages(this.QOIV.getLogonUser(), string, string2, string3), triggerLanguage.cbbLanguage);
            }
            catch (Exception exception) {
                JDebug.WARNING((Throwable)exception);
                JOptionPane.showMessageDialog(this.getModel, exception.getMessage(), "Error", 0);
            }
            triggerLanguage.cbbLanguage.setEnabled(triggerLanguage.cbbLanguage.getItemCount() > 0);
            triggerLanguage.labLanguage.setEnabled(triggerLanguage.cbbLanguage.isEnabled());
        }
    }

    private void cbPrint() {
        this.elementAt.removeAllItems();
        String string = (String)this.cbStyleGroup.getSelectedItem();
        if (string != null) {
            Vector vector = this.QOIV.getVersions("Catalog", string);
            vector.add(0, new VersionRecordForDisplay("-1", "Always using latest version"));
            CSGuiUtil.loadToComboBox(vector, this.elementAt);
            this.elementAt.setSelectedIndex(0);
        }
    }

    private void cbStyleGroup() {
        this.get.removeAllItems();
        String string = (String)this.cbbFrom.getSelectedItem();
        if (string != null) {
            Vector vector = this.QOIV.getVersions("report", string);
            vector.add(0, new VersionRecordForDisplay("-1", "Always using latest version"));
            CSGuiUtil.loadToComboBox(vector, this.get);
            this.get.setSelectedIndex(0);
        }
    }

    private void cbbEncoding() {
        String string = (String)this.cbbFrom.getSelectedItem();
        String string2 = (String)this.cbStyleGroup.getSelectedItem();
        TriggerStyleGroup triggerStyleGroup = (TriggerStyleGroup)((CheckListItem)this.getElementAt.getModel().getElementAt(3)).getValue();
        boolean bl = triggerStyleGroup.cbStyleGroup.isSelected();
        String string3 = (String)triggerStyleGroup.cbbStyleGroup.getSelectedItem();
        triggerStyleGroup.cbStyleGroup.setSelected(bl);
        triggerStyleGroup.cbbStyleGroup.setEnabled(bl);
        triggerStyleGroup.cbbStyleGroup.removeAllItems();
        if (string != null && string2 != null) {
            try {
                CSGuiUtil.loadToComboBox(this.QOIV.getStyleGroupDisplayNames(this.QOIV.getLogonUser(), string2, string), triggerStyleGroup.cbbStyleGroup);
            }
            catch (Exception exception) {
                JDebug.WARNING((Throwable)exception);
                JOptionPane.showMessageDialog(this.getModel, exception.getMessage(), "Error", 0);
            }
            if (string3 != null) {
                triggerStyleGroup.cbbStyleGroup.setSelectedItem(string3);
            }
        }
    }
}

