/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui;

import guitools.GuiUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jet.JCliResource;
import jet.cs.ReportListIntf;
import jet.cs.ui.CSGuiUtil;
import jet.cs.ui.ScheduleSheet;
import jet.cs.ui.ScriptContentDlg;
import toolkit.db.SortCompareInterface;

public abstract class ScheduleListPanel
extends JPanel
implements ActionListener,
MouseListener,
WindowListener,
SortCompareInterface,
ReportListIntf {
    protected JTable table = null;
    protected JScrollPane scrollpane;
    final Object[] addActionListener = new Object[]{JCliResource.getMessage((String)"CS_MSG_3"), JCliResource.getMessage((String)"CS_MSG_236"), JCliResource.getMessage((String)"CS_MSG_2"), JCliResource.getMessage((String)"CS_MSG_242"), JCliResource.getMessage((String)"CS_MSG_243"), JCliResource.getMessage((String)"CS_MSG_8"), JCliResource.getMessage((String)"CS_MSG_6"), JCliResource.getMessage((String)"CS_MSG_11"), JCliResource.getMessage((String)"CS_MSG_12"), JCliResource.getMessage((String)"CS_MSG_10"), JCliResource.getMessage((String)"CS_MSG_7"), JCliResource.getMessage((String)"CS_MSG_181")};
    protected Object[][] values = new Object[0][];
    protected String[] ttls = new String[]{JCliResource.getMessage((String)"CS_MSG_3"), JCliResource.getMessage((String)"CS_MSG_236"), JCliResource.getMessage((String)"CS_MSG_2"), JCliResource.getMessage((String)"CS_MSG_242"), JCliResource.getMessage((String)"CS_MSG_243"), JCliResource.getMessage((String)"CS_MSG_8"), JCliResource.getMessage((String)"CS_MSG_6"), JCliResource.getMessage((String)"CS_MSG_11"), JCliResource.getMessage((String)"CS_MSG_12"), JCliResource.getMessage((String)"CS_MSG_10"), JCliResource.getMessage((String)"CS_MSG_7"), JCliResource.getMessage((String)"CS_MSG_181")};
    protected static final int COL_SID = 0;
    protected static final int COL_NAME = 1;
    protected static final int COL_CAT = 2;
    protected static final int COL_RPT = 3;
    protected static final int COL_SHEETS = 4;
    protected static final int COL_SUBMITBY = 5;
    protected static final int COL_LAUNCHTYPE = 6;
    protected static final int COL_NEXTTIME = 7;
    protected static final int COL_LASTTIME = 8;
    protected static final int COL_SUCC = 9;
    protected static final int COL_TASKTP = 10;
    protected static final int COL_ENABLED = 11;
    protected int flds = this.ttls.length;
    protected Vector recs = new Vector();
    protected String[] va = new String[this.flds];
    protected JButton btnNew;
    protected JButton btnEdit;
    protected JButton btnDelete;
    protected JButton btnRefresh;
    protected JButton btnRunNow;
    protected JButton btnCopy;
    protected JButton btnBatScriptImport;
    protected JButton btnBatScriptExport;
    protected ScriptContentDlg tp;
    protected boolean isSubmit = false;
    protected JButton btnEnable;
    protected JButton btnDisable;
    protected String timezone = null;

    public ScheduleListPanel() {
        this.DEFAULT_WD();
    }

    public void setTimeZone(String string) {
        this.timezone = string != null && string.trim().length() == 0 ? null : string;
    }

    public String getTimeZone() {
        return this.timezone;
    }

    public void doNew() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!CSGuiUtil.isInModDlg) {
            CSGuiUtil.isInModDlg = true;
            JDialog jDialog = new JDialog(GuiUtil.getFrame((Component)this), JCliResource.getMessage((String)"CS_MSG_16"));
            ScheduleSheet scheduleSheet = new ScheduleSheet(jDialog, new Properties(), this, true, this.timezone);
            jDialog.getContentPane().setLayout(null);
            jDialog.setModal(true);
            jDialog.setBounds(0, 0, ScheduleSheet.DEFAULT_WD, ScheduleSheet.DEFAULT_HT);
            jDialog.setResizable(false);
            jDialog.getContentPane().add(scheduleSheet);
            jDialog.addWindowListener(scheduleSheet);
            jDialog.show();
            CSGuiUtil.isInModDlg = false;
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public abstract void doCopy();

    public abstract void doRunNow();

    public abstract void doDelete();

    public abstract void doEnable();

    public abstract void doDisable();

    public abstract void doRefresh();

    public abstract void doBatScriptImport(File var1);

    public abstract String doBatScriptExport();

    public File promptForBatScript(Button button) {
        button.setEnabled(false);
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setVisible(true);
        if (jFileChooser.getCurrentDirectory() != null && jFileChooser.getFileView() != null) {
            file = jFileChooser.getSelectedFile();
        }
        button.setEnabled(true);
        return file;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        File file = null;
        String string = null;
        if (object == this.btnNew) {
            this.doNew();
        } else if (object == this.btnEdit) {
            this.doEdit();
        } else if (object == this.btnDelete) {
            this.doDelete();
        } else if (object == this.btnRefresh) {
            this.doRefresh();
        } else if (object == this.btnRunNow) {
            this.doRunNow();
        } else if (object == this.btnCopy) {
            this.doCopy();
        } else if (object == this.btnEnable) {
            this.doEnable();
        } else if (object == this.btnDisable) {
            this.doDisable();
        } else if (object == this.btnBatScriptExport) {
            string = this.doBatScriptExport();
            if (string != null && string.trim().length() > 0) {
                this.showScriptDlg(string, null, false);
            }
        } else if (object == this.btnBatScriptImport && (file = this.DEFAULT_HT(this.btnBatScriptImport)) != null && file.exists()) {
            this.showScriptDlg(null, file, true);
            if (this.tp.getIsImport()) {
                this.doBatScriptImport(file);
            }
        }
        this.validate();
    }

    private File DEFAULT_HT(JButton jButton) {
        jButton.setEnabled(false);
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setVisible(true);
        if (jFileChooser.showOpenDialog(jButton) == 0) {
            file = jFileChooser.getSelectedFile();
        }
        if (jFileChooser.getCurrentDirectory() == null || jFileChooser.getFileView() != null) {
            // empty if block
        }
        jButton.setEnabled(true);
        return file;
    }

    public void showScriptDlg(String string, File file, boolean bl) {
        if (!CSGuiUtil.isInModDlg) {
            CSGuiUtil.isInModDlg = true;
            JDialog jDialog = new JDialog(GuiUtil.getFrame((Component)this), "script content");
            this.tp = new ScriptContentDlg(jDialog, string, file, bl);
            jDialog.getContentPane().setLayout(null);
            jDialog.setModal(true);
            jDialog.setBounds(0, 0, ScriptContentDlg.DEFAULT_WD, ScriptContentDlg.DEFAULT_HT);
            jDialog.setResizable(false);
            jDialog.getContentPane().add(this.tp);
            jDialog.addWindowListener(this.tp);
            jDialog.show();
            CSGuiUtil.isInModDlg = false;
        }
    }

    void DEFAULT_WD() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.table = new JTable(this.values, this.addActionListener);
        this.setItLayout(this.table);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public abstract Properties getHT(int var1);

    public void doEdit() {
    }

    public synchronized int getRowByTaskId(String string) {
        return -1;
    }

    public void updateButtons() {
        boolean bl = this.table.getRowCount() > 0;
        boolean bl2 = this.table.getSelectedRowCount() > 0;
        this.btnRunNow.setEnabled(bl & bl2);
        this.btnCopy.setEnabled(bl & bl2);
        this.btnDelete.setEnabled(bl & bl2);
        this.btnEdit.setEnabled(bl & bl2);
        this.btnBatScriptExport.setEnabled(bl & bl2);
        this.btnEnable.setEnabled(bl & bl2);
        this.btnDisable.setEnabled(bl & bl2);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public abstract String submit(Hashtable var1) throws Exception;

    public abstract InputStream getParamfile(String var1, String var2, String var3) throws Exception;

    public abstract Vector getBooleanNames(String var1, String var2, String var3) throws Exception;

    public abstract String getLogonUser();

    public abstract String findCatalog(String var1);

    public boolean isExchangeSortOrder(Object object, Object object2) {
        return object != null && object2 != null && (object instanceof File ? ((File)object).getName().toUpperCase().compareTo(((File)object2).getName().toUpperCase()) < 0 : (object instanceof String ? ((String)object).toUpperCase().compareTo(((String)object2).toUpperCase()) < 0 : object instanceof String[] && ((String[])object)[0].toUpperCase().compareTo(((String[])object2)[0].toUpperCase()) < 0));
    }

    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }

    public void setItLayout(JTable jTable) {
        this.table = jTable;
        this.scrollpane = new JScrollPane(this.table);
        this.add((Component)this.scrollpane, "Center");
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        this.btnRefresh = new JButton(JCliResource.getMessage((String)"CS_MSG_17"));
        this.btnRefresh.addActionListener(this);
        jPanel.add(this.btnRefresh);
        this.btnNew = new JButton(JCliResource.getMessage((String)"CS_MSG_18"));
        this.btnNew.addActionListener(this);
        jPanel.add(this.btnNew);
        this.btnEdit = new JButton(JCliResource.getMessage((String)"CS_MSG_19"));
        this.btnEdit.addActionListener(this);
        jPanel.add(this.btnEdit);
        this.btnDelete = new JButton(JCliResource.getMessage((String)"CS_MSG_20"));
        this.btnDelete.addActionListener(this);
        jPanel.add(this.btnDelete);
        this.btnRunNow = new JButton("Run Now");
        this.btnRunNow.addActionListener(this);
        jPanel.add(this.btnRunNow);
        this.btnCopy = new JButton("Copy");
        this.btnCopy.addActionListener(this);
        jPanel.add(this.btnCopy);
        this.btnBatScriptImport = new JButton(JCliResource.getMessage((String)"CS_MSG_169"));
        this.btnBatScriptImport.addActionListener(this);
        jPanel.add(this.btnBatScriptImport);
        this.btnBatScriptExport = new JButton(JCliResource.getMessage((String)"CS_MSG_170"));
        this.btnBatScriptExport.addActionListener(this);
        jPanel.add(this.btnBatScriptExport);
        this.btnEnable = new JButton("Enable");
        this.btnEnable.addActionListener(this);
        jPanel.add(this.btnEnable);
        this.btnDisable = new JButton("Disable");
        this.btnDisable.addActionListener(this);
        jPanel.add(this.btnDisable);
    }

    public void refreshButtons() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        this.btnRefresh = new JButton(JCliResource.getMessage((String)"CS_MSG_17"));
        this.btnRefresh.addActionListener(this);
        jPanel.add(this.btnRefresh);
        this.btnNew = new JButton(JCliResource.getMessage((String)"CS_MSG_18"));
        this.btnNew.addActionListener(this);
        jPanel.add(this.btnNew);
        this.btnEdit = new JButton(JCliResource.getMessage((String)"CS_MSG_19"));
        this.btnEdit.addActionListener(this);
        jPanel.add(this.btnEdit);
        this.btnDelete = new JButton(JCliResource.getMessage((String)"CS_MSG_20"));
        this.btnDelete.addActionListener(this);
        jPanel.add(this.btnDelete);
        this.btnRunNow = new JButton("Run Now");
        this.btnRunNow.addActionListener(this);
        jPanel.add(this.btnRunNow);
        this.btnCopy = new JButton("Copy");
        this.btnCopy.addActionListener(this);
        jPanel.add(this.btnCopy);
        this.btnBatScriptImport = new JButton("Import");
        this.btnBatScriptImport.addActionListener(this);
        jPanel.add(this.btnBatScriptImport);
        this.btnBatScriptExport = new JButton("Export");
        this.btnBatScriptExport.addActionListener(this);
        jPanel.add(this.btnBatScriptExport);
        this.btnEnable = new JButton("Enable");
        this.btnEnable.addActionListener(this);
        jPanel.add(this.btnEnable);
        this.btnDisable = new JButton("Disable");
        this.btnDisable.addActionListener(this);
        jPanel.add(this.btnDisable);
    }

    public abstract Vector getCatVector(String var1);

    public abstract String selCatalog(String var1, String var2);

    public abstract String getReport(String var1);

    public abstract String getCatalog(String var1);

    public abstract Vector getReports(String var1);

    public abstract Vector getCatalogs(String var1);

    public abstract String getFolderPath(String var1);

    public abstract boolean canExportDhtmlResult(Hashtable var1);

    public abstract String getServerURL();
}

