/*
 * Decompiled with CFR 0.152.
 */
package barcode.linearBarcode;

import barcode.linearBarcode.Barcode128;
import barcode.linearBarcode.Barcode39;
import barcode.linearBarcode.BarcodeCodabar;
import barcode.linearBarcode.BarcodeEAN13;
import barcode.linearBarcode.BarcodeEAN8;
import barcode.linearBarcode.BarcodeObject;
import barcode.linearBarcode.BarcodeUPCA;
import barcode.linearBarcode.BarcodeUPCE;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class BarcodeConstraints
extends JComponent {
    private int QOIV;
    private String calculateWidth = new String();
    private String init = new String();
    protected BarcodeObject[] barcodes;
    public boolean runtime = true;
    public short barHeight = (short)72;
    private int locate = 1;
    private String paint;
    private Color rotate;
    private Color setBar128Type;
    private boolean I = true;
    private Font Z;
    private short C;
    private short B;
    private int D = 2;
    private boolean F = true;
    private int J;
    private int S;
    private int A = 3;
    private int E = 2;
    private boolean G;
    private int H;
    private double K;
    private Dimension L = new Dimension();
    private float M = 1.0f;
    private boolean N;

    public BarcodeConstraints() {
    }

    public BarcodeConstraints(int n, String string) {
        this.QOIV = n;
        this.init = string;
        this.init();
    }

    public void locate() {
        this.J = this.getBounds().width / 2;
        this.S = this.getBounds().height / 2;
    }

    public void init() {
        this.K = (double)this.H * Math.PI / 180.0;
        this.barcodes = new BarcodeObject[1];
        this.QOIV(this.QOIV, this.init);
        this.locate();
    }

    private void QOIV(int n, String string) {
        switch (n) {
            case 6: {
                this.barcodes[0] = new BarcodeCodabar(this);
                break;
            }
            case 5: {
                this.barcodes[0] = new Barcode128(this);
                break;
            }
            case 4: {
                this.barcodes[0] = new Barcode39(this);
                break;
            }
            case 2: {
                this.barcodes[0] = new BarcodeEAN13(this);
                break;
            }
            case 3: {
                this.barcodes[0] = new BarcodeEAN8(this);
                break;
            }
            case 1: {
                this.barcodes[0] = new BarcodeUPCE(this);
                break;
            }
            case 0: {
                this.barcodes[0] = new BarcodeUPCA(this);
                break;
            }
            case 7: {
                this.barcodes[0] = new Barcode128(this);
                this.setBar128Type(0);
                break;
            }
            case 8: {
                this.barcodes[0] = new Barcode128(this);
                this.setBar128Type(1);
                break;
            }
            case 9: {
                this.barcodes[0] = new Barcode128(this);
                this.setBar128Type(2);
            }
        }
        this.barcodes[0].init();
    }

    public void paint(Graphics2D graphics2D) {
        this.init();
        graphics2D.rotate(this.K);
        this.barcodes[0].paint(graphics2D);
        graphics2D.rotate(-this.K);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paint(graphics2D);
    }

    public void calculateWidth() {
        this.init();
        this.barcodes[0].calculateWidth();
    }

    public void calculateWidth(Graphics graphics) {
        this.init();
        this.barcodes[0].calculateWidth((Graphics2D)graphics);
    }

    public void setType(int n) {
        this.QOIV = n;
    }

    public int getType() {
        return this.QOIV;
    }

    public void setBodeCodeData(String string) {
        this.init = string;
    }

    public String getBodeCodeData() {
        return this.init;
    }

    public Object clone() {
        return null;
    }

    public void updateProperties() {
    }

    public void updateBounds() {
    }

    public void setBarOrientation(int n) {
        this.H = n;
    }

    public int getBarOrientation() {
        return this.H;
    }

    public void setBarHRFont(Font font) {
        this.Z = font;
    }

    public Font getBarHRFont() {
        return this.Z;
    }

    public void setBar128Type(int n) {
        this.A = n;
    }

    public int getBar128Type() {
        return this.A;
    }

    public void setBarCheckEnable(boolean bl) {
        this.I = bl;
    }

    public boolean getBarCheckEnable() {
        return this.I;
    }

    public void setBarNarrowWidth(short s) {
        this.locate = s;
    }

    public short getBarNarrowWidth() {
        return (short)this.locate;
    }

    public void setBarMessage(String string) {
        this.init = string;
    }

    public String getBarMessage() {
        return this.init;
    }

    public void setBarQuietZone(short s) {
        this.C = s;
        this.B = s;
    }

    public short getBarQuietZone() {
        return this.C;
    }

    public void setBarRatio(float f) {
        this.D = (int)f;
    }

    public float getBarRatio() {
        return this.D;
    }

    public void setBarScaleMode(int n) {
        this.E = n;
    }

    public int getBarScaleMode() {
        return this.E;
    }

    public void setBarSupplement(String string) {
        this.paint = string;
    }

    public String getBarSupplement() {
        return this.paint;
    }

    public void setBarSymbology(int n) {
        this.QOIV = n;
    }

    public int getBarSymbology() {
        return this.QOIV;
    }

    public void setBarHeight(short s) {
        this.barHeight = s;
    }

    public short getBarHeight() {
        return this.barHeight;
    }

    public void setBarHRDisplay(boolean bl) {
        this.F = bl;
    }

    public boolean getBarHRDisplay() {
        return this.F;
    }

    public void setBarTransparent(boolean bl) {
        this.G = bl;
    }

    public boolean getBarTransparent() {
        return this.G;
    }

    public void setBackground(Color color) {
        this.rotate = color;
    }

    public Color getBackground() {
        return this.rotate;
    }

    public void setForeground(Color color) {
        this.setBar128Type = color;
    }

    public Color getForeground() {
        return this.setBar128Type;
    }

    public void setCenterXY(int n, int n2) {
        this.J = n;
        this.S = n2;
    }

    public int getCenterX() {
        return this.J;
    }

    public int getCenterY() {
        return this.S;
    }

    public Dimension getPreferredSize() {
        return this.L;
    }

    public void setBarDimension(Dimension dimension) {
        this.L = dimension;
    }

    public void setUnit(float f) {
        this.M = f / 100.0f;
    }

    public float getUnit() {
        return this.M;
    }

    public void setIsExportToPDF(boolean bl) {
        this.N = bl;
    }

    public boolean getIsExportToPDF() {
        return this.N;
    }
}

