/*
 * Decompiled with CFR 0.152.
 */
package barcode.linearBarcode;

import barcode.BarcodeTable;
import barcode.BarcodeUtil;
import barcode.linearBarcode.BarcodeConstraints;
import barcode.linearBarcode.LinearBarcode;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class BarcodeEAN8
extends LinearBarcode {
    public int centreX;
    public int centreY;
    String EAN13;
    boolean EAN13Translate = false;

    public BarcodeEAN8(BarcodeConstraints barcodeConstraints) {
        this.paper = barcodeConstraints;
    }

    public void init() {
        this.EAN13 = this.paper.getBarMessage();
        this.centreX = this.paper.getCenterX();
        this.centreY = this.paper.getCenterY();
        this.foreColor = this.paper.getForeground();
        this.barHeight = this.paper.getBarHeight();
        this.narrowWidth = this.paper.getBarNarrowWidth();
        this.scaleMode = this.paper.getBarScaleMode();
        this.bottomLabelFont = this.paper.getBarHRFont();
        this.supplementText = this.paper.getBarSupplement();
        this.startingQuietZone = this.paper.getBarQuietZone();
        this.unit = this.paper.getUnit();
        if (this.supplementText != null && (this.supplementText.length() == 2 || this.supplementText.length() == 5)) {
            this.EAN13Translate = true;
        }
        this.backColor = this.paper.getBackground();
        this.isExPDF = this.paper.getIsExportToPDF();
    }

    public void paint(Graphics2D graphics2D) {
        this.printEAN8(graphics2D, this.EAN13);
    }

    public void calculateWidth() {
        this.EAN13(this.EAN13);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void EAN13(String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f5 *= this.unit;
        f6 *= this.unit;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        float f7 = f3 / 10.0f;
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) < '0' || string.charAt(n2) > '9') {
                return;
            }
            ++n2;
        }
        if (this.EAN13Translate && this.supplementText.length() == 2) {
            stringBuffer = BarcodeUtil.supplement2Tran(this.supplementText);
        } else if (this.EAN13Translate && this.supplementText.length() == 5) {
            stringBuffer = BarcodeUtil.supplement5Tran(this.supplementText);
        }
        if (string.length() == 7) {
            n = BarcodeUtil.checkCode(string);
            stringBufferArray = BarcodeEAN8.EAN8Tran(string + String.valueOf(n));
        } else {
            if (string.length() != 8) return;
            n = BarcodeUtil.checkCode(string.substring(0, 7));
            if (!String.valueOf(n).equals(String.valueOf(string.charAt(7)))) return;
            stringBufferArray = BarcodeEAN8.EAN8Tran(string);
        }
        Rectangle2D rectangle2D = BarcodeUtil.getBounds("" + string.charAt(0), this.bottomLabelFont);
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        f = this.EAN13Translate ? (f2 = (float)this.centreX - ((float)(stringBufferArray[0].length() + stringBufferArray[1].length() + stringBuffer.length()) * f5 / 2.0f + (float)(n3 / 2))) : (f2 = (float)this.centreX - (float)(stringBufferArray[0].length() + stringBufferArray[1].length()) * f5 / 2.0f);
        int n5 = 0;
        while (n5 < stringBufferArray[0].length()) {
            f += f5;
            ++n5;
        }
        float f8 = f;
        int n6 = 0;
        while (n6 < stringBufferArray[1].length()) {
            f += f5;
            ++n6;
        }
        if (this.EAN13Translate) {
            float f9 = f += (float)n3;
            int n7 = 0;
            while (n7 < stringBuffer.length()) {
                f += f5;
                ++n7;
            }
        }
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n3 * 2)), (int)(f3 + (float)(n4 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    public void calculateWidth(Graphics2D graphics2D) {
        this.EAN13Translate(graphics2D, this.EAN13);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void EAN13Translate(Graphics2D graphics2D, String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f5 *= this.unit;
        f6 *= this.unit;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        float f7 = f3 / 10.0f;
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        graphics2D.setFont(this.bottomLabelFont);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) < '0' || string.charAt(n2) > '9') {
                return;
            }
            ++n2;
        }
        if (this.EAN13Translate && this.supplementText.length() == 2) {
            stringBuffer = BarcodeUtil.supplement2Tran(this.supplementText);
        } else if (this.EAN13Translate && this.supplementText.length() == 5) {
            stringBuffer = BarcodeUtil.supplement5Tran(this.supplementText);
        }
        if (string.length() == 7) {
            n = BarcodeUtil.checkCode(string);
            stringBufferArray = BarcodeEAN8.EAN8Tran(string + String.valueOf(n));
        } else {
            if (string.length() != 8) return;
            n = BarcodeUtil.checkCode(string.substring(0, 7));
            if (!String.valueOf(n).equals(String.valueOf(string.charAt(7)))) return;
            stringBufferArray = BarcodeEAN8.EAN8Tran(string);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth("" + string.charAt(0));
        int n4 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        f = this.EAN13Translate ? (f2 = (float)this.centreX - ((float)(stringBufferArray[0].length() + stringBufferArray[1].length() + stringBuffer.length()) * f5 / 2.0f + (float)(n3 / 2))) : (f2 = (float)this.centreX - (float)(stringBufferArray[0].length() + stringBufferArray[1].length()) * f5 / 2.0f);
        int n5 = 0;
        while (n5 < stringBufferArray[0].length()) {
            f += f5;
            ++n5;
        }
        float f8 = f;
        int n6 = 0;
        while (n6 < stringBufferArray[1].length()) {
            f += f5;
            ++n6;
        }
        if (this.EAN13Translate) {
            float f9 = f += (float)n3;
            int n7 = 0;
            while (n7 < stringBuffer.length()) {
                f += f5;
                ++n7;
            }
        }
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n3 * 2)), (int)(f3 + (float)(n4 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    public static StringBuffer[] EAN8Tran(String string) {
        int n;
        String string2 = new String();
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        stringBufferArray[0] = stringBufferArray[0].append("101");
        int n2 = 0;
        while (n2 < 4) {
            n = 0;
            while (n <= 9) {
                if (string.charAt(n2) == BarcodeTable.EAN13[n]) {
                    stringBufferArray[0].append(BarcodeTable.EAN13Translate[0][n]);
                }
                ++n;
            }
            ++n2;
        }
        stringBufferArray[1].append("01010");
        n = 4;
        while (n < 8) {
            int n3 = 0;
            while (n3 <= 9) {
                if (string.charAt(n) == BarcodeTable.EAN13[n3]) {
                    stringBufferArray[1].append(BarcodeTable.EAN13Translate[2][n3]);
                }
                ++n3;
            }
            ++n;
        }
        stringBufferArray[1].append("101");
        return stringBufferArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printEAN8(Graphics2D graphics2D, String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f5 *= this.unit;
        f6 *= this.unit;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        float f7 = f3 / 10.0f;
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        graphics2D.setFont(this.bottomLabelFont);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) < '0' || string.charAt(n2) > '9') {
                return;
            }
            ++n2;
        }
        if (this.EAN13Translate && this.supplementText.length() == 2) {
            stringBuffer = BarcodeUtil.supplement2Tran(this.supplementText);
        } else if (this.EAN13Translate && this.supplementText.length() == 5) {
            stringBuffer = BarcodeUtil.supplement5Tran(this.supplementText);
        }
        if (string.length() == 7) {
            n = BarcodeUtil.checkCode(string);
            stringBufferArray = BarcodeEAN8.EAN8Tran(string + String.valueOf(n));
        } else {
            if (string.length() != 8) return;
            n = BarcodeUtil.checkCode(string.substring(0, 7));
            if (!String.valueOf(n).equals(String.valueOf(string.charAt(7)))) return;
            stringBufferArray = BarcodeEAN8.EAN8Tran(string);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth("" + string.charAt(0));
        int n4 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        f = this.EAN13Translate ? (f2 = (float)this.centreX - ((float)(stringBufferArray[0].length() + stringBufferArray[1].length() + stringBuffer.length()) * f5 / 2.0f + (float)(n3 / 2))) : (f2 = (float)this.centreX - (float)(stringBufferArray[0].length() + stringBufferArray[1].length()) * f5 / 2.0f);
        int n5 = 0;
        while (n5 < stringBufferArray[0].length()) {
            if (stringBufferArray[0].charAt(n5) == '1') {
                graphics2D.setColor(this.foreColor);
                if (n5 <= 2) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
                }
            } else if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
                if (n5 <= 2) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                }
            }
            f += f5;
            ++n5;
        }
        graphics2D.setColor(this.foreColor);
        BarcodeUtil.printBarcodeDataM(string.substring(0, 4), graphics2D, (int)(f / 2.0f + (f2 + f5 * 3.0f) / 2.0f), (int)(f3 + f4), (int)(f - f2 - f5 * 3.0f));
        float f8 = f;
        int n6 = 0;
        while (n6 < stringBufferArray[1].length()) {
            if (stringBufferArray[1].charAt(n6) == '1') {
                graphics2D.setColor(this.foreColor);
                if (n6 <= 4 || n6 >= stringBufferArray[1].length() - 3) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
                }
            } else if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
                if (n6 <= 4 || n6 >= stringBufferArray[1].length() - 3) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                }
            }
            f += f5;
            ++n6;
        }
        graphics2D.setColor(this.foreColor);
        if (string.length() == 7) {
            BarcodeUtil.printBarcodeDataM(string.substring(4) + String.valueOf(n), graphics2D, (int)((f8 + 5.0f * f5) / 2.0f + (f - 3.0f * f5) / 2.0f), (int)(f3 + f4), (int)(f - 3.0f * f5 - f8 - 5.0f * f5));
        } else {
            BarcodeUtil.printBarcodeDataM(string.substring(4), graphics2D, (int)((f8 + 5.0f * f5) / 2.0f + (f - 3.0f * f5) / 2.0f), (int)(f3 + f4), (int)(f - 3.0f * f5 - f8 - 5.0f * f5));
        }
        if (this.EAN13Translate) {
            float f9 = f += (float)n3;
            int n7 = 0;
            while (n7 < stringBuffer.length()) {
                if (stringBuffer.charAt(n7) == '1') {
                    graphics2D.setColor(this.foreColor);
                    BarcodeUtil.drawbar(graphics2D, f, f4 + f7, f5, f3 - f7);
                } else if (this.isExPDF) {
                    if (this.backColor != null) {
                        graphics2D.setColor(this.backColor);
                    } else {
                        graphics2D.setColor(Color.white);
                    }
                    BarcodeUtil.drawbar(graphics2D, f, f4 + f7, f5, f3 - f7);
                }
                f += f5;
                ++n7;
            }
            graphics2D.setColor(this.foreColor);
            BarcodeUtil.printBarcodeDataU(this.supplementText, graphics2D, (int)((f9 + f) / 2.0f), (int)(f4 + f7), (int)(f - f9));
        }
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n3 * 2)), (int)(f3 + (float)(n4 * 2)));
        this.paper.setBarDimension(this.barD);
    }
}

