/*
 * Decompiled with CFR 0.152.
 */
package chart.axis;

import chart.ChartLabelBase;
import chart.ChartObject;
import chart.axis.ChartAxisArrowStyle;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.data.ChartDataFilter;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartAxisProperties;
import chart.properties.ChartNumericAxisProperties;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ChartAxis
extends ChartObject {
    public static final int TICK_TYPE_NONE = 0;
    public static final int TICK_TYPE_OUTSIDE = 1;
    public static final int TICK_TYPE_INSIDE = 2;
    public static final int TICK_TYPE_CROSS = 3;
    public static final int POSITION_NONE = 0;
    public static final int POSITION_TOP = 1;
    public static final int POSITION_LEFT = 2;
    public static final int POSITION_BOTTOM = 3;
    public static final int POSITION_RIGHT = 4;
    public static final int POSITION_3D_AUTO = 5;
    public static final int LABEL_TYPE_OUTSIDE = 0;
    public static final int LABEL_TYPE_INSIDE = 1;
    protected float[][] axisPoint;
    protected float[][] majorTickMarkPoint;
    private float[][] D;
    protected float[][] labelPoint;
    private int[][] F;
    private GeneralPath[] IsLabelFontAutomaticOrientation;
    private int IsShowLabelTips;
    private int QOIV = -1;
    private double abs;
    private int atan;
    private Line2D.Float calculateAxisOffset;
    private float clone;
    protected ChartAxisProperties properties;
    protected ChartDataFilter filter;
    protected ChartLabelBase[] paintingLabels;
    private ChartTextStyle closePath;
    private boolean contains;
    private Point2D.Double[][] cos;
    private int draw;
    private int drawAxis;
    protected int numOfTicks;
    private int drawLabels;
    private Rectangle2D[] drawTickMark;
    private float formatAngle;
    private float getAxisPen;
    protected boolean isDepth = false;

    ChartAxis(ChartAxisProperties chartAxisProperties) {
        this.properties = chartAxisProperties;
    }

    public void init() {
        this.drawLabels = this.paintingLabels.length;
        this.IsShowLabelTips = 0;
        this.closePath = (ChartTextStyle)this.properties.getLabelTextStyle().clone();
        this.calculateAxisOffset = new Line2D.Float();
        this.axisPoint = new float[2][2];
        this.formatAngle = 0.0f;
        this.getAxisPen = 0.0f;
        if (this.properties.isShowTickMarkLabels()) {
            this.F = new int[this.drawLabels][2];
            this.IsLabelFontAutomaticOrientation = new GeneralPath[this.drawLabels];
            this.drawTickMark = new Rectangle2D[this.drawLabels];
            this.cos = new Point2D.Double[this.drawLabels][4];
            this.draw = this.properties.getLabelEveryNTickMarks();
            this.draw = this.draw > 1 ? this.draw : 1;
            int n = 0;
            while (n < this.drawLabels) {
                this.IsLabelFontAutomaticOrientation[n] = new GeneralPath();
                this.drawTickMark[n] = new Rectangle();
                ++n;
            }
            double d = this.formatAngle(this.closePath.getRotation());
            this.closePath.setRotation(d);
            if (d != 0.0 && this.closePath.getWordWrapper()) {
                this.closePath.setWordWrapper(false);
                this.properties.getLabelTextStyle().setWordWrapper(false);
            }
        }
    }

    public void locate() {
        if (this.properties.isShowTickMarkLabels() && this.atan != 0) {
            this.IsLabelFontAutomaticOrientation();
        }
    }

    public Dimension getMaxDimensionOfLabelsFor3D() {
        this.draw();
        this.clone(this.closePath);
        Dimension dimension = new Dimension();
        if (this.paintingLabels != null) {
            if (this.closePath.getWordWrapper() && this.QOIV > 0) {
                this.closePath.setWordWrap(this.QOIV);
            }
            float[] fArray2 = this.calculateAxisOffset();
            dimension.width = (int)fArray2[0];
            dimension.height = (int)fArray2[1];
        }
        return dimension;
    }

    public Dimension getMaxDimensionOfLabels() {
        this.draw();
        this.clone(this.closePath);
        Dimension dimension = new Dimension();
        if (this.paintingLabels != null) {
            if (this.properties.getLabelPosition() == 1) {
                dimension.width = 0;
                dimension.height = 0;
                return dimension;
            }
            if (this.closePath.getWordWrapper() && this.QOIV > 0) {
                this.closePath.setWordWrap(this.QOIV);
            }
            float[] fArray2 = this.calculateAxisOffset();
            dimension.width = (int)fArray2[0];
            dimension.height = (int)fArray2[1];
        }
        return dimension;
    }

    public double getAxisFristLabelWidht() {
        double d = this.closePath.getDimension(this.paintingLabels[0].getLabelText()).getWidth();
        return d;
    }

    public double getAxisLastLabelWidht() {
        if (this.paintingLabels == null || this.paintingLabels.length == 1) {
            return 0.0;
        }
        double d = this.closePath.getDimension(this.paintingLabels[this.paintingLabels.length - 1].getLabelText()).getWidth();
        return d;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.atan == 0) {
            return;
        }
        this.locate();
        this.drawAxis(graphics2D, this.axisPoint);
        if (this.properties.isShowTickMarkLabels()) {
            this.drawLabels(graphics2D);
        }
        if (this.properties.getTickMarkType() != 0) {
            this.drawTickMark(graphics2D, this.properties.getTickMarkPen(), this.majorTickMarkPoint, this.properties.getTickMarkLength(), this.properties.getTickMarkType(), this.numOfTicks);
        }
        if (this.properties.getMinorTickMarkType() != 0) {
            this.drawTickMark(graphics2D, this.properties.getTickMarkPen(), this.D, this.properties.getMinorTickMarkLength(), this.properties.getMinorTickMarkType(), this.numOfTicks - 1);
        }
    }

    protected void drawAxis(Graphics2D graphics2D, float[][] fArray2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
        generalPath.lineTo(fArray2[1][0], fArray2[1][1]);
        this.properties.getAxisPen().draw(graphics2D, generalPath);
        this.calculateAxisOffset.setLine(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
        if (!(this instanceof ChartCategoryAxis) && this.IsShowLabelTips != 0) {
            double d = this.axisPoint(fArray2[1][1] - fArray2[0][1], fArray2[1][0] - fArray2[0][0]);
            ChartAxisArrowStyle chartAxisArrowStyle = new ChartAxisArrowStyle(this.IsShowLabelTips);
            chartAxisArrowStyle.draw(graphics2D, (int)fArray2[1][0], (int)fArray2[1][1], d -= 1.5707963267948966);
        }
    }

    protected void drawTickMark(Graphics2D graphics2D, ChartPenStyle chartPenStyle, float[][] fArray2, float f, int n, int n2) {
        if (fArray2 == null || fArray2.length == 0) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float[] fArray3 = new float[2];
        float f6 = this.closePath();
        f6 = (float)((double)f6 + 1.5707963267948966);
        f6 = (float)((double)f6 - ((double)f6 > Math.PI * 2 ? Math.PI * 2 : 0.0));
        float f7 = (float)Math.cos(f6);
        float f8 = (float)Math.sin(f6);
        int n3 = 0;
        while (n3 < n2) {
            fArray3[0] = fArray2[n3][0];
            fArray3[1] = fArray2[n3][1];
            generalPath.reset();
            switch (n) {
                case 1: {
                    f2 = fArray3[0] + (float)Math.round(f7 * f);
                    f3 = fArray3[1] - (float)Math.round(f8 * f);
                    generalPath.moveTo(f2, f3);
                    generalPath.lineTo(fArray3[0], fArray3[1]);
                    break;
                }
                case 2: {
                    f2 = fArray3[0] - (float)Math.round(f7 * f);
                    f3 = fArray3[1] + (float)Math.round(f8 * f);
                    generalPath.moveTo(f2, f3);
                    generalPath.lineTo(fArray3[0], fArray3[1]);
                    break;
                }
                case 3: {
                    f2 = fArray3[0] - (float)Math.round(f7 * (f + 1.0f) / 2.0f);
                    f3 = fArray3[1] + (float)Math.round(f8 * (f + 1.0f) / 2.0f);
                    f4 = fArray3[0] + (float)Math.round(f7 * (f + 1.0f) / 2.0f);
                    f5 = fArray3[1] - (float)Math.round(f8 * (f + 1.0f) / 2.0f);
                    generalPath.moveTo(f2, f3);
                    generalPath.lineTo(f4, f5);
                    break;
                }
                case 0: {
                    break;
                }
            }
            chartPenStyle.draw(graphics2D, generalPath);
            ++n3;
        }
    }

    private boolean D(int n, int n2, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2) {
        double d = doubleArray[2].x;
        double d2 = doubleArray[3].x;
        double d3 = doubleArray2[0].x;
        double d4 = doubleArray2[1].x;
        double d5 = doubleArray[2].y;
        double d6 = doubleArray[3].y;
        double d7 = doubleArray2[0].y;
        double d8 = doubleArray2[1].y;
        if (d7 == d5 || d8 == d5) {
            return false;
        }
        double d9 = (d3 - d) / (d7 - d5);
        double d10 = (d4 - d2) / (d8 - d6);
        if (d9 == d10) {
            return true;
        }
        double d11 = (d5 - d6 + (d10 = 1.0 / d10) * d2 - (d9 = 1.0 / d9) * d) / (d10 - d9);
        double d12 = (d - d2 + d10 * d6 - d9 * d5) / (d10 - d9);
        return this.IsLabelFontAutomaticOrientation[n].contains(d11, d12) || this.IsLabelFontAutomaticOrientation[n2].contains(d11, d12);
    }

    protected void drawLabels(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.drawAxis) {
            if (this.paintingLabels[n2] != null) {
                if (this.properties.isBestEffort()) {
                    boolean bl = false;
                    boolean bl2 = bl = n2 > 0 && this.D(n, n2, this.cos[n], this.cos[n2]);
                    if (!bl) {
                        n = n2;
                        this.F(graphics2D, n2);
                    }
                } else {
                    this.F(graphics2D, n2);
                }
            }
            n2 += this.draw;
        }
    }

    private void F(Graphics2D graphics2D, int n) {
        this.paintingLabels[n].locate();
        if (this.properties.getLabelTextStyle().getRotation() % Math.PI * 2.0 == 0.0 && !this.properties.getLabelTextStyle().getWordWrapper()) {
            this.paintingLabels[n].paintTextNoRotation(graphics2D, this.F[n][0], this.F[n][1]);
        } else {
            this.paintingLabels[n].paint(graphics2D, this.F[n][0], this.F[n][1]);
        }
    }

    private void IsLabelFontAutomaticOrientation() {
        float f;
        ChartNumericAxisProperties chartNumericAxisProperties;
        float f2 = this.closePath();
        this.abs = f2;
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        int n = this.properties.getNumOfLabels();
        this.drawAxis = this.drawLabels;
        n = n > this.drawAxis ? this.drawAxis : n;
        int n2 = this.drawAxis = n > -1 ? n : this.drawAxis;
        if (this instanceof ChartNumericAxis && (chartNumericAxisProperties = (ChartNumericAxisProperties)this.properties).getNumOfTickMarks() > 0) {
            this.numOfTicks = chartNumericAxisProperties.getNumOfTickMarks() + 1;
            this.numOfTicks = this.numOfTicks > this.drawLabels ? this.drawLabels : this.numOfTicks;
            this.drawAxis = this.drawAxis > this.numOfTicks ? this.numOfTicks : this.drawAxis;
        }
        float f5 = 0.0f;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.drawLabels) {
            if (this.paintingLabels[n6] != null) {
                n4 = this.paintingLabels[n6].getLabelText().length();
                n5 = n3 > n4 ? n5 : n6;
                n3 = n3 > n4 ? n3 : n4;
            }
            n6 += this.draw;
        }
        f5 = f = (float)this.closePath.getDimension(this.paintingLabels[n5].getLabelText()).getHeight();
        int n7 = 0;
        while (n7 < this.drawAxis) {
            if (this.paintingLabels[n7] != null) {
                this.IsShowLabelTips(this.paintingLabels[n7], this.labelPoint[n7], f3, f4, n7, f5);
            }
            n7 += this.draw;
        }
    }

    private void IsShowLabelTips(ChartLabelBase chartLabelBase, float[] fArray2, float f, float f2, int n, float f3) {
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float[] fArray3 = new float[2];
        float f7 = 0.0f;
        float f8 = this.properties.getLabelAxisGap();
        switch (this.properties.getTickMarkType()) {
            case 1: {
                f7 = this.properties.getTickMarkLength();
                break;
            }
            case 2: {
                f7 = 0.0f;
                break;
            }
            case 3: {
                f7 = this.properties.getTickMarkLength() / 2.0f;
                break;
            }
        }
        double d = this.closePath.getRotation();
        d = this.formatAngle(d);
        Rectangle2D.Float float_ = (Rectangle2D.Float)this.closePath.getDimension(chartLabelBase.getLabelText());
        float f9 = this.closePath.getShearing();
        if (f9 != 0.0f) {
            this.closePath.setRotation(0.0);
            float f10 = float_.width;
            this.closePath.setShearing(0.0f);
            chartLabelBase.setChartTextStyle(this.closePath);
            this.clone = f10 - (float)this.closePath.getDimension(chartLabelBase.getLabelText()).getWidth();
            this.closePath.setShearing(f9);
            if (d != 0.0 && d % 1.5707963267948966 == 0.0) {
                d -= Math.PI / 360;
            }
            this.closePath.setRotation(d);
            chartLabelBase.setChartTextStyle(this.closePath);
        }
        switch (this.properties.getLabelPosition()) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isDepth) break;
                this.calculateAxisOffset(chartLabelBase);
                break;
            }
        }
        if (d != 0.0) {
            fArray3 = this.QOIV(fArray2, f5, f6, f4, d, f2, f, f7, chartLabelBase.getLabelText(), float_);
            f5 = fArray3[0] + this.formatAngle;
            f6 = fArray3[1] - this.getAxisPen;
        } else {
            f4 = (f2 + 1.0f) / 2.0f * float_.width + f2 * f7;
            f5 = fArray2[0] - (float)Math.round(f2 * f8) - f4 + this.formatAngle;
            f6 = fArray2[1] - f * f8 - f * f7 - this.getAxisPen;
            f6 = !this.properties.getLabelTextStyle().getWordWrapper() ? (f6 -= (f - 1.0f) / 2.0f * f3) : (f6 -= (f + 1.0f) / 2.0f * float_.height);
        }
        if (d > 0.0) {
            fArray3 = this.contains(d, f5, f6, float_.width, float_.height);
            f5 = fArray3[0];
            f6 = fArray3[1];
        }
        this.cos(n, f5, f6, chartLabelBase, float_);
        this.F[n][0] = (int)f5;
        this.F[n][1] = (int)f6;
    }

    private float[] QOIV(float[] fArray2, float f, float f2, float f3, double d, float f4, float f5, float f6, String string, Rectangle2D.Float float_) {
        float f7 = this.properties.getLabelAxisGap();
        float[] fArray3 = new float[2];
        boolean bl = false;
        boolean bl2 = false;
        double d2 = Math.PI;
        float f8 = Math.cos(d) == 0.0 ? 0.0f : (float)(Math.cos(d) / Math.abs(Math.cos(d)));
        float f9 = Math.sin(d) == 0.0 ? 0.0f : (float)(Math.sin(d) / Math.abs(Math.sin(d)));
        boolean bl3 = bl = d % d2 == 0.0;
        boolean bl4 = bl ? false : (bl2 = d % (d2 / 2.0) == 0.0);
        if (bl) {
            f3 = (f4 - 1.0f) * (float_.width / 2.0f) + f4 * f6;
            f2 = fArray2[1] - (float)Math.round(f5 * (f7 + f6)) + float_.height * (f5 - 1.0f) / 2.0f;
        } else if (bl2) {
            f3 = f4 * f6 + f9 * (f4 * f9 + 1.0f) / 4.0f * float_.width;
            f2 = fArray2[1] - (float)Math.round(f5 * (f7 + f6)) + f9 * float_.height * (f5 - 1.0f) / 2.0f - f5 * (f9 + 1.0f) / 2.0f * float_.height;
        } else {
            f3 = f4 * f6;
            f2 = fArray2[1] - (float)Math.round(f5 * (f7 + f6));
        }
        d += this.abs;
        d = this.formatAngle(d);
        f = fArray2[0] - (float)Math.round(f4 * f7) - f3;
        if (d < d2) {
            if (!bl && !bl2) {
                f -= f8 * float_.width;
                f2 -= f9 * float_.height;
            }
            if (this.closePath.getShearing() != 0.0f) {
                float[] fArray4 = this.abs(f, f2, float_.width, float_.height, d, this.abs);
                f = fArray4[0];
                f2 = fArray4[1];
            }
        }
        fArray3[0] = f;
        fArray3[1] = f2;
        return fArray3;
    }

    private float[] abs(float f, float f2, float f3, float f4, double d, double d2) {
        float[] fArray2 = new float[2];
        double d3 = Math.PI;
        float f5 = (float)Math.cos(d2);
        float f6 = (float)Math.sin(d2);
        float f7 = this.closePath.getShearing();
        if (d <= 0.5 * d3) {
            f = f7 > 0.0f ? (f -= (f5 + 1.0f - f6 * 2.0f) * f3 - f5 * this.clone / 2.0f) : (f += (f5 - 1.0f + f6) * f3 - f5 * this.clone / 2.0f);
        } else if (f7 > 0.0f) {
            f -= (f5 - 1.0f + f6) * f3 - f5 * this.clone / 2.0f;
            f2 += f6 * f4;
        } else {
            f -= (f5 + 1.0f - f6 * 2.0f) * f3 - f5 * this.clone / 2.0f;
            f2 += f6 * f4;
        }
        fArray2[0] = f;
        fArray2[1] = f2;
        return fArray2;
    }

    public double formatAngle(double d) {
        d = d < 0.0 ? Math.PI * 2 + d % (Math.PI * 2) : d % (Math.PI * 2);
        return d;
    }

    private float axisPoint(double d, double d2) {
        float f = 0.0f;
        float f2 = (float)Math.PI;
        d *= -1.0;
        if (d2 == 0.0) {
            f = d > 0.0 ? f2 / 2.0f : f2 * 3.0f / 2.0f;
        } else {
            f = (float)Math.atan(d / d2);
            f = d2 > 0.0 ? (d >= 0.0 ? f : f2 * 2.0f + f) : (f += f2);
        }
        return f;
    }

    private float[] calculateAxisOffset() {
        float[] fArray2 = new float[3];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.drawLabels) {
            n2 = this.paintingLabels[n4].getLabelText().length();
            n3 = n > n2 ? n3 : n4;
            n = n > n2 ? n : n2;
            ++n4;
        }
        Rectangle2D.Float float_ = (Rectangle2D.Float)this.closePath.getDimension(this.paintingLabels[n3].getLabelText());
        fArray2[0] = float_.width;
        fArray2[1] = float_.height;
        fArray2[2] = n3;
        return fArray2;
    }

    private void clone(ChartTextStyle chartTextStyle) {
        int n = 0;
        while (n < this.drawLabels) {
            this.paintingLabels[n].setChartTextStyle(chartTextStyle);
            ++n;
        }
    }

    private float closePath() {
        float f = this.axisPoint(this.axisPoint[1][1] - this.axisPoint[0][1], this.axisPoint[1][0] - this.axisPoint[0][0]);
        if (this.atan != 0) {
            switch (this.atan) {
                case 1: {
                    f = 0.0f;
                    break;
                }
                case 2: {
                    f = 1.5707964f;
                    break;
                }
                case 3: {
                    f = (float)Math.PI;
                    break;
                }
                case 4: {
                    f = 4.712389f;
                    break;
                }
            }
        }
        return f;
    }

    private float[] contains(double d, float f, float f2, float f3, float f4) {
        double d2 = Math.PI;
        if (d > d2 / 2.0 && d <= d2) {
            f -= f3;
        } else if (d > d2 && d <= d2 * 1.5) {
            f -= f3;
            f2 -= f4;
        } else if (d > d2 * 1.5 && d < d2 * 2.0) {
            f2 -= f4;
        }
        float[] fArray2 = new float[]{f, f2};
        return fArray2;
    }

    private void cos(int n, float f, float f2, ChartLabelBase chartLabelBase, Rectangle2D.Float float_) {
        double d = this.closePath.getRotation();
        ChartTextStyle chartTextStyle = chartLabelBase.getChartTextStyle();
        if (chartTextStyle.getWordWrapper()) {
            double d2 = chartTextStyle.getWordWrapFristLineHeight();
            this.cos[n][0] = new Point2D.Double(f, (double)(f2 + float_.height) - d2);
            this.cos[n][1] = new Point2D.Double(f + float_.width, (double)(f2 + float_.height) - d2);
            this.cos[n][2] = new Point2D.Double(f + float_.width, (double)f2 - d2);
            this.cos[n][3] = new Point2D.Double(f, (double)f2 - d2);
        } else if (d == 0.0) {
            this.cos[n][0] = new Point2D.Double(f, f2);
            this.cos[n][1] = new Point2D.Double(f + float_.width, f2);
            this.cos[n][2] = new Point2D.Double(f + float_.width, f2 - float_.height);
            this.cos[n][3] = new Point2D.Double(f, f2 - float_.height);
        } else if (d == 1.5707963267948966) {
            this.cos[n][0] = new Point2D.Double(f, f2);
            this.cos[n][1] = new Point2D.Double(f + float_.width, f2);
            this.cos[n][2] = new Point2D.Double(f + float_.width, f2 + float_.height);
            this.cos[n][3] = new Point2D.Double(f, f2 + float_.height);
        } else if (d == Math.PI) {
            this.cos[n][0] = new Point2D.Double(f, f2);
            this.cos[n][1] = new Point2D.Double(f + float_.width, f2);
            this.cos[n][2] = new Point2D.Double(f + float_.width, f2 + float_.height);
            this.cos[n][3] = new Point2D.Double(f, f2 + float_.height);
        } else {
            ChartTextStyle chartTextStyle2 = (ChartTextStyle)chartTextStyle.clone();
            chartTextStyle2.setRotation(0.0);
            Rectangle2D.Float float_2 = (Rectangle2D.Float)chartTextStyle2.getDimension(chartLabelBase.getLabelText());
            float f3 = float_2.height;
            double d3 = Math.cos(d);
            double d4 = Math.sin(d);
            double d5 = Math.abs(Math.tan(d));
            if (d > 1.5707963267948966) {
                this.cos[n][0] = new Point2D.Double(f, f2);
                this.cos[n][1] = new Point2D.Double((double)f + (double)f3 * d4, (double)f2 - (double)f3 * d3);
                this.cos[n][2] = new Point2D.Double((double)f + (double)f3 * d4 + (double)float_.width, (double)f2 - (double)f3 * d3 + (double)float_.height);
                this.cos[n][3] = new Point2D.Double(f + float_.width, f2 + float_.height);
            } else if (-1.5707963267948966 <= d && d < 0.0) {
                this.cos[n][0] = new Point2D.Double(f, (double)(f2 + float_.height) - (double)f3 * d3);
                this.cos[n][1] = new Point2D.Double((double)f - (double)f3 * d4, f2 + float_.height);
                this.cos[n][2] = new Point2D.Double(f + float_.width, (double)f2 + (double)f3 * d3);
                this.cos[n][3] = new Point2D.Double((double)(f + float_.width) + (double)f3 * d4, f2);
            } else if (1.5707963267948966 > d && d > 0.0) {
                this.cos[n][0] = new Point2D.Double((double)f + d4 * (double)f3, f2);
                this.cos[n][1] = new Point2D.Double(f + float_.width, (double)(f2 + float_.height) - d3 * (double)f3);
                this.cos[n][2] = new Point2D.Double((double)f - d4 * (double)f3 + (double)float_.width, f2 + float_.height);
                this.cos[n][3] = new Point2D.Double(f, (double)f2 + (double)f3 * d3);
            } else if (-1.5707963267948966 > d) {
                this.cos[n][0] = new Point2D.Double(f, f2);
                this.cos[n][1] = new Point2D.Double((double)f - d4 * (double)f3, (double)f2 + (double)f3 * d3);
                this.cos[n][2] = new Point2D.Double(f + float_.width, f2 + float_.height);
                this.cos[n][3] = new Point2D.Double((double)(f + float_.width) + d4 * (double)f3, (double)(f2 + float_.height) - d3 * (double)f3);
            }
        }
        this.IsLabelFontAutomaticOrientation[n].reset();
        this.IsLabelFontAutomaticOrientation[n].moveTo((float)this.cos[n][0].x, (float)this.cos[n][0].y);
        this.IsLabelFontAutomaticOrientation[n].lineTo((float)this.cos[n][1].x, (float)this.cos[n][1].y);
        this.IsLabelFontAutomaticOrientation[n].lineTo((float)this.cos[n][2].x, (float)this.cos[n][2].y);
        this.IsLabelFontAutomaticOrientation[n].lineTo((float)this.cos[n][3].x, (float)this.cos[n][3].y);
        this.IsLabelFontAutomaticOrientation[n].closePath();
        this.drawTickMark[n] = new Rectangle2D.Double(f, f2, this.cos[n][1].x - this.cos[n][0].x, this.cos[n][3].y - this.cos[n][0].y);
    }

    public String[] getLabels() {
        if (this.paintingLabels == null) {
            return null;
        }
        String[] stringArray = new String[this.drawLabels];
        int n = 0;
        while (n < this.drawLabels) {
            stringArray[n] = this.paintingLabels[n].getLabelText();
            ++n;
        }
        return stringArray;
    }

    private void draw() {
        this.closePath = this.properties.getLabelTextStyle();
    }

    public ChartAxisProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ChartAxisProperties chartAxisProperties) {
        this.properties = chartAxisProperties;
    }

    public ChartDataFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ChartDataFilter chartDataFilter) {
        this.filter = chartDataFilter;
    }

    public void setAxisPoint(float[][] fArray2) {
        this.axisPoint = fArray2;
    }

    public void setMajorTickMarkPoint(float[][] fArray2) {
        this.majorTickMarkPoint = fArray2;
        this.numOfTicks = this.majorTickMarkPoint.length;
    }

    public void setMinorTickMarkPoint(float[][] fArray2) {
        this.D = fArray2;
    }

    public void setLabelPoint(float[][] fArray2) {
        this.labelPoint = fArray2;
    }

    public void setAxisPosition(int n) {
        this.atan = n;
    }

    public Shape[] getAxisShapes() {
        return this.IsLabelFontAutomaticOrientation;
    }

    public String searchAxisLabel(int n, int n2) {
        if (this.IsLabelFontAutomaticOrientation != null) {
            int n3 = 0;
            while (n3 < this.IsLabelFontAutomaticOrientation.length) {
                if (this.IsLabelFontAutomaticOrientation[n3].contains(n, n2) && this.paintingLabels[n3] != null) {
                    return this.paintingLabels[n3].getLabelText();
                }
                ++n3;
            }
        }
        return null;
    }

    public void setRadarArrowStyle(int n) {
        this.IsShowLabelTips = n;
    }

    public void setUnitWidth(int n) {
        this.QOIV = n = n > 2 ? n - 2 : n;
    }

    public Shape getShapeBySeries(int n) {
        return null;
    }

    public int[] search(int n, int n2) {
        return null;
    }

    public Shape getShapeByItem(int n, int n2) {
        return null;
    }

    public int getAxisWithTickLength() {
        float f;
        float f2 = this.properties.getTickMarkLength();
        float f3 = f2 > (f = this.properties.getMinorTickMarkLength()) ? f2 : f;
        f3 = f3 > 0.0f ? f3 : 0.0f;
        return (int)(this.properties.getLabelAxisGap() + f3);
    }

    public float[][] getLabelsPosition() {
        return null;
    }

    public float getZeroPosition(float f) {
        return 0.0f;
    }

    public float getUnit(float f) {
        return 0.0f;
    }

    public Line2D getAxisAreaPath() {
        return this.calculateAxisOffset;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public boolean searchSelectedAxis(int n, int n2) {
        if (this.calculateAxisOffset != null) {
            return this.calculateAxisOffset.intersects(n - 5, n2 - 5, 10.0, 10.0);
        }
        return false;
    }

    public boolean isShow() {
        return this.contains;
    }

    public void setShow(boolean bl) {
        this.contains = bl;
    }

    public ChartTextStyle getLabelsTextStyle() {
        return this.closePath;
    }

    public boolean getAutoOritention(float f) {
        if (this.properties.IsLabelFontAutomaticOrientation()) {
            boolean bl = false;
            float[] fArray2 = new float[this.drawLabels];
            int n = 0;
            while (n < this.drawLabels) {
                Rectangle2D.Float float_ = (Rectangle2D.Float)this.closePath.getZeroRotationDimension(this.paintingLabels[n].getLabelText());
                fArray2[n] = float_.width;
                if (fArray2[n] > f) {
                    bl = true;
                    break;
                }
                ++n;
            }
            return bl;
        }
        return false;
    }

    public boolean IsShowLabelTips() {
        return this.properties.IsShowLabelTips();
    }

    public void calculateAxisOffset(ChartLabelBase chartLabelBase) {
        double d = this.closePath.getRotation();
        float f = this.properties.getLabelAxisGap();
        float f2 = this.properties.getTickMarkLength();
        Rectangle2D.Float float_ = (Rectangle2D.Float)this.closePath.getDimension(chartLabelBase.getLabelText());
        switch (this.atan) {
            case 3: {
                if (d < 0.0) {
                    this.formatAngle = float_.width;
                    this.getAxisPen = float_.height + f2 + f;
                    break;
                }
                if (d > 0.0) {
                    this.formatAngle = -float_.width;
                    this.getAxisPen = float_.height + f2 + f;
                    break;
                }
                this.getAxisPen = float_.height + f2 + f * 3.0f;
                break;
            }
            case 1: {
                if (d < 0.0) {
                    this.formatAngle = -float_.width;
                    this.getAxisPen = -float_.height - f2 - f * 3.0f;
                    break;
                }
                if (d > 0.0) {
                    this.formatAngle = float_.width;
                    this.getAxisPen = -float_.height - f2 - f * 3.0f;
                    break;
                }
                this.getAxisPen = -float_.height - f2 - f * 3.0f;
                break;
            }
            case 2: {
                if (d < 0.0) {
                    this.getAxisPen = float_.height;
                    this.formatAngle = float_.width + f2 + f;
                    break;
                }
                if (d > 0.0) {
                    this.getAxisPen = -float_.height;
                    this.formatAngle = float_.width + f2 + f;
                    break;
                }
                this.formatAngle = float_.width + f2 + f * 3.0f;
                break;
            }
            case 4: {
                if (d < 0.0) {
                    this.getAxisPen = -float_.height;
                    this.formatAngle = -float_.width - f2 - f;
                    break;
                }
                if (d > 0.0) {
                    this.getAxisPen = float_.height;
                    this.formatAngle = -float_.width - f2 - f;
                    break;
                }
                this.formatAngle = -float_.width - f2 - f * 3.0f;
                break;
            }
        }
    }

    public boolean isDepth() {
        return this.isDepth;
    }

    public void setDepth(boolean bl) {
        this.isDepth = bl;
    }
}

