/*
 * Decompiled with CFR 0.152.
 */
package chart.axis;

import chart.ChartLabelBase;
import chart.axis.ChartAxis;
import chart.axis.ChartNumericRadarAxis;
import chart.properties.ChartAxisProperties;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartMath;
import java.awt.Graphics2D;
import java.text.DecimalFormat;

public class ChartNumericAxis
extends ChartAxis {
    private double QOIV;
    private double abs;
    private double ceil;
    private int floor;
    private float format;
    private boolean getAxisIncrement;
    private double getFilters;
    private double getLabelStartValue;
    private boolean getLabelTextStyle;
    private boolean getMax;
    private boolean getMaxValue = false;
    private boolean getMin = false;
    private boolean getMinValue = false;
    private boolean[] getNumOfTickMarks;
    private float getUnit;

    public ChartNumericAxis(ChartAxisProperties chartAxisProperties, double d, double d2) {
        super(chartAxisProperties);
        this.QOIV = d;
        this.abs = d2;
    }

    public void init() {
        this.QOIV();
        this.filter();
        super.init();
    }

    private void QOIV() {
        ChartNumericAxisProperties chartNumericAxisProperties = (ChartNumericAxisProperties)this.properties;
        this.format = (float)chartNumericAxisProperties.getLabelStartValue();
        this.getAxisIncrement = chartNumericAxisProperties.isUseLabelStartValue();
        this.getFilters = chartNumericAxisProperties.getMinValue();
        this.getLabelStartValue = chartNumericAxisProperties.getMaxValue();
        if (this.getFilters > this.getLabelStartValue) {
            this.getLabelStartValue = chartNumericAxisProperties.getMinValue();
            this.getFilters = chartNumericAxisProperties.getMaxValue();
        }
        this.getLabelTextStyle = this.getFilters == 0.0;
        this.getMax = this.getLabelStartValue == 0.0;
        this.ceil = chartNumericAxisProperties.getAxisIncrement();
        this.floor = chartNumericAxisProperties.getNumOfTickMarks();
        if (this.filter != null && this.filter.isLogScale()) {
            this.ceil = 1.0;
            this.floor = -1;
            this.getFilters = this.getFilters > 0.0 ? ChartMath.log10(this.getFilters) : 0.0;
            double d = this.getLabelStartValue = this.getLabelStartValue > 0.0 ? ChartMath.log10(this.getLabelStartValue) : 0.0;
        }
        this.abs = this.getMax ? (this.abs < 0.0 ? 0.0 : this.abs) : this.getLabelStartValue;
        this.QOIV = this.getLabelTextStyle ? (this.QOIV > 0.0 ? 0.0 : this.QOIV) : this.getFilters;
        if (Math.abs(this.abs - this.QOIV) < Double.MIN_VALUE) {
            if (Math.abs(this.QOIV) < Double.MIN_VALUE) {
                this.abs = this.QOIV + 100.0;
            } else {
                this.abs = Math.max(0.0, this.QOIV);
                this.QOIV = Math.min(0.0, this.QOIV);
            }
            this.getMax = true;
            this.getLabelTextStyle = true;
        }
        if (this.floor <= 0) {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            if (this.ceil <= 0.0 || this.ceil > this.abs - this.QOIV) {
                this.ceil = this.abs(this.QOIV, this.abs);
                bl = true;
            }
            if (this.QOIV < 0.0 && this.abs > 0.0) {
                double d;
                if (this.getLabelTextStyle) {
                    n = (int)Math.ceil(-this.QOIV / this.ceil);
                    if (this.getMaxValue && ((d = -this.QOIV % this.ceil) > this.ceil * 9.0 / 10.0 || d == 0.0 || this.getMin)) {
                        ++n;
                    }
                } else {
                    n = (int)Math.floor(-this.QOIV / this.ceil);
                    if (-this.QOIV / this.ceil % 1.0 > 0.99999) {
                        ++n;
                    }
                }
                this.QOIV = -this.ceil * (double)n;
                if (this.getMax) {
                    n2 = (int)Math.ceil(this.abs / this.ceil);
                    if (this.getMaxValue && ((d = this.abs % this.ceil) > this.ceil * 9.0 / 10.0 || d == 0.0 || this.getMin)) {
                        ++n2;
                    }
                } else {
                    n2 = (int)Math.floor(this.abs / this.ceil);
                    if (this.abs / this.ceil % 1.0 > 0.99999) {
                        ++n2;
                    }
                }
                this.abs = this.ceil * (double)n2;
                this.floor = n + n2;
            } else if (this.abs <= 0.0) {
                if (this.getLabelTextStyle) {
                    double d;
                    this.floor = (int)Math.ceil((this.abs - this.QOIV) / this.ceil);
                    if (this.getMaxValue && ((d = (this.abs - this.QOIV) % this.ceil) > this.ceil * 9.0 / 10.0 || d == 0.0 || this.getMin)) {
                        ++this.floor;
                    }
                } else {
                    this.floor = (int)Math.floor((this.abs - this.QOIV) / this.ceil);
                    if ((this.abs - this.QOIV) / this.ceil % 1.0 > 0.99999) {
                        ++this.floor;
                    }
                }
                if (this instanceof ChartNumericRadarAxis) {
                    this.floor -= this.floor / 2;
                }
                this.QOIV = this.abs - this.ceil * (double)this.floor;
                if (this.getLabelTextStyle && this.getMin) {
                    this.abs += this.ceil;
                    ++this.floor;
                }
            } else if (this.QOIV >= 0.0) {
                if (this.getMax) {
                    double d;
                    this.floor = (int)Math.ceil((this.abs - this.QOIV) / this.ceil);
                    if (this.getMaxValue && ((d = (this.abs - this.QOIV) % this.ceil) > this.ceil * 9.0 / 10.0 || d == 0.0 || this.getMin)) {
                        ++this.floor;
                    }
                    this.abs = this.QOIV + this.ceil * (double)this.floor;
                    if (this instanceof ChartNumericRadarAxis) {
                        if (this.floor % 2 == 0) {
                            this.floor -= this.floor / 2;
                            this.ceil *= 2.0;
                        } else {
                            this.abs += this.ceil;
                            this.floor = (this.floor + 1) / 2;
                            this.ceil = (this.abs - this.QOIV) / (double)this.floor;
                        }
                    }
                    if (this.getLabelTextStyle && this.getMin) {
                        this.QOIV -= this.ceil;
                        ++this.floor;
                    }
                } else {
                    this.floor = (int)Math.floor((this.abs - this.QOIV) / this.ceil);
                    if (this.floor == 0) {
                        this.floor = 2;
                        this.ceil = this.abs;
                    }
                    if ((this.abs - this.QOIV) / this.ceil % 1.0 > 0.99999) {
                        ++this.floor;
                    }
                    this.abs = this.QOIV + this.ceil * (double)this.floor;
                }
            }
            if (this.getMinValue && this.abs - this.QOIV < 4.0 && this.ceil - 1.0 < Double.MIN_VALUE && bl) {
                if (this.getLabelTextStyle && this.getMax) {
                    this.floor = 4;
                    if (this.getMax) {
                        this.abs = Math.ceil(this.QOIV) + (double)this.floor;
                    } else {
                        this.QOIV = Math.floor(this.abs) - (double)this.floor;
                    }
                } else if (this.abs - this.QOIV > 2.0) {
                    this.floor = (int)Math.floor(this.abs - this.QOIV);
                    this.QOIV = Math.ceil(this.QOIV);
                }
            }
        } else {
            if (this.QOIV < 0.0 && this.abs > 0.0) {
                this.abs = this.getMax ? this.ceil(this.abs, true) : this.abs;
                this.QOIV = this.getLabelTextStyle ? this.ceil(this.QOIV, true) : this.QOIV;
            } else if (this.QOIV >= 0.0) {
                this.abs = this.getMax ? this.ceil(this.abs, true) : this.abs;
                this.QOIV = this.getLabelTextStyle ? this.ceil(this.QOIV, false) : this.QOIV;
            } else if (this.abs <= 0.0) {
                this.abs = this.getMax ? this.ceil(this.abs, false) : this.abs;
                this.QOIV = this.getLabelTextStyle ? this.ceil(this.QOIV, true) : this.QOIV;
            }
            this.ceil = (this.abs - this.QOIV) / (double)this.floor;
        }
    }

    /*
     * Unable to fully structure code
     */
    private double abs(double var1_1, double var3_2) {
        block11: {
            var5_3 = 1.0;
            var7_4 = 2.0;
            var9_5 = 5.0;
            var11_6 = var3_2 - var1_1;
            if (Math.abs(var11_6) < 4.9E-324) {
                var11_6 = 100.0;
            }
            if (!(var11_6 > 5.0)) ** GOTO lbl22
            while (var11_6 >= var5_3 * 8.0) {
                var5_3 *= 10.0;
            }
            while (var11_6 >= var7_4 * 8.0) {
                var7_4 *= 10.0;
            }
            while (var11_6 >= var9_5 * 8.0) {
                var9_5 *= 10.0;
            }
            var13_7 = var5_3;
            var13_7 = var13_7 < var7_4 ? var13_7 : var7_4;
            var13_7 = var13_7 < var9_5 ? var13_7 : var9_5;
            break block11;
lbl-1000:
            // 1 sources

            {
                var5_3 /= 10.0;
lbl22:
                // 2 sources

                ** while (var11_6 <= var5_3 * 3.99999)
            }
lbl23:
            // 2 sources

            while (var11_6 <= var7_4 * 3.99999) {
                var7_4 /= 10.0;
            }
            while (var11_6 <= var9_5 * 3.99999) {
                var9_5 /= 10.0;
            }
            var13_7 = var5_3;
            var13_7 = var13_7 > var7_4 ? var13_7 : var7_4;
            v0 = var13_7 = var13_7 > var9_5 ? var13_7 : var9_5;
        }
        if (this.getMinValue && var3_2 - var1_1 < 4.0) {
            if (this.getLabelTextStyle || this.getMax) {
                var13_7 = 1.0;
            } else if (var3_2 - var1_1 > 2.0) {
                var13_7 = 1.0;
            }
        }
        return var13_7;
    }

    private double ceil(double d, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        if (d < 0.0) {
            d = Math.abs(d);
            bl3 = true;
        }
        boolean bl4 = bl2 = d >= 1.0;
        if (d != 0.0) {
            int n = 0;
            while (!bl2 ? d < 1.0 : d >= 10.0) {
                d *= bl2 ? (double)0.1f : 10.0;
                ++n;
            }
            int n2 = (int)Math.round(d);
            if (d > (double)n2) {
                d = bl ? (double)((float)n2 + 1.0f) : (double)n2;
            } else if (d < (double)n2) {
                d = bl ? (double)n2 : (double)((float)n2 - 1.0f);
            }
            d *= Math.pow(bl2 ? 10.0f : 0.1f, n);
        }
        return bl3 ? -d : d;
    }

    private void filter() {
        if (this.floor >= 100) {
            this.floor = 100;
            this.ceil = (this.abs - this.QOIV) / (double)this.floor;
        }
        if (this.floor == 0) {
            this.paintingLabels = null;
            return;
        }
        ChartNumericAxisProperties chartNumericAxisProperties = (ChartNumericAxisProperties)this.properties;
        this.paintingLabels = new ChartLabelBase[this.floor + 1];
        double d = 0.0;
        this.getNumOfTickMarks = new boolean[2];
        DecimalFormat decimalFormat = new DecimalFormat();
        int n = 0;
        while (n <= this.floor) {
            d = this.QOIV + (double)n * this.ceil;
            String string = this.filter != null && this.filter.getFilters().size() != 0 ? this.filter.filter(new Double(d), n) : String.valueOf(decimalFormat.format(d));
            this.paintingLabels[n] = new ChartLabelBase(string);
            this.paintingLabels[n].setChartTextStyle(chartNumericAxisProperties.getLabelTextStyle());
            if (this.getAxisIncrement && d < (double)this.format) {
                this.paintingLabels[n].setLabelText("");
            }
            if (n == 0) {
                this.getUnit = (float)d;
            }
            if (!this.getLabelTextStyle || !this.getMax) {
                if (n == 0) {
                    boolean bl = this.getNumOfTickMarks[0] = d != this.getFilters;
                }
                if (n == this.floor) {
                    this.getNumOfTickMarks[1] = d != this.getLabelStartValue;
                }
            }
            ++n;
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
    }

    public double getMax() {
        return this.getMax ? this.abs : this.getLabelStartValue;
    }

    public double getMin() {
        return this.getLabelTextStyle ? this.QOIV : this.getFilters;
    }

    public double getLabelStartValue() {
        return this.QOIV;
    }

    public double getTickPace() {
        return this.ceil;
    }

    public int getNumOfTick() {
        return this.floor;
    }

    public float getZeroPosition(float f) {
        float f2 = this.getUnit(f);
        return -((float)this.getMin() * f2);
    }

    public float getUnit(float f) {
        return (float)Math.abs((double)f / (this.getMax() - this.getMin()));
    }

    public boolean isAutoExpand() {
        return this.getMaxValue;
    }

    public void setAutoExpand(boolean bl) {
        this.getMaxValue = bl;
    }

    public float[][] getLabelsPosition() {
        return null;
    }

    public void setIsBubble(boolean bl) {
        this.getMin = bl;
    }

    public boolean[] surfacePatternIncrea() {
        return this.getNumOfTickMarks;
    }

    public float getFristLabel() {
        return this.getUnit;
    }

    public void setIntegerIncrement(boolean bl) {
        this.getMinValue = bl;
    }

    public boolean isIntegerIncrement() {
        return this.getMinValue;
    }

    public void locate() {
        super.locate();
    }

    public boolean contains(int n, int n2) {
        return false;
    }
}

