/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.GridLine;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.Chart3DWalls;
import chart.chart3d.ChartBlock;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.graphics.ChartPenStyle;
import chart.util.ChartRenderTools;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Chart3DAxes {
    protected static int floor = 3;
    protected ChartCategoryAxis axisX;
    protected ChartNumericAxis axisY;
    protected ChartCategoryAxis axisZ;
    protected Chart3DPaper paper;
    protected ChartBlock xTickPos = new ChartBlock();
    protected ChartBlock xLabelPos = new ChartBlock();
    protected ChartBlock yTickPos = new ChartBlock();
    protected ChartBlock zTickPos = new ChartBlock();
    protected ChartBlock zLabelPos = new ChartBlock();
    protected ChartBlock floorFace = new ChartBlock();
    protected ChartBlock originYFace = new ChartBlock();
    protected ChartCompass compass;
    protected int[] type;
    protected float originY;
    protected float[] unit;
    protected float xLen;
    protected float yLen;
    protected float zLen;
    protected int shownFace = 0;
    private boolean QOIV = true;
    private ChartPenStyle addVertex;
    private GeneralPath append = new GeneralPath();
    private GridLine[] availableOriginY;
    private float[][] clear = new float[2][2];
    private GeneralPath[] draw;
    private GeneralPath[] formatMinorTickMark;
    private GeneralPath[] getAngleX;
    private GeneralPath getAngleY;
    private GeneralPath getAxisXProperties;
    private GeneralPath getAxisYProperties;

    public Chart3DAxes(Chart3DPaper chart3DPaper) {
        this.paper = chart3DPaper;
    }

    public void init() {
        this.getAngleY = new GeneralPath();
        this.getAxisXProperties = new GeneralPath();
        this.getAxisYProperties = new GeneralPath();
        this.type = this.paper.getIntType();
        this.axisX = (ChartCategoryAxis)this.paper.I;
        this.axisY = (ChartNumericAxis)this.paper.Z;
        this.axisZ = (ChartCategoryAxis)this.paper.C;
        this.addVertex = new ChartPenStyle();
        this.addVertex.setPenColor(this.paper.getProperties().getFloorProperties().getBorder().getPenColor());
        if (this.type[1] != 768) {
            this.paper.getProperties().setShowAxisZ(false);
        }
    }

    private void QOIV() {
        float[] fArray2 = this.clear[0];
        this.clear[0] = this.clear[1];
        this.clear[1] = fArray2;
    }

    public void paintGridLines(Graphics2D graphics2D) {
        int n;
        int n2;
        this.shownFace = this.paper.getShownFace();
        int n3 = this.append(this.shownFace);
        int n4 = this.xTickPos.vCount / 4;
        this.availableOriginY = new GridLine[n4];
        if (this.paper.getProperties().getAxisXProperties().isShowGrid()) {
            this.draw = new GeneralPath[this.availableOriginY.length];
            this.getAngleY.reset();
            n2 = 0;
            while (n2 < n4) {
                this.draw[n2] = new GeneralPath();
                this.addVertex(graphics2D, n3, n2, 0, false, false, this.paper.getProperties().getAxisXProperties().getGridPen(), this.draw[n2]);
                this.getAngleY.append(this.draw[n2], false);
                ++n2;
            }
        }
        n2 = 0;
        n3 = this.availableOriginY(this.shownFace);
        n4 = this.yTickPos.vCount / 4;
        this.availableOriginY = new GridLine[n4];
        if ((this.shownFace >> 5 & 1) == 1) {
            n2 = 1;
        }
        if (this.paper.getProperties().getAxisYProperties().isShowGrid() && n3 >= 0) {
            this.formatMinorTickMark = new GeneralPath[this.availableOriginY.length];
            this.getAxisXProperties.reset();
            this.clear[0] = this.yTickPos.tVertex[n3];
            this.clear[1] = this.yTickPos.tVertex[n3 + (n4 - 1) * 4];
            if (this.axisY(this.clear[0], this.clear[1])) {
                this.QOIV();
            }
            n = 0;
            while (n < n4) {
                this.formatMinorTickMark[n] = new GeneralPath();
                int n5 = n3;
                if (n5 == 1) {
                    n5 = 3;
                } else if (n5 == 2) {
                    n5 = 0;
                }
                this.addVertex(graphics2D, n5, n, 1, true, n2 != 0, this.paper.getProperties().getAxisYProperties().getGridPen(), this.formatMinorTickMark[n]);
                this.getAxisXProperties.append(this.formatMinorTickMark[n], false);
                ++n;
            }
        }
        n3 = this.axisX(this.shownFace);
        n4 = this.zTickPos.vCount / 4;
        this.availableOriginY = new GridLine[n4];
        if (this.paper.getProperties().getAxisZProperties().isShowGrid()) {
            this.getAxisYProperties.reset();
            this.getAngleX = new GeneralPath[this.availableOriginY.length];
            n = 0;
            while (n < n4) {
                this.getAngleX[n] = new GeneralPath();
                this.addVertex(graphics2D, n3, n, 2, false, false, this.paper.getProperties().getAxisZProperties().getGridPen(), this.getAngleX[n]);
                this.getAxisYProperties.append(this.getAngleX[n], false);
                ++n;
            }
        }
        if (this.QOIV) {
            if ((this.shownFace >> 4 & 1) == 1) {
                this.clear[0] = this.originYFace.tVertex[2];
                this.clear[1] = this.originYFace.tVertex[3];
            } else {
                this.clear[0] = this.originYFace.tVertex[0];
                this.clear[1] = this.originYFace.tVertex[1];
            }
            this.append.reset();
            this.append.moveTo(this.clear[0][0], this.clear[0][1]);
            this.append.lineTo(this.clear[1][0], this.clear[1][1]);
            this.addVertex.draw(graphics2D, this.append);
            if ((this.shownFace >> 0 & 1) == 1) {
                this.clear[0] = this.originYFace.tVertex[1];
                this.clear[1] = this.originYFace.tVertex[2];
            } else {
                this.clear[0] = this.originYFace.tVertex[3];
                this.clear[1] = this.originYFace.tVertex[0];
            }
            this.append.reset();
            this.append.moveTo(this.clear[0][0], this.clear[0][1]);
            this.append.lineTo(this.clear[1][0], this.clear[1][1]);
            this.addVertex.draw(graphics2D, this.append);
        }
    }

    public void paint(Graphics2D graphics2D) {
        float[][] fArray2;
        float[][] fArray3;
        int n;
        ChartBlock chartBlock = this.paper.getWalls().getWalls();
        this.shownFace = this.paper.getShownFace();
        int n2 = this.append(this.shownFace);
        String[] stringArray = this.axisX.getLabels();
        if (this.paper.getProperties().isShowAxisX() && n2 >= 0) {
            this.clear[0] = this.floorFace.tVertex[n2 * 2 + 1];
            this.clear[1] = this.floorFace.tVertex[n2 * 2];
            if (this.type[0] == 1) {
                this.QOIV();
            }
            n = this.xTickPos.vCount / 4;
            fArray3 = new float[n][2];
            int n3 = 0;
            while (n3 < n) {
                fArray3[n3] = this.xTickPos.tVertex[n3 * 4 + n2];
                ++n3;
            }
            n = this.xLabelPos.vCount / 4;
            fArray2 = new float[n][2];
            int n4 = 0;
            while (n4 < n) {
                fArray2[n4] = this.xLabelPos.tVertex[n4 * 4 + n2];
                ++n4;
            }
            this.axisX.setAxisPoint(this.clear);
            this.axisX.setMajorTickMarkPoint(fArray3);
            this.axisX.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(fArray3, this.clear, this.unit[0]));
            this.axisX.setLabelPoint(fArray2);
            this.axisX.paint(graphics2D);
        }
        n2 = this.availableOriginY(this.shownFace);
        if (this.paper.getProperties().isShowAxisY() && n2 >= 0) {
            n = this.yTickPos.vCount / 4;
            fArray3 = new float[n][2];
            Chart3DWalls chart3DWalls = this.paper.getWalls();
            Point2D.Float[][] floatArray = chart3DWalls.I;
            boolean bl = chart3DWalls.I(chartBlock.tVertex[n2][0], chartBlock.tVertex[n2][1], floatArray[0], floatArray[2]);
            boolean bl2 = chart3DWalls.I(chartBlock.tVertex[n2 + 4][0], chartBlock.tVertex[n2 + 4][1], floatArray[0], floatArray[2]);
            this.clear[0] = chartBlock.tVertex[n2];
            this.clear[1] = chartBlock.tVertex[n2 + 4];
            int n5 = 0;
            while (n5 < n) {
                fArray3[n5] = this.yTickPos.tVertex[n5 * 4 + n2];
                ++n5;
            }
            if (!bl || !bl2) {
                int n6;
                if (n2 == 0) {
                    this.clear[0] = chartBlock.tVertex[n2 + 3];
                    this.clear[1] = chartBlock.tVertex[n2 + 7];
                    n6 = 0;
                    while (n6 < n) {
                        fArray3[n6] = this.yTickPos.tVertex[n6 * 4 + n2 + 3];
                        ++n6;
                    }
                } else if (n2 == 3) {
                    this.clear[0] = chartBlock.tVertex[n2 - 3];
                    this.clear[1] = chartBlock.tVertex[n2 + 1];
                    n6 = 0;
                    while (n6 < n) {
                        fArray3[n6] = this.yTickPos.tVertex[n6 * 4 + n2 - 3];
                        ++n6;
                    }
                }
            }
            if (this.axisY(this.clear[0], this.clear[1])) {
                this.QOIV();
            }
            this.axisY.setAxisPoint(this.clear);
            this.axisY.setMajorTickMarkPoint(fArray3);
            this.axisY.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(fArray3, this.clear, this.unit[1]));
            this.axisY.setLabelPoint(fArray3);
            this.axisY.paint(graphics2D);
        }
        n2 = this.axisX(this.shownFace);
        if (this.paper.getProperties().isShowAxisZ() && n2 >= 0) {
            this.clear[0] = this.floorFace.tVertex[n2 * 2];
            this.clear[1] = this.floorFace.tVertex[(n2 * 2 + 3) % 4];
            if (this.type[0] == 1) {
                this.QOIV();
            }
            n = this.zTickPos.vCount / 4;
            fArray3 = new float[n][2];
            int n7 = 0;
            while (n7 < n) {
                fArray3[n7] = this.zTickPos.tVertex[n7 * 4 + n2];
                ++n7;
            }
            n = this.zLabelPos.vCount / 4;
            fArray2 = new float[n][2];
            int n8 = 0;
            while (n8 < n) {
                fArray2[n8] = this.zLabelPos.tVertex[n8 * 4 + n2];
                ++n8;
            }
            this.axisZ.setAxisPoint(this.clear);
            this.axisZ.setMajorTickMarkPoint(fArray3);
            this.axisZ.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(fArray3, this.clear, this.unit[2]));
            this.axisZ.setLabelPoint(fArray2);
            this.axisZ.paint(graphics2D);
        }
        if (this.QOIV) {
            if ((this.shownFace >> 4 & 1) == 1) {
                this.clear[0] = this.originYFace.tVertex[0];
                this.clear[1] = this.originYFace.tVertex[1];
            } else {
                this.clear[0] = this.originYFace.tVertex[2];
                this.clear[1] = this.originYFace.tVertex[3];
            }
            this.append.reset();
            this.append.moveTo(this.clear[0][0], this.clear[0][1]);
            this.append.lineTo(this.clear[1][0], this.clear[1][1]);
            this.addVertex.draw(graphics2D, this.append);
            if ((this.shownFace >> 0 & 1) == 1) {
                this.clear[0] = this.originYFace.tVertex[3];
                this.clear[1] = this.originYFace.tVertex[0];
            } else {
                this.clear[0] = this.originYFace.tVertex[1];
                this.clear[1] = this.originYFace.tVertex[2];
            }
            this.append.reset();
            this.append.moveTo(this.clear[0][0], this.clear[0][1]);
            this.append.lineTo(this.clear[1][0], this.clear[1][1]);
            this.addVertex.draw(graphics2D, this.append);
        }
    }

    private void addVertex(Graphics2D graphics2D, int n, int n2, int n3, boolean bl, boolean bl2, ChartPenStyle chartPenStyle, GeneralPath generalPath) {
        float[][] fArray2 = new float[2][2];
        boolean bl3 = true;
        if (bl && bl2) {
            n = (n + 2) % 4;
        } else if (n < 0) {
            n += 2;
            bl3 = false;
        }
        float[][] fArray3 = null;
        switch (n3) {
            case 0: {
                fArray3 = this.xTickPos.tVertex;
                break;
            }
            case 1: {
                fArray3 = this.yTickPos.tVertex;
                break;
            }
            case 2: {
                fArray3 = this.zTickPos.tVertex;
            }
        }
        this.availableOriginY[n2] = new GridLine();
        int n4 = this.yTickPos.vCount / 4;
        Chart3DWalls chart3DWalls = this.paper.getWalls();
        Point2D.Float[][] floatArray = this.paper.getWalls().I;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl3) {
            fArray2[0] = fArray3[n2 * 4 + n];
            if (n == 0) {
                if (!bl) {
                    fArray2[1] = fArray3[n2 * 4 + n + 1];
                } else {
                    bl4 = chart3DWalls.I(fArray3[0][0], fArray3[0][1], floatArray[0], floatArray[2]);
                    bl5 = chart3DWalls.I(fArray3[3][0], fArray3[3][1], floatArray[0], floatArray[2]);
                    bl6 = chart3DWalls.I(fArray3[(n4 - 1) * 4 + n][0], fArray3[(n4 - 1) * 4 + n][1], floatArray[0], floatArray[2]);
                    bl7 = chart3DWalls.I(fArray3[(n4 - 1) * 4 + n + 3][0], fArray3[(n4 - 1) * 4 + n + 3][1], floatArray[0], floatArray[2]);
                    fArray2[1] = fArray3[n2 * 4 + n + 3];
                    if (!(bl4 && bl5 && bl6 && bl7)) {
                        fArray2[0] = fArray3[n2 * 4 + n + 1];
                        fArray2[1] = fArray3[n2 * 4 + n + 2];
                    }
                }
            } else {
                fArray2[1] = fArray3[n2 * 4 + n - 1];
            }
            this.availableOriginY[n2].setPenStyle(chartPenStyle);
            this.availableOriginY[n2].setLocation(fArray2);
            this.availableOriginY[n2].draw(graphics2D);
            generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
            generalPath.lineTo(fArray2[1][0], fArray2[1][1]);
        }
        if (!bl) {
            if (n == 0) {
                fArray2[0] = fArray3[n2 * 4 + n + 1];
                fArray2[1] = fArray3[n2 * 4 + n + 2];
            } else {
                fArray2[0] = fArray3[n2 * 4 + n - 1];
                fArray2[1] = fArray3[n2 * 4 + n + 2];
            }
        } else if (n == 0) {
            bl4 = chart3DWalls.I(fArray3[2][0], fArray3[2][1], floatArray[0], floatArray[2]);
            bl5 = chart3DWalls.I(fArray3[3][0], fArray3[3][1], floatArray[0], floatArray[2]);
            bl6 = chart3DWalls.I(fArray3[(n4 - 1) * 4 + n + 2][0], fArray3[(n4 - 1) * 4 + n + 2][1], floatArray[0], floatArray[2]);
            bl7 = chart3DWalls.I(fArray3[(n4 - 1) * 4 + n + 3][0], fArray3[(n4 - 1) * 4 + n + 3][1], floatArray[0], floatArray[2]);
            fArray2[0] = fArray3[n2 * 4 + n + 2];
            fArray2[1] = fArray3[n2 * 4 + n + 3];
            if (!(bl4 && bl5 && bl6 && bl7)) {
                fArray2[0] = fArray3[n2 * 4 + n + 1];
                fArray2[1] = fArray3[n2 * 4 + n];
            }
        } else if (n == 1) {
            bl4 = chart3DWalls.I(fArray3[0][0], fArray3[0][1], floatArray[0], floatArray[2]);
            bl5 = chart3DWalls.I(fArray3[3][0], fArray3[3][1], floatArray[0], floatArray[2]);
            bl6 = chart3DWalls.I(fArray3[(n4 - 1) * 4 + n - 1][0], fArray3[(n4 - 1) * 4 + n - 1][1], floatArray[0], floatArray[2]);
            bl7 = chart3DWalls.I(fArray3[(n4 - 1) * 4 + n + 2][0], fArray3[(n4 - 1) * 4 + n + 2][1], floatArray[0], floatArray[2]);
            fArray2[0] = fArray3[n2 * 4 + n - 1];
            fArray2[1] = fArray3[n2 * 4 + n + 2];
            if (!(bl4 && bl5 && bl6 && bl7)) {
                fArray2[0] = fArray3[n2 * 4 + n];
                fArray2[1] = fArray3[n2 * 4 + n + 1];
            }
        } else if (n == 2) {
            fArray2[0] = fArray3[n2 * 4 + n - 2];
            fArray2[1] = fArray3[n2 * 4 + n - 1];
        } else {
            bl4 = chart3DWalls.I(fArray3[2][0], fArray3[2][1], floatArray[0], floatArray[2]);
            bl5 = chart3DWalls.I(fArray3[1][0], fArray3[1][1], floatArray[0], floatArray[2]);
            bl6 = chart3DWalls.I(fArray3[(n4 - 1) * 4 + n - 1][0], fArray3[(n4 - 1) * 4 + n - 1][1], floatArray[0], floatArray[2]);
            bl7 = chart3DWalls.I(fArray3[(n4 - 1) * 4 + n - 2][0], fArray3[(n4 - 1) * 4 + n - 2][1], floatArray[0], floatArray[2]);
            fArray2[0] = fArray3[n2 * 4 + n - 1];
            fArray2[1] = fArray3[n2 * 4 + n - 2];
            if (!(bl4 && bl5 && bl6 && bl7)) {
                fArray2[0] = fArray3[n2 * 4 + n];
                fArray2[1] = fArray3[n2 * 4 + n - 3];
            }
        }
        this.availableOriginY[n2].setPenStyle(chartPenStyle);
        this.availableOriginY[n2].setLocation(fArray2);
        this.availableOriginY[n2].draw(graphics2D);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(fArray2[0][0], fArray2[0][1]);
        generalPath2.lineTo(fArray2[1][0], fArray2[1][1]);
        generalPath.append(generalPath2, false);
    }

    private int append(int n) {
        if ((n >> floor & 1) == 1 || this.paper.properties.getAngleX() % 360.0f == 0.0f) {
            if ((n >> 4 & 1) == 1) {
                return 0;
            }
            return 1;
        }
        if ((n >> 4 & 1) == 1) {
            return -2;
        }
        return -1;
    }

    private int availableOriginY(int n) {
        int n2 = -1;
        if ((n >> 1 & 1) == 1 || this.paper.properties.getAngleX() % 360.0f == 0.0f) {
            if ((n >> 4 & 1) == 1) {
                n2 = this.compass.max(1, 4) == 1 ? 0 : 2;
            } else if ((n >> 5 & 1) == 1) {
                n2 = this.compass.max(1, 5) == 1 ? 3 : 1;
            }
        } else if ((n & 1) == 1) {
            if ((n >> 4 & 1) == 1) {
                n2 = this.compass.max(0, 4) == 0 ? 1 : 3;
            } else if ((n >> 5 & 1) == 1) {
                n2 = this.compass.max(0, 5) == 0 ? 2 : 0;
            }
        }
        return n2;
    }

    private int axisX(int n) {
        if ((n >> floor & 1) == 1 || (this.paper.properties.getAngleY() % 90.0f == 0.0f || this.paper.properties.getAngleY() % 270.0f == 0.0f) && this.paper.properties.getAngleY() % 180.0f != 0.0f && this.paper.properties.getAngleY() % 360.0f != 0.0f) {
            if ((n >> 0 & 1) == 1) {
                return 0;
            }
            return 1;
        }
        if ((n >> 0 & 1) == 1) {
            return -2;
        }
        return -1;
    }

    private boolean axisY(float[] fArray2, float[] fArray3) {
        if (fArray2[0] == fArray3[0]) {
            if (fArray2[0] < this.paper.B[0]) {
                return fArray2[1] < fArray3[1];
            }
            return fArray2[1] > fArray3[1];
        }
        float f = (fArray3[1] - fArray2[1]) / (fArray3[0] - fArray2[0]);
        float f2 = fArray2[1] - fArray2[0] * f;
        if ((f2 = f * this.paper.B[0] + f2) > this.paper.B[1]) {
            return fArray2[0] < fArray3[0];
        }
        return fArray2[0] > fArray3[0];
    }

    public void transform(ChartMatrix chartMatrix) {
        this.xTickPos.transform(chartMatrix);
        this.xLabelPos.transform(chartMatrix);
        this.yTickPos.transform(chartMatrix);
        this.zTickPos.transform(chartMatrix);
        this.zLabelPos.transform(chartMatrix);
        this.floorFace.transform(chartMatrix);
        this.originYFace.transform(chartMatrix);
    }

    public void locate() {
        this.compass = this.paper.getCompass();
        this.xTickPos.clear();
        this.xLabelPos.clear();
        this.yTickPos.clear();
        this.zTickPos.clear();
        this.zLabelPos.clear();
        this.floorFace.clear();
        this.originYFace.clear();
        float[] fArray2 = this.paper.getLength();
        this.xLen = fArray2[0];
        this.yLen = fArray2[1];
        this.zLen = fArray2[2];
        this.unit = this.paper.getUnit();
        this.floorFace.addVertex(0.0f, 0.0f, 0.0f);
        this.floorFace.addVertex(this.xLen, 0.0f, 0.0f);
        this.floorFace.addVertex(this.xLen, 0.0f, this.zLen);
        this.floorFace.addVertex(0.0f, 0.0f, this.zLen);
        this.originY = this.paper.getOriginY();
        this.originYFace.clear();
        this.originYFace.addVertex(0.0f, this.paper.availableOriginY(this.originY), 0.0f);
        this.originYFace.addVertex(this.xLen, this.paper.availableOriginY(this.originY), 0.0f);
        this.originYFace.addVertex(this.xLen, this.paper.availableOriginY(this.originY), this.zLen);
        this.originYFace.addVertex(0.0f, this.paper.availableOriginY(this.originY), this.zLen);
        this.axisZ();
        this.clear();
        this.compass();
    }

    private void axisZ() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        String[] stringArray = this.axisX.getLabels();
        if (stringArray != null) {
            if (this.axisX.isLineUnit()) {
                f = 0.0f;
                int n = 0;
                while (n < stringArray.length) {
                    this.xTickPos.addVertex(f, f2, f3);
                    this.xTickPos.addVertex(f, f2, this.zLen);
                    this.xTickPos.addVertex(f, this.yLen, this.zLen);
                    this.xTickPos.addVertex(f, this.yLen, f3);
                    f += this.unit[0];
                    ++n;
                }
                this.xLabelPos = this.xTickPos;
            } else {
                f = 0.0f;
                int n = 0;
                while (n <= stringArray.length) {
                    this.xTickPos.addVertex(f, f2, f3);
                    this.xTickPos.addVertex(f, f2, this.zLen);
                    this.xTickPos.addVertex(f, this.yLen, this.zLen);
                    this.xTickPos.addVertex(f, this.yLen, f3);
                    f += this.unit[0];
                    ++n;
                }
                f = this.unit[0] / 2.0f;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.xLabelPos.addVertex(f, f2, f3);
                    this.xLabelPos.addVertex(f, f2, this.zLen);
                    this.xLabelPos.addVertex(f, this.yLen, this.zLen);
                    this.xLabelPos.addVertex(f, this.yLen, f3);
                    f += this.unit[0];
                    ++n2;
                }
            }
        }
    }

    private void clear() {
        float f = (float)this.axisY.getTickPace() * this.unit[1];
        float f2 = (float)(-(this.axisY.getMin() - this.axisY.getLabelStartValue())) * this.unit[1];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n = this.axisY.getNumOfTick();
        f4 = f2;
        int n2 = 0;
        while (n2 <= n) {
            this.yTickPos.addVertex(f3, f4, f5);
            this.yTickPos.addVertex(this.xLen, f4, f5);
            this.yTickPos.addVertex(this.xLen, f4, this.zLen);
            this.yTickPos.addVertex(f3, f4, this.zLen);
            f4 += f;
            ++n2;
        }
    }

    private void compass() {
        this.unit[2] = this.axisZ.getUnit(this.zLen);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        String[] stringArray = this.axisZ.getLabels();
        if (stringArray != null) {
            if (this.axisZ.isLineUnit()) {
                f3 = 0.0f;
                int n = 0;
                while (n < stringArray.length) {
                    this.zTickPos.addVertex(f, f2, f3);
                    this.zTickPos.addVertex(this.xLen, f2, f3);
                    this.zTickPos.addVertex(this.xLen, this.yLen, f3);
                    this.zTickPos.addVertex(f, this.yLen, f3);
                    f3 += this.unit[2];
                    ++n;
                }
                this.zLabelPos = this.zTickPos;
            } else {
                f3 = 0.0f;
                int n = 0;
                while (n <= stringArray.length) {
                    this.zTickPos.addVertex(f, f2, f3);
                    this.zTickPos.addVertex(this.xLen, f2, f3);
                    this.zTickPos.addVertex(this.xLen, this.yLen, f3);
                    this.zTickPos.addVertex(f, this.yLen, f3);
                    f3 += this.unit[2];
                    ++n;
                }
                f3 = this.unit[2] / 2.0f;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.zLabelPos.addVertex(f, f2, f3);
                    this.zLabelPos.addVertex(this.xLen, f2, f3);
                    this.zLabelPos.addVertex(this.xLen, this.yLen, f3);
                    this.zLabelPos.addVertex(f, this.yLen, f3);
                    f3 += this.unit[2];
                    ++n2;
                }
            }
        }
    }

    protected int[] getStake() {
        this.shownFace = this.paper.getShownFace();
        int[] nArray = new int[]{this.append(this.shownFace), this.availableOriginY(this.shownFace), this.axisX(this.shownFace)};
        return nArray;
    }

    public GeneralPath getGridXAreaPath() {
        return this.getAngleY;
    }

    public GeneralPath getGridYAreaPath() {
        return this.getAxisXProperties;
    }

    public GeneralPath getGridZAreaPath() {
        return this.getAxisYProperties;
    }

    public boolean searchSelectedGridX(int n, int n2) {
        return this.getAngleY.intersects(n - 5, n2 - 5, 10.0, 10.0);
    }

    public boolean searchSelectedGridY(int n, int n2) {
        return this.getAxisXProperties.intersects(n - 5, n2 - 5, 10.0, 10.0);
    }

    public boolean searchSelectedGridZ(int n, int n2) {
        return this.getAxisYProperties.intersects(n - 5, n2 - 5, 10.0, 10.0);
    }
}

